/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchMode;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.data.osm.search.SearchSetting;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSException;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetSelector;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class SearchDialog
extends ExtendedDialog {
    private final SearchSetting searchSettings;
    private final HistoryComboBox hcbSearchString = new HistoryComboBox();
    private JCheckBox addOnToolbar;
    private JCheckBox caseSensitive;
    private JCheckBox allElements;
    private JRadioButton standardSearch;
    private JRadioButton regexSearch;
    private JRadioButton mapCSSSearch;
    private JRadioButton replace;
    private JRadioButton add;
    private JRadioButton remove;
    private JRadioButton inSelection;

    public SearchDialog(SearchSetting initialValues, List<String> searchExpressionHistory, boolean expertMode) {
        super((Component)MainApplication.getMainFrame(), initialValues instanceof Filter ? I18n.tr("Filter", new Object[0]) : I18n.tr("Search", new Object[0]), initialValues instanceof Filter ? I18n.tr("Submit filter", new Object[0]) : I18n.tr("Search", new Object[0]), I18n.tr("Cancel", new Object[0]));
        this.searchSettings = new SearchSetting(initialValues);
        this.setButtonIcons("dialogs/search", "cancel");
        this.configureContextsensitiveHelp("/Action/Search", true);
        this.setContent(this.buildPanel(searchExpressionHistory, expertMode));
    }

    private JPanel buildPanel(List<String> searchExpressionHistory, boolean expertMode) {
        JLabel label = new JLabel(this.searchSettings instanceof Filter ? I18n.tr("Filter string:", new Object[0]) : I18n.tr("Search string:", new Object[0]));
        final String tooltip = I18n.tr("Enter the search expression", new Object[0]);
        this.hcbSearchString.setText(this.searchSettings.text);
        this.hcbSearchString.setToolTipText(tooltip);
        this.hcbSearchString.setPossibleItemsTopDown(searchExpressionHistory);
        this.hcbSearchString.setPreferredSize(new Dimension(40, this.hcbSearchString.getPreferredSize().height));
        label.setLabelFor(this.hcbSearchString);
        this.replace = new JRadioButton(I18n.tr("select", new Object[0]), this.searchSettings.mode == SearchMode.replace);
        this.add = new JRadioButton(I18n.tr("add to selection", new Object[0]), this.searchSettings.mode == SearchMode.add);
        this.remove = new JRadioButton(I18n.tr("remove from selection", new Object[0]), this.searchSettings.mode == SearchMode.remove);
        this.inSelection = new JRadioButton(I18n.tr("find in selection", new Object[0]), this.searchSettings.mode == SearchMode.in_selection);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.replace);
        bg.add(this.add);
        bg.add(this.remove);
        bg.add(this.inSelection);
        this.caseSensitive = new JCheckBox(I18n.tr("case sensitive", new Object[0]), this.searchSettings.caseSensitive);
        this.allElements = new JCheckBox(I18n.tr("all objects", new Object[0]), this.searchSettings.allElements);
        this.allElements.setToolTipText(I18n.tr("Also include incomplete and deleted objects in search.", new Object[0]));
        this.addOnToolbar = new JCheckBox(I18n.tr("add toolbar button", new Object[0]), false);
        this.addOnToolbar.setToolTipText(I18n.tr("Add a button with this search expression to the toolbar.", new Object[0]));
        this.standardSearch = new JRadioButton(I18n.tr("standard", new Object[0]), !this.searchSettings.regexSearch && !this.searchSettings.mapCSSSearch);
        this.regexSearch = new JRadioButton(I18n.tr("regular expression", new Object[0]), this.searchSettings.regexSearch);
        this.mapCSSSearch = new JRadioButton(I18n.tr("MapCSS selector", new Object[0]), this.searchSettings.mapCSSSearch);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.standardSearch);
        bg2.add(this.regexSearch);
        bg2.add(this.mapCSSSearch);
        JPanel selectionSettings = new JPanel(new GridBagLayout());
        selectionSettings.setBorder(BorderFactory.createTitledBorder(I18n.tr("Results", new Object[0])));
        selectionSettings.add((Component)this.replace, GBC.eol().anchor(17).fill(2));
        selectionSettings.add((Component)this.add, GBC.eol());
        selectionSettings.add((Component)this.remove, GBC.eol());
        selectionSettings.add((Component)this.inSelection, GBC.eop());
        JPanel additionalSettings = new JPanel(new GridBagLayout());
        additionalSettings.setBorder(BorderFactory.createTitledBorder(I18n.tr("Options", new Object[0])));
        additionalSettings.add((Component)this.caseSensitive, GBC.eol().anchor(17).fill(2));
        JPanel left = new JPanel(new GridBagLayout());
        left.add((Component)selectionSettings, GBC.eol().fill(1));
        left.add((Component)additionalSettings, GBC.eol().fill(1));
        if (expertMode) {
            additionalSettings.add((Component)this.allElements, GBC.eol());
            additionalSettings.add((Component)this.addOnToolbar, GBC.eop());
            JPanel searchOptions = new JPanel(new GridBagLayout());
            searchOptions.setBorder(BorderFactory.createTitledBorder(I18n.tr("Search syntax", new Object[0])));
            searchOptions.add((Component)this.standardSearch, GBC.eol().anchor(17).fill(2));
            searchOptions.add((Component)this.regexSearch, GBC.eol());
            searchOptions.add((Component)this.mapCSSSearch, GBC.eol());
            left.add((Component)searchOptions, GBC.eol().fill(1));
        }
        JPanel right = SearchDialog.buildHintsSection(this.hcbSearchString, expertMode);
        JPanel top = new JPanel(new GridBagLayout());
        top.add((Component)label, GBC.std().insets(0, 0, 5, 0));
        top.add((Component)this.hcbSearchString, GBC.eol().fill(2));
        JTextField editorComponent = this.hcbSearchString.getEditorComponent();
        Document document = editorComponent.getDocument();
        AbstractTextComponentValidator validator = new AbstractTextComponentValidator(editorComponent){

            @Override
            public void validate() {
                if (!this.isValid()) {
                    this.feedbackInvalid(I18n.tr("Invalid search expression", new Object[0]));
                } else {
                    this.feedbackValid(tooltip);
                }
            }

            @Override
            public boolean isValid() {
                try {
                    SearchSetting ss = new SearchSetting();
                    ss.text = SearchDialog.this.hcbSearchString.getText();
                    ss.caseSensitive = SearchDialog.this.caseSensitive.isSelected();
                    ss.regexSearch = SearchDialog.this.regexSearch.isSelected();
                    ss.mapCSSSearch = SearchDialog.this.mapCSSSearch.isSelected();
                    SearchCompiler.compile(ss);
                    return true;
                }
                catch (SearchParseError | MapCSSException e) {
                    Logging.trace(e);
                    return false;
                }
            }
        };
        document.addDocumentListener(validator);
        ItemListener validateActionListener = e -> {
            if (e.getStateChange() == 1) {
                validator.validate();
            }
        };
        this.standardSearch.addItemListener(validateActionListener);
        this.regexSearch.addItemListener(validateActionListener);
        this.mapCSSSearch.addItemListener(validateActionListener);
        TaggingPresetSelector selector = new TaggingPresetSelector(false, false);
        selector.setBorder(BorderFactory.createTitledBorder(I18n.tr("Search by preset", new Object[0])));
        selector.setDblClickListener(ev -> SearchDialog.setPresetDblClickListener(selector, editorComponent));
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)top, GBC.eol().fill(2).insets(5, 5, 5, 0));
        p.add((Component)left, GBC.std().anchor(11).insets(5, 10, 10, 0).fill(3));
        p.add((Component)right, GBC.std().fill(1).insets(0, 10, 0, 0));
        p.add((Component)selector, GBC.eol().fill(1).insets(0, 10, 0, 0));
        return p;
    }

    @Override
    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        if (buttonIndex == 0) {
            try {
                SearchSetting ss = new SearchSetting();
                ss.text = this.hcbSearchString.getText();
                ss.caseSensitive = this.caseSensitive.isSelected();
                ss.regexSearch = this.regexSearch.isSelected();
                ss.mapCSSSearch = this.mapCSSSearch.isSelected();
                SearchCompiler.compile(ss);
                super.buttonAction(buttonIndex, evt);
            }
            catch (SearchParseError | MapCSSException e) {
                Logging.debug(e);
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), "<html>" + I18n.tr("Search expression is not valid: \n\n {0}", e.getMessage().replace("<html>", "").replace("</html>", "")).replace("\n", "<br>") + "</html>", I18n.tr("Invalid search expression", new Object[0]), 0);
            }
        } else {
            super.buttonAction(buttonIndex, evt);
        }
    }

    public SearchSetting getSearchSettings() {
        this.searchSettings.text = this.hcbSearchString.getText();
        this.searchSettings.caseSensitive = this.caseSensitive.isSelected();
        this.searchSettings.allElements = this.allElements.isSelected();
        this.searchSettings.regexSearch = this.regexSearch.isSelected();
        this.searchSettings.mapCSSSearch = this.mapCSSSearch.isSelected();
        this.searchSettings.mode = this.inSelection.isSelected() ? SearchMode.in_selection : (this.replace.isSelected() ? SearchMode.replace : (this.add.isSelected() ? SearchMode.add : SearchMode.remove));
        return this.searchSettings;
    }

    public boolean isAddOnToolbar() {
        return this.addOnToolbar.isSelected();
    }

    private static JPanel buildHintsSection(HistoryComboBox hcbSearchString, boolean expertMode) {
        JPanel hintPanel = new JPanel(new GridBagLayout());
        hintPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr("Hints", new Object[0])));
        hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("basics", new Object[0])).addKeyword(I18n.tr("Baker Street", new Object[0]), null, I18n.tr("''Baker'' and ''Street'' in any key", new Object[0]), new String[0]).addKeyword(I18n.tr("\"Baker Street\"", new Object[0]), "\"\"", I18n.tr("''Baker Street'' in any key", new Object[0]), new String[0]).addKeyword("<i>key</i>:<i>valuefragment</i>", null, I18n.tr("''valuefragment'' anywhere in ''key''", new Object[0]), I18n.trc("search string example", "name:str matches name=Bakerstreet")).addKeyword("-<i>key</i>:<i>valuefragment</i>", null, I18n.tr("''valuefragment'' nowhere in ''key''", new Object[0]), new String[0]), GBC.eol());
        hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addKeyword("<i>key</i>", null, I18n.tr("matches if ''key'' exists", new Object[0]), new String[0]).addKeyword("<i>key</i>=<i>value</i>", null, I18n.tr("''key'' with exactly ''value''", new Object[0]), new String[0]).addKeyword("<i>key</i>=*", null, I18n.tr("''key'' with any value", new Object[0]), new String[0]).addKeyword("<i>key</i>=", null, I18n.tr("''key'' with empty value", new Object[0]), new String[0]).addKeyword("*=<i>value</i>", null, I18n.tr("''value'' in any key", new Object[0]), new String[0]).addKeyword("<i>key</i>><i>value</i>", null, I18n.tr("matches if ''key'' is greater than ''value'' (analogously, less than)", new Object[0]), new String[0]).addKeyword("\"key\"=\"value\"", "\"\"=\"\"", I18n.tr("to quote operators.<br>Within quoted strings the <b>\"</b> and <b>\\</b> characters need to be escaped by a preceding <b>\\</b> (e.g. <b>\\\"</b> and <b>\\\\</b>).", new Object[0]), I18n.trc("search string example", "name=\"Baker Street\""), "\"addr:street\""), GBC.eol().anchor(10));
        hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("combinators", new Object[0])).addKeyword("<i>expr</i> <i>expr</i>", null, I18n.tr("logical and (both expressions have to be satisfied)", new Object[0]), I18n.trc("search string example", "Baker Street")).addKeyword("<i>expr</i> | <i>expr</i>", "| ", I18n.tr("logical or (at least one expression has to be satisfied)", new Object[0]), new String[0]).addKeyword("<i>expr</i> OR <i>expr</i>", "OR ", I18n.tr("logical or (at least one expression has to be satisfied)", new Object[0]), new String[0]).addKeyword("-<i>expr</i>", null, I18n.tr("logical not", new Object[0]), new String[0]).addKeyword("(<i>expr</i>)", "()", I18n.tr("use parenthesis to group expressions", new Object[0]), new String[0]), GBC.eol());
        if (expertMode) {
            hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("objects", new Object[0])).addKeyword("type:node", "type:node ", I18n.tr("all nodes", new Object[0]), new String[0]).addKeyword("type:way", "type:way ", I18n.tr("all ways", new Object[0]), new String[0]).addKeyword("type:relation", "type:relation ", I18n.tr("all relations", new Object[0]), new String[0]).addKeyword("closed", "closed ", I18n.tr("all closed ways", new Object[0]), new String[0]).addKeyword("untagged", "untagged ", I18n.tr("object without useful tags", new Object[0]), new String[0]), GBC.eol());
            hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addKeyword("preset:\"Annotation/Address\"", "preset:\"Annotation/Address\"", I18n.tr("all objects that use the address preset", new Object[0]), new String[0]).addKeyword("preset:\"Geography/Nature/*\"", "preset:\"Geography/Nature/*\"", I18n.tr("all objects that use any preset under the Geography/Nature group", new Object[0]), new String[0]), GBC.eol().anchor(10));
            hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("metadata", new Object[0])).addKeyword("user:", "user:", I18n.tr("objects changed by author", new Object[0]), I18n.trc("search string example", "user:<i>OSM username</i> (objects with the author <i>OSM username</i>)"), I18n.trc("search string example", "user:anonymous (objects without an assigned author)")).addKeyword("id:", "id:", I18n.tr("objects with given ID", new Object[0]), I18n.trc("search string example", "id:0 (new objects)")).addKeyword("version:", "version:", I18n.tr("objects with given version", new Object[0]), I18n.trc("search string example", "version:0 (objects without an assigned version)")).addKeyword("changeset:", "changeset:", I18n.tr("objects with given changeset ID", new Object[0]), I18n.trc("search string example", "changeset:0 (objects without an assigned changeset)")).addKeyword("timestamp:", "timestamp:", I18n.tr("objects with last modification timestamp within range", new Object[0]), "timestamp:2012/", "timestamp:2008/2011-02-04T12"), GBC.eol());
            hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("properties", new Object[0])).addKeyword("nodes:<i>20-</i>", "nodes:", I18n.tr("ways with at least 20 nodes, or relations containing at least 20 nodes", new Object[0]), new String[0]).addKeyword("ways:<i>3-</i>", "ways:", I18n.tr("nodes with at least 3 referring ways, or relations containing at least 3 ways", new Object[0]), new String[0]).addKeyword("tags:<i>5-10</i>", "tags:", I18n.tr("objects having 5 to 10 tags", new Object[0]), new String[0]).addKeyword("role:", "role:", I18n.tr("objects with given role in a relation", new Object[0]), new String[0]).addKeyword("areasize:<i>-100</i>", "areasize:", I18n.tr("closed ways with an area of 100 m\u00b2", new Object[0]), new String[0]).addKeyword("waylength:<i>200-</i>", "waylength:", I18n.tr("ways with a length of 200 m or more", new Object[0]), new String[0]), GBC.eol());
            hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("state", new Object[0])).addKeyword("modified", "modified ", I18n.tr("all modified objects", new Object[0]), new String[0]).addKeyword("new", "new ", I18n.tr("all new objects", new Object[0]), new String[0]).addKeyword("selected", "selected ", I18n.tr("all selected objects", new Object[0]), new String[0]).addKeyword("incomplete", "incomplete ", I18n.tr("all incomplete objects", new Object[0]), new String[0]).addKeyword("deleted", "deleted ", I18n.tr("all deleted objects (checkbox <b>{0}</b> must be enabled)", I18n.tr("all objects", new Object[0])), new String[0]), GBC.eol());
            hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("related objects", new Object[0])).addKeyword("child <i>expr</i>", "child ", I18n.tr("all children of objects matching the expression", new Object[0]), "child building").addKeyword("parent <i>expr</i>", "parent ", I18n.tr("all parents of objects matching the expression", new Object[0]), "parent bus_stop").addKeyword("hasRole:<i>stop</i>", "hasRole:", I18n.tr("relation containing a member of role <i>stop</i>", new Object[0]), new String[0]).addKeyword("role:<i>stop</i>", "role:", I18n.tr("objects being part of a relation as role <i>stop</i>", new Object[0]), new String[0]).addKeyword("nth:<i>7</i>", "nth:", I18n.tr("n-th member of relation and/or n-th node of way", new Object[0]), "nth:5 (child type:relation)", "nth:-1").addKeyword("nth%:<i>7</i>", "nth%:", I18n.tr("every n-th member of relation and/or every n-th node of way", new Object[0]), "nth%:100 (child waterway)"), GBC.eol());
            hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("view", new Object[0])).addKeyword("inview", "inview ", I18n.tr("objects in current view", new Object[0]), new String[0]).addKeyword("allinview", "allinview ", I18n.tr("objects (and all its way nodes / relation members) in current view", new Object[0]), new String[0]).addKeyword("indownloadedarea", "indownloadedarea ", I18n.tr("objects in downloaded area", new Object[0]), new String[0]).addKeyword("allindownloadedarea", "allindownloadedarea ", I18n.tr("objects (and all its way nodes / relation members) in downloaded area", new Object[0]), new String[0]), GBC.eol());
        }
        return hintPanel;
    }

    private static void setPresetDblClickListener(TaggingPresetSelector selector, JTextComponent searchEditor) {
        TaggingPreset selectedPreset = selector.getSelectedPresetAndUpdateClassification();
        if (selectedPreset == null) {
            return;
        }
        searchEditor.requestFocusInWindow();
        SwingUtilities.invokeLater(() -> {
            int textOffset = searchEditor.getCaretPosition();
            String presetSearchQuery = " preset:\"" + selectedPreset.getRawName() + "\"";
            try {
                searchEditor.getDocument().insertString(textOffset, presetSearchQuery, null);
            }
            catch (BadLocationException e1) {
                throw new JosmRuntimeException(e1.getMessage(), e1);
            }
        });
    }

    private static class SearchKeywordRow
    extends JPanel {
        private final HistoryComboBox hcb;

        SearchKeywordRow(HistoryComboBox hcb) {
            super(new FlowLayout(0));
            this.hcb = hcb;
        }

        public SearchKeywordRow addTitle(String title) {
            this.add(new JLabel(I18n.tr("{0}: ", title)));
            return this;
        }

        public SearchKeywordRow addKeyword(String displayText, final String insertText, String description, String ... examples) {
            JLabel label = new JLabel("<html><style>td{border:1px solid gray; font-weight:normal;}</style><table><tr><td>" + displayText + "</td></tr></table></html>");
            this.add(label);
            if (description != null || examples.length > 0) {
                label.setToolTipText("<html>" + description + (examples.length > 0 ? Utils.joinAsHtmlUnorderedList(Arrays.asList(examples)) : "") + "</html>");
            }
            if (insertText != null) {
                label.setCursor(Cursor.getPredefinedCursor(12));
                label.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        JTextField tf = hcb.getEditorComponent();
                        if (!tf.hasFocus()) {
                            tf.requestFocusInWindow();
                        }
                        SwingUtilities.invokeLater(() -> {
                            try {
                                tf.getDocument().insertString(tf.getCaretPosition(), ' ' + insertText, null);
                            }
                            catch (BadLocationException ex) {
                                throw new JosmRuntimeException(ex.getMessage(), ex);
                            }
                        });
                    }
                });
            }
            return this;
        }
    }
}

