/*

   Copyright (C) 2001,2002,2003,2004 Michael Rubinstein

   This file is part of the L-function package L.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   Check the License for details. You should have received a copy of it, along
   with the package; see the file 'COPYING'. If not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/



    //Computes N(T) without S(T) and to within O(1/T)
    //(N(T) is the number of zeros in the critical strip with |t|<T)
    template <class ttype>
    Double L_function <ttype>::
    N(Double T)
    {
        Double x;
        int i;

        x=T*log(Q)*2/Pi; //contribution from the conductor

        //contribution from the gamma factors
        for(i=1;i<=a;i++){
            x=x+imag(log_GAMMA( (.5+I*T)*gamma[i]+lambda[i] )
            -log_GAMMA( (.5-I*T)*gamma[i]+lambda[i] )) /Pi;
        }

        // contribution from the pole at s=1 if there is one
        // (actually considers poles on the line Re_s=1)
        for(i=1;i<=number_of_poles;i++)
          if(real(pole[i])>-10E-7&&real(pole[i])<1+10E-7) x=x+1;

        return x;

    }                                       
