/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

import com.gitlab.pdftk_java.LoadableInt;
import com.gitlab.pdftk_java.LoadableString;
import com.gitlab.pdftk_java.PdfBookmark;
import com.gitlab.pdftk_java.PdfPageLabel;
import com.gitlab.pdftk_java.PdfPageMedia;
import com.gitlab.pdftk_java.bookmarks;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Scanner;
import org.apache.commons.lang3.StringEscapeUtils;
import pdftk.com.lowagie.text.Rectangle;
import pdftk.com.lowagie.text.pdf.PRIndirectReference;
import pdftk.com.lowagie.text.pdf.PdfArray;
import pdftk.com.lowagie.text.pdf.PdfDictionary;
import pdftk.com.lowagie.text.pdf.PdfName;
import pdftk.com.lowagie.text.pdf.PdfNumber;
import pdftk.com.lowagie.text.pdf.PdfObject;
import pdftk.com.lowagie.text.pdf.PdfReader;
import pdftk.com.lowagie.text.pdf.PdfString;

class data_import {
    data_import() {
    }

    static PdfData LoadDataFile(InputStream input_stream) {
        boolean eof;
        PdfData pdf_data_p = new PdfData();
        Scanner ifs = new Scanner(input_stream);
        String buff = "";
        String buff_prev = "";
        int buff_prev_len = 0;
        PdfInfo info = new PdfInfo();
        boolean info_b = false;
        PdfBookmark bookmark = new PdfBookmark();
        boolean bookmark_b = false;
        PdfPageLabel pagelabel = new PdfPageLabel();
        boolean pagelabel_b = false;
        PdfPageMedia pagemedia = new PdfPageMedia();
        boolean pagemedia_b = false;
        boolean bl = eof = !ifs.hasNextLine();
        while (!eof) {
            eof = !ifs.hasNextLine();
            buff = eof ? "" : ifs.nextLine();
            if (eof || buff.startsWith("InfoBegin") || buff.startsWith("BookmarkBegin") || buff.startsWith("PageLabelBegin") || buff.startsWith("PageMediaBegin") || !buff_prev.isEmpty() && !buff.startsWith(buff_prev)) {
                if (info_b) {
                    if (info.valid()) {
                        pdf_data_p.m_info.add(info);
                    } else {
                        System.err.println("pdftk Warning: data info record not valid -- skipped; data:");
                        System.err.print(info);
                    }
                } else if (bookmark_b) {
                    if (bookmark.valid()) {
                        pdf_data_p.m_bookmarks.add(bookmark);
                    } else {
                        System.err.println("pdftk Warning: data bookmark record not valid -- skipped; data:");
                        System.err.print(bookmark);
                    }
                } else if (pagelabel_b) {
                    if (pagelabel.valid()) {
                        pdf_data_p.m_pagelabels.add(pagelabel);
                    } else {
                        System.err.println("pdftk Warning: page label record not valid -- skipped; data:");
                        System.err.print(pagelabel);
                    }
                } else if (pagemedia_b) {
                    if (pagemedia.valid()) {
                        pdf_data_p.m_pagemedia.add(pagemedia);
                    } else {
                        System.err.println("pdftk Warning: page media record not valid -- skipped; data:");
                        System.err.print(pagemedia);
                    }
                }
                buff_prev = "";
                buff_prev_len = 0;
                info = new PdfInfo();
                info_b = false;
                bookmark = new PdfBookmark();
                bookmark_b = false;
                pagelabel = new PdfPageLabel();
                pagelabel_b = false;
                pagemedia = new PdfPageMedia();
                pagemedia_b = false;
            }
            if (buff.isEmpty() || buff.startsWith("#")) continue;
            if (buff.startsWith("Info")) {
                buff_prev_len = "Info".length();
                info_b = true;
                if (!(buff.startsWith("InfoBegin") || info.loadKey(buff) || info.loadValue(buff))) {
                    System.err.println("pdftk Warning: unexpected Info case in LoadDataFile(); continuing");
                }
            } else if (buff.startsWith("Bookmark")) {
                buff_prev_len = "Bookmark".length();
                bookmark_b = true;
                if (!(buff.startsWith("BookmarkBegin") || bookmark.loadTitle(buff) || bookmark.loadLevel(buff) || bookmark.loadPageNum(buff))) {
                    System.err.println("pdftk Warning: unexpected Bookmark case in LoadDataFile(); continuing");
                }
            } else if (buff.startsWith("PageLabel")) {
                buff_prev_len = "PageLabel".length();
                pagelabel_b = true;
                if (!(buff.startsWith("PageLabelBegin") || pagelabel.loadNewIndex(buff) || pagelabel.loadStart(buff) || pagelabel.loadPrefix(buff) || pagelabel.loadNumStyle(buff))) {
                    System.err.println("pdftk Warning: unexpected PageLabel case in LoadDataFile(); continuing");
                }
            } else if (buff.startsWith("PageMedia")) {
                buff_prev_len = "PageMedia".length();
                pagemedia_b = true;
                if (!(buff.startsWith("PageMediaBegin") || pagemedia.loadNumber(buff) || pagemedia.loadRotation(buff) || pagemedia.loadRect(buff) || pagemedia.loadCrop(buff))) {
                    System.err.println("pdftk Warning: unexpected PageMedia case in LoadDataFile(); continuing");
                }
            } else if (buff.startsWith("PdfID")) {
                buff_prev_len = 0;
                if (!pdf_data_p.loadID0(buff) && !pdf_data_p.loadID1(buff)) {
                    System.err.println("pdftk Warning: unexpected PdfID case in LoadDataFile(); continuing");
                }
            } else if (pdf_data_p.loadNumPages(buff)) {
                buff_prev_len = 0;
            } else {
                System.err.println("pdftk Warning: unexpected case 1 in LoadDataFile(); continuing");
            }
            buff_prev = buff.substring(0, buff_prev_len);
        }
        if (buff_prev_len != 0) {
            System.err.println("pdftk Warning in LoadDataFile(): incomplete record;");
        }
        return pdf_data_p;
    }

    static PdfArray toPdfArray(Rectangle r) {
        if (r == null) {
            return new PdfArray();
        }
        return new PdfArray(new float[]{r.left(), r.bottom(), r.right(), r.top()});
    }

    static boolean UpdateInfo(PdfReader reader_p, InputStream ifs, boolean utf8_b) {
        boolean ret_val_b = true;
        PdfData pdf_data = data_import.LoadDataFile(ifs);
        if (pdf_data == null) {
            System.err.println("pdftk Error in UpdateInfo(): LoadDataFile() failure;");
            return false;
        }
        PdfDictionary trailer_p = reader_p.getTrailer();
        if (trailer_p != null) {
            PdfObject root_po = PdfReader.getPdfObject(trailer_p.get(PdfName.ROOT));
            if (root_po != null && root_po.isDictionary()) {
                PdfDictionary outlines_p;
                PdfDictionary root_p = (PdfDictionary)root_po;
                if (!pdf_data.m_bookmarks.isEmpty() && (outlines_p = new PdfDictionary(PdfName.OUTLINES)) != null) {
                    PRIndirectReference outlines_ref_p = reader_p.getPRIndirectReference(outlines_p);
                    int num_bookmarks_total = bookmarks.BuildBookmarks(reader_p, pdf_data.m_bookmarks.listIterator(), outlines_p, outlines_ref_p, 0, utf8_b);
                    if (root_p.contains(PdfName.OUTLINES)) {
                        PdfObject old_outlines_p = PdfReader.getPdfObject(root_p.get(PdfName.OUTLINES));
                        if (old_outlines_p != null && old_outlines_p.isDictionary()) {
                            bookmarks.RemoveBookmarks(reader_p, (PdfDictionary)old_outlines_p);
                        }
                    }
                    root_p.put(PdfName.OUTLINES, outlines_ref_p);
                }
                if (!pdf_data.m_pagelabels.isEmpty()) {
                    PdfDictionary pagelabels_p = PdfPageLabel.BuildPageLabels(pdf_data.m_pagelabels);
                    PRIndirectReference pagelabels_ref_p = reader_p.getPRIndirectReference(pagelabels_p);
                    root_p.put(PdfName.PAGELABELS, pagelabels_ref_p);
                }
            } else {
                System.err.println("pdftk Error in UpdateInfo(): no Root dictionary found;");
                ret_val_b = false;
            }
            for (PdfPageMedia pagemedia : pdf_data.m_pagemedia) {
                PdfDictionary page_p = reader_p.getPageN(pagemedia.m_number);
                if (page_p != null) {
                    if (pagemedia.m_rotation >= 0) {
                        page_p.put(PdfName.ROTATE, new PdfNumber(pagemedia.m_rotation));
                    }
                    if (pagemedia.m_rect != null) {
                        page_p.put(PdfName.MEDIABOX, data_import.toPdfArray(pagemedia.m_rect));
                    }
                    if (pagemedia.m_crop == null) continue;
                    page_p.put(PdfName.CROPBOX, data_import.toPdfArray(pagemedia.m_crop));
                    continue;
                }
                System.err.println("pdftk Error in UpdateInfo(): page " + pagemedia.m_number + " not found;");
                ret_val_b = false;
            }
            if (!pdf_data.m_info.isEmpty()) {
                PdfObject info_po = PdfReader.getPdfObject(trailer_p.get(PdfName.INFO));
                if (info_po != null && info_po.isDictionary()) {
                    PdfDictionary info_p = (PdfDictionary)info_po;
                    for (PdfInfo it : pdf_data.m_info) {
                        if (it.m_value.isEmpty()) {
                            info_p.remove(new PdfName(it.m_key));
                            continue;
                        }
                        if (utf8_b) {
                            info_p.put(new PdfName(it.m_key), new PdfString(it.m_value));
                            continue;
                        }
                        String jvs = data_import.XmlStringToJcharArray(it.m_value);
                        info_p.put(new PdfName(it.m_key), new PdfString(jvs));
                    }
                } else {
                    System.err.println("pdftk Error in UpdateInfo(): no Info dictionary found;");
                    ret_val_b = false;
                }
            }
        } else {
            System.err.println("pdftk Error in UpdateInfo(): no document trailer found;");
            ret_val_b = false;
        }
        return ret_val_b;
    }

    static String XmlStringToJcharArray(String jvs) {
        return StringEscapeUtils.unescapeXml((String)jvs);
    }

    static class PdfData {
        ArrayList<PdfInfo> m_info = new ArrayList();
        ArrayList<PdfBookmark> m_bookmarks = new ArrayList();
        ArrayList<PdfPageLabel> m_pagelabels = new ArrayList();
        ArrayList<PdfPageMedia> m_pagemedia = new ArrayList();
        static final String PREFIX = "PdfID";
        static final String ID_0_LABEL = "PdfID0:";
        static final String ID_1_LABEL = "PdfID1:";
        static final String NUM_PAGES_LABEL = "NumberOfPages:";
        int m_num_pages = -1;
        String m_id_0 = null;
        String m_id_1 = null;

        PdfData() {
        }

        public String toString() {
            StringBuilder ss = new StringBuilder();
            for (PdfInfo pdfInfo : this.m_info) {
                ss.append(pdfInfo);
            }
            ss.append("PdfID0: " + this.m_id_0 + System.lineSeparator());
            ss.append("PdfID1: " + this.m_id_1 + System.lineSeparator());
            ss.append("NumberOfPages: " + this.m_num_pages + System.lineSeparator());
            for (PdfBookmark pdfBookmark : this.m_bookmarks) {
                ss.append(pdfBookmark);
            }
            return ss.toString();
        }

        boolean loadNumPages(String buff) {
            LoadableInt loader = new LoadableInt(this.m_num_pages);
            boolean success = loader.LoadInt(buff, NUM_PAGES_LABEL);
            this.m_num_pages = loader.ii;
            return success;
        }

        boolean loadID0(String buff) {
            LoadableString loader = new LoadableString(this.m_id_0);
            boolean success = loader.LoadString(buff, ID_0_LABEL);
            this.m_id_0 = loader.ss;
            return success;
        }

        boolean loadID1(String buff) {
            LoadableString loader = new LoadableString(this.m_id_1);
            boolean success = loader.LoadString(buff, ID_1_LABEL);
            this.m_id_1 = loader.ss;
            return success;
        }
    }

    static class PdfInfo {
        static final String PREFIX = "Info";
        static final String BEGIN_MARK = "InfoBegin";
        static final String KEY_LABEL = "InfoKey:";
        static final String VALUE_LABEL = "InfoValue:";
        String m_key = null;
        String m_value = null;

        PdfInfo() {
        }

        boolean valid() {
            return this.m_key != null && this.m_value != null;
        }

        public String toString() {
            return BEGIN_MARK + System.lineSeparator() + KEY_LABEL + " " + this.m_key + System.lineSeparator() + VALUE_LABEL + " " + this.m_value + System.lineSeparator();
        }

        boolean loadKey(String buff) {
            LoadableString loader = new LoadableString(this.m_key);
            boolean success = loader.LoadString(buff, KEY_LABEL);
            this.m_key = loader.ss;
            return success;
        }

        boolean loadValue(String buff) {
            LoadableString loader = new LoadableString(this.m_value);
            boolean success = loader.LoadString(buff, VALUE_LABEL);
            this.m_value = loader.ss;
            return success;
        }
    }
}

