12.1 Receiving OSC

# Receiving OSC

By default when Sonic Pi is launched it listens to port 4560 for
incoming OSC messages from programs on the same computer. This means
that without any configuration, you can send Sonic Pi an OSC message and
it will be displayed in the cue log just like incoming MIDI
messages. This also means that any incoming OSC message is also
automatically added to the Time State which means you can also use `get`
and `sync` to work with the incoming data - just like with MIDI and
synchronising `live_loops` - see sections 5.7 and 10.2 to recap how this
works.

## A Basic OSC Listener

Let's build a basic OSC listener:

```
live_loop :foo do
  use_real_time
  a, b, c = sync "/osc*/trigger/prophet"
  synth :prophet, note: a, cutoff: b, sustain: c
end
```

In this example we described an OSC path `"/osc*/trigger/prophet"` which
we're syncing on. This can be any valid OSC path (all letters and
numbers are supported and the `/` is used like in a URL to break up the
path to multiple words). The `/osc` prefix is added by Sonic Pi to all
incoming OSC messages, so we need to send an OSC message with the path
`/trigger/prophet` for our `sync` to stop blocking and the prophet synth
to be triggered.


## Sending OSC to Sonic Pi

We can send OSC to Sonic Pi from any programming language that has an
OSC library. For example, if we're sending OSC from Python we might do
something like this:

```
from pythonosc import osc_message_builder
from pythonosc import udp_client

sender = udp_client.SimpleUDPClient('127.0.0.1', 4560)
sender.send_message('/trigger/prophet', [70, 100, 8])
```

Or, if we're sending OSC from Clojure we might do something like this from the REPL:

```
(use 'overtone.core)
(def c (osc-client "127.0.0.1" 4560))
(osc-send c "/trigger/prophet" 70 100 8)
```

## Receiving from External Machines

For security reasons, by default Sonic Pi does not let remote machines
send it OSC messages. However, you can enable support for remote
machines in Preferences->IO->Network->Receive Remote OSC Messages. Once
you've enabled this, you can receive OSC messages from any computer on
your network. Typically the sending machine will need to know your IP
address (a unique identifier for your computer on your network - kind of
like a phone number or an email address). You can discover the IP
address of your computer by looking at the IO section of the preferences
pane. (If your machine happens to have more than one IP address,
hovering the mouse over the listed address will pop up with a list of
all known addresses).

Note, some programs such as TouchOSC for iPhone and Android support
sending OSC as a standard feature. So, once you're listening to remote
machines and know your IP address you can instantly start sending
messages from apps like TouchOSC which enable you to build your own
custom touch controls with sliders, buttons, dials etc. This can provide
you with an enormous range of input options.
