/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkIOParallelXdmf3ObjectFactory.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef vtkIOParallelXdmf3ObjectFactory_h
#define vtkIOParallelXdmf3ObjectFactory_h

#include "vtkIOParallelXdmf3Module.h" // For export macro
#include "vtkObjectFactory.h"

class VTKIOPARALLELXDMF3_EXPORT vtkIOParallelXdmf3ObjectFactory : public vtkObjectFactory
{
public:
  static vtkIOParallelXdmf3ObjectFactory * New();
  vtkTypeMacro(vtkIOParallelXdmf3ObjectFactory, vtkObjectFactory)

  const char * GetDescription() override { return "vtkIOParallelXdmf3 factory overrides."; }

  const char * GetVTKSourceVersion() override;

  void PrintSelf(ostream &os, vtkIndent indent) override;

protected:
  vtkIOParallelXdmf3ObjectFactory();

private:
  vtkIOParallelXdmf3ObjectFactory(const vtkIOParallelXdmf3ObjectFactory&) = delete;
  void operator=(const vtkIOParallelXdmf3ObjectFactory&) = delete;
};

#endif // vtkIOParallelXdmf3ObjectFactory_h
