/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.lookup.PainlessCast;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStoreable;
import org.elasticsearch.painless.node.EBinary;
import org.elasticsearch.painless.node.EConstant;

public final class EAssignment
extends AExpression {
    private AExpression lhs;
    private AExpression rhs;
    private final boolean pre;
    private final boolean post;
    private Operation operation;
    private boolean cat = false;
    private Class<?> promote = null;
    private Class<?> shiftDistance;
    private PainlessCast there = null;
    private PainlessCast back = null;

    public EAssignment(Location location, AExpression lhs, AExpression rhs, boolean pre, boolean post, Operation operation) {
        super(location);
        this.lhs = Objects.requireNonNull(lhs);
        this.rhs = rhs;
        this.pre = pre;
        this.post = post;
        this.operation = operation;
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.lhs.extractVariables(variables);
        if (this.rhs != null) {
            this.rhs.extractVariables(variables);
        }
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        this.analyzeLHS(scriptRoot, locals);
        this.analyzeIncrDecr();
        if (this.operation != null) {
            this.analyzeCompound(scriptRoot, locals);
        } else if (this.rhs != null) {
            this.analyzeSimple(scriptRoot, locals);
        } else {
            throw new IllegalStateException("Illegal tree structure.");
        }
    }

    private void analyzeLHS(ScriptRoot scriptRoot, Locals locals) {
        if (!(this.lhs instanceof AStoreable)) {
            throw new IllegalArgumentException("Left-hand side cannot be assigned a value.");
        }
        AStoreable lhs = (AStoreable)this.lhs;
        lhs.read = this.read;
        lhs.write = true;
        lhs.analyze(scriptRoot, locals);
    }

    private void analyzeIncrDecr() {
        if (this.pre && this.post) {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
        if (this.pre || this.post) {
            if (this.rhs != null) {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
            if (this.operation == Operation.INCR) {
                this.rhs = this.lhs.actual == Double.TYPE ? new EConstant(this.location, 1.0) : (this.lhs.actual == Float.TYPE ? new EConstant(this.location, Float.valueOf(1.0f)) : (this.lhs.actual == Long.TYPE ? new EConstant(this.location, 1L) : new EConstant(this.location, 1)));
                this.operation = Operation.ADD;
            } else if (this.operation == Operation.DECR) {
                this.rhs = this.lhs.actual == Double.TYPE ? new EConstant(this.location, 1.0) : (this.lhs.actual == Float.TYPE ? new EConstant(this.location, Float.valueOf(1.0f)) : (this.lhs.actual == Long.TYPE ? new EConstant(this.location, 1L) : new EConstant(this.location, 1)));
                this.operation = Operation.SUB;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeCompound(ScriptRoot scriptRoot, Locals locals) {
        this.rhs.analyze(scriptRoot, locals);
        boolean shift = false;
        if (this.operation == Operation.MUL) {
            this.promote = AnalyzerCaster.promoteNumeric(this.lhs.actual, this.rhs.actual, true);
        } else if (this.operation == Operation.DIV) {
            this.promote = AnalyzerCaster.promoteNumeric(this.lhs.actual, this.rhs.actual, true);
        } else if (this.operation == Operation.REM) {
            this.promote = AnalyzerCaster.promoteNumeric(this.lhs.actual, this.rhs.actual, true);
        } else if (this.operation == Operation.ADD) {
            this.promote = AnalyzerCaster.promoteAdd(this.lhs.actual, this.rhs.actual);
        } else if (this.operation == Operation.SUB) {
            this.promote = AnalyzerCaster.promoteNumeric(this.lhs.actual, this.rhs.actual, true);
        } else if (this.operation == Operation.LSH) {
            this.promote = AnalyzerCaster.promoteNumeric(this.lhs.actual, false);
            this.shiftDistance = AnalyzerCaster.promoteNumeric(this.rhs.actual, false);
            shift = true;
        } else if (this.operation == Operation.RSH) {
            this.promote = AnalyzerCaster.promoteNumeric(this.lhs.actual, false);
            this.shiftDistance = AnalyzerCaster.promoteNumeric(this.rhs.actual, false);
            shift = true;
        } else if (this.operation == Operation.USH) {
            this.promote = AnalyzerCaster.promoteNumeric(this.lhs.actual, false);
            this.shiftDistance = AnalyzerCaster.promoteNumeric(this.rhs.actual, false);
            shift = true;
        } else if (this.operation == Operation.BWAND) {
            this.promote = AnalyzerCaster.promoteXor(this.lhs.actual, this.rhs.actual);
        } else if (this.operation == Operation.XOR) {
            this.promote = AnalyzerCaster.promoteXor(this.lhs.actual, this.rhs.actual);
        } else if (this.operation == Operation.BWOR) {
            this.promote = AnalyzerCaster.promoteXor(this.lhs.actual, this.rhs.actual);
        } else {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
        if (this.promote == null || shift && this.shiftDistance == null) {
            throw this.createError(new ClassCastException("Cannot apply compound assignment [" + this.operation.symbol + "=] to types [" + this.lhs.actual + "] and [" + this.rhs.actual + "]."));
        }
        boolean bl = this.cat = this.operation == Operation.ADD && this.promote == String.class;
        if (this.cat) {
            if (this.rhs instanceof EBinary && ((EBinary)this.rhs).operation == Operation.ADD && this.rhs.actual == String.class) {
                ((EBinary)this.rhs).cat = true;
            }
            this.rhs.expected = this.rhs.actual;
        } else if (shift) {
            if (this.promote == def.class) {
                this.rhs.expected = this.promote;
            } else if (this.shiftDistance == Long.TYPE) {
                this.rhs.expected = Integer.TYPE;
                this.rhs.explicit = true;
            } else {
                this.rhs.expected = this.shiftDistance;
            }
        } else {
            this.rhs.expected = this.promote;
        }
        this.rhs = this.rhs.cast(scriptRoot, locals);
        this.there = AnalyzerCaster.getLegalCast(this.location, this.lhs.actual, this.promote, false, false);
        this.back = AnalyzerCaster.getLegalCast(this.location, this.promote, this.lhs.actual, true, false);
        this.statement = true;
        this.actual = this.read ? this.lhs.actual : Void.TYPE;
    }

    private void analyzeSimple(ScriptRoot scriptRoot, Locals locals) {
        AStoreable lhs = (AStoreable)this.lhs;
        if (lhs.isDefOptimized()) {
            this.rhs.analyze(scriptRoot, locals);
            if (this.rhs.actual == Void.TYPE) {
                throw this.createError(new IllegalArgumentException("Right-hand side cannot be a [void] type for assignment."));
            }
            this.rhs.expected = this.rhs.actual;
            lhs.updateActual(this.rhs.actual);
        } else {
            this.rhs.expected = lhs.actual;
            this.rhs.analyze(scriptRoot, locals);
        }
        this.rhs = this.rhs.cast(scriptRoot, locals);
        this.statement = true;
        this.actual = this.read ? lhs.actual : Void.TYPE;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        int catElementStackSize = 0;
        if (this.cat) {
            catElementStackSize = methodWriter.writeNewStrings();
        }
        AStoreable lhs = (AStoreable)this.lhs;
        lhs.setup(classWriter, methodWriter, globals);
        if (this.cat) {
            methodWriter.writeDup(lhs.accessElementCount(), catElementStackSize);
            lhs.load(classWriter, methodWriter, globals);
            methodWriter.writeAppendStrings(lhs.actual);
            this.rhs.write(classWriter, methodWriter, globals);
            if (!(this.rhs instanceof EBinary) || !((EBinary)this.rhs).cat) {
                methodWriter.writeAppendStrings(this.rhs.actual);
            }
            methodWriter.writeToStrings();
            methodWriter.writeCast(this.back);
            if (lhs.read) {
                methodWriter.writeDup(MethodWriter.getType(lhs.actual).getSize(), lhs.accessElementCount());
            }
            lhs.store(classWriter, methodWriter, globals);
        } else if (this.operation != null) {
            methodWriter.writeDup(lhs.accessElementCount(), 0);
            lhs.load(classWriter, methodWriter, globals);
            if (lhs.read && this.post) {
                methodWriter.writeDup(MethodWriter.getType(lhs.actual).getSize(), lhs.accessElementCount());
            }
            methodWriter.writeCast(this.there);
            this.rhs.write(classWriter, methodWriter, globals);
            if (this.promote == def.class) {
                methodWriter.writeDynamicBinaryInstruction(this.location, this.promote, def.class, def.class, this.operation, 2);
            } else {
                methodWriter.writeBinaryInstruction(this.location, this.promote, this.operation);
            }
            methodWriter.writeCast(this.back);
            if (lhs.read && !this.post) {
                methodWriter.writeDup(MethodWriter.getType(lhs.actual).getSize(), lhs.accessElementCount());
            }
            lhs.store(classWriter, methodWriter, globals);
        } else {
            this.rhs.write(classWriter, methodWriter, globals);
            if (lhs.read) {
                methodWriter.writeDup(MethodWriter.getType(lhs.actual).getSize(), lhs.accessElementCount());
            }
            lhs.store(classWriter, methodWriter, globals);
        }
    }

    @Override
    public String toString() {
        ArrayList<Object> subs = new ArrayList<Object>();
        subs.add(this.lhs);
        if (this.rhs != null) {
            subs.add(this.operation == null ? "=" : this.operation.symbol + "=");
            subs.add(this.rhs);
            return this.singleLineToString(subs);
        }
        subs.add(this.operation.symbol);
        if (this.pre) {
            subs.add("pre");
        }
        if (this.post) {
            subs.add("post");
        }
        return this.singleLineToString(subs);
    }
}

