/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.EStatic;
import org.elasticsearch.painless.node.PSubCallInvoke;
import org.elasticsearch.painless.node.PSubDefCall;
import org.elasticsearch.painless.node.PSubNullSafeCallInvoke;
import org.elasticsearch.painless.spi.annotation.NonDeterministicAnnotation;

public final class PCallInvoke
extends AExpression {
    private final String name;
    private final boolean nullSafe;
    private final List<AExpression> arguments;
    private AExpression sub = null;

    public PCallInvoke(Location location, AExpression prefix, String name, boolean nullSafe, List<AExpression> arguments) {
        super(location, prefix);
        this.name = Objects.requireNonNull(name);
        this.nullSafe = nullSafe;
        this.arguments = Objects.requireNonNull(arguments);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.prefix.extractVariables(variables);
        for (AExpression argument : this.arguments) {
            argument.extractVariables(variables);
        }
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        this.prefix.analyze(scriptRoot, locals);
        this.prefix.expected = this.prefix.actual;
        this.prefix = this.prefix.cast(scriptRoot, locals);
        if (this.prefix.actual == def.class) {
            this.sub = new PSubDefCall(this.location, this.name, this.arguments);
        } else {
            PainlessMethod method = scriptRoot.getPainlessLookup().lookupPainlessMethod(this.prefix.actual, this.prefix instanceof EStatic, this.name, this.arguments.size());
            if (method == null) {
                throw this.createError(new IllegalArgumentException("method [" + PainlessLookupUtility.typeToCanonicalTypeName(this.prefix.actual) + ", " + this.name + "/" + this.arguments.size() + "] not found"));
            }
            scriptRoot.markNonDeterministic(method.annotations.containsKey(NonDeterministicAnnotation.class));
            this.sub = new PSubCallInvoke(this.location, method, this.prefix.actual, this.arguments);
        }
        if (this.nullSafe) {
            this.sub = new PSubNullSafeCallInvoke(this.location, this.sub);
        }
        this.sub.expected = this.expected;
        this.sub.explicit = this.explicit;
        this.sub.analyze(scriptRoot, locals);
        this.actual = this.sub.actual;
        this.statement = true;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        this.prefix.write(classWriter, methodWriter, globals);
        this.sub.write(classWriter, methodWriter, globals);
    }

    @Override
    public String toString() {
        return this.singleLineToStringWithOptionalArgs(this.arguments, this.prefix, this.name);
    }
}

