from typing import Callable, Union, Any, Optional

from Cryptodome.PublicKey.RSA import RsaKey

Buffer = Union[bytes, bytearray, memoryview]

class PKCS115_Cipher:
    def __init__(self,
                 key: RsaKey,
                 randfunc: Callable[[int], bytes]) -> None: ...
    def can_encrypt(self) -> bool: ...
    def can_decrypt(self) -> bool: ...
    def encrypt(self, message: Buffer) -> bytes: ...
    def decrypt(self, ciphertext: Buffer) -> bytes: ...

def new(key: Buffer,
        randfunc: Optional[Callable[[int], bytes]] = ...) -> PKCS115_Cipher: ...
