/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFReference;

public class PDFOutline
extends PDFObject {
    private List subentries = new ArrayList();
    private PDFOutline parent = null;
    private PDFOutline prev = null;
    private PDFOutline next = null;
    private PDFOutline first = null;
    private PDFOutline last = null;
    private int count = 0;
    private boolean openItem;
    private String title;
    private PDFReference actionRef;

    public PDFOutline(String title, PDFReference action, boolean openItem) {
        this.title = title;
        this.actionRef = action;
        this.openItem = openItem;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public void addOutline(PDFOutline outline) {
        if (this.subentries.size() > 0) {
            outline.prev = (PDFOutline)this.subentries.get(this.subentries.size() - 1);
            outline.prev.next = outline;
        } else {
            this.first = outline;
        }
        this.subentries.add(outline);
        outline.parent = this;
        this.incrementCount();
        this.last = outline;
    }

    private void incrementCount() {
        ++this.count;
        if (this.parent != null) {
            this.parent.incrementCount();
        }
    }

    @Override
    protected byte[] toPDF() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(128);
        try {
            bout.write(PDFOutline.encode("<<"));
            if (this.parent == null) {
                if (this.first != null && this.last != null) {
                    bout.write(PDFOutline.encode(" /First " + this.first.referencePDF() + "\n"));
                    bout.write(PDFOutline.encode(" /Last " + this.last.referencePDF() + "\n"));
                }
            } else {
                bout.write(PDFOutline.encode(" /Title "));
                bout.write(this.encodeText(this.title));
                bout.write(PDFOutline.encode("\n"));
                bout.write(PDFOutline.encode(" /Parent " + this.parent.referencePDF() + "\n"));
                if (this.prev != null) {
                    bout.write(PDFOutline.encode(" /Prev " + this.prev.referencePDF() + "\n"));
                }
                if (this.next != null) {
                    bout.write(PDFOutline.encode(" /Next " + this.next.referencePDF() + "\n"));
                }
                if (this.first != null && this.last != null) {
                    bout.write(PDFOutline.encode(" /First " + this.first.referencePDF() + "\n"));
                    bout.write(PDFOutline.encode(" /Last " + this.last.referencePDF() + "\n"));
                }
                if (this.count > 0) {
                    bout.write(PDFOutline.encode(" /Count " + (this.openItem ? "" : "-") + this.count + "\n"));
                }
                if (this.actionRef != null) {
                    bout.write(PDFOutline.encode(" /A " + this.actionRef + "\n"));
                }
            }
            bout.write(PDFOutline.encode(">>"));
        }
        catch (IOException ioe) {
            log.error((Object)"Ignored I/O exception", (Throwable)ioe);
        }
        return bout.toByteArray();
    }

    @Override
    public void getChildren(Set<PDFObject> children) {
        if (this.parent != null) {
            children.add(this.parent);
        }
        if (this.first != null && this.last != null) {
            children.add(this.first);
            children.add(this.last);
            this.first.getChildren(children);
            this.last.getChildren(children);
        }
        if (this.actionRef != null) {
            children.add(this.actionRef.getObject());
        }
    }
}

