/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import java.io.IOException;
import org.apache.commons.jcs.engine.behavior.ICache;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheAdaptor<K, V>
implements ICacheListener<K, V> {
    private static final Log log = LogFactory.getLog(CacheAdaptor.class);
    private final ICache<K, V> cache;
    private long listenerId = 0L;

    @Override
    public void setListenerId(long id) throws IOException {
        this.listenerId = id;
        log.debug("listenerId = " + id);
    }

    @Override
    public long getListenerId() throws IOException {
        return this.listenerId;
    }

    public CacheAdaptor(ICache<K, V> cache) {
        this.cache = cache;
    }

    @Override
    public void handlePut(ICacheElement<K, V> item) throws IOException {
        try {
            this.cache.update(item);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void handleRemove(String cacheName, K key) throws IOException {
        this.cache.remove(key);
    }

    @Override
    public void handleRemoveAll(String cacheName) throws IOException {
        this.cache.removeAll();
    }

    @Override
    public void handleDispose(String cacheName) throws IOException {
        this.cache.dispose();
    }
}

