/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.autofilter;

import java.awt.Graphics2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.FilterModel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.autofilter.AutoFilter;
import org.openstreetmap.josm.gui.autofilter.AutoFilterButton;
import org.openstreetmap.josm.gui.autofilter.AutoFilterRule;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.widgets.OSDLabel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.I18n;

public final class AutoFilterManager
implements NavigatableComponent.ZoomChangeListener,
MapFrame.MapModeChangeListener,
DataSetListener,
PreferenceChangedListener,
LayerManager.LayerChangeListener {
    public static final BooleanProperty PROP_AUTO_FILTER_ENABLED = new BooleanProperty("auto.filter.enabled", true);
    public static final StringProperty PROP_AUTO_FILTER_RULE = new StringProperty("auto.filter.rule", "level");
    private static volatile AutoFilterManager instance;
    private final Map<Integer, AutoFilterButton> buttons = new TreeMap<Integer, AutoFilterButton>();
    private final List<AutoFilterRule> rules = new ArrayList<AutoFilterRule>();
    private final OSDLabel lblOSD = new OSDLabel("");
    private final FilterModel model = new FilterModel();
    AutoFilterRule enabledRule;
    private AutoFilter currentAutoFilter;

    public static AutoFilterManager getInstance() {
        if (instance == null) {
            instance = new AutoFilterManager();
        }
        return instance;
    }

    private AutoFilterManager() {
        MapFrame.addMapModeChangeListener(this);
        Config.getPref().addPreferenceChangeListener(this);
        NavigatableComponent.addZoomChangeListener(this);
        MainApplication.getLayerManager().addLayerChangeListener(this);
        DatasetEventManager.getInstance().addDatasetListener(this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        this.registerAutoFilterRules(AutoFilterRule.defaultRules());
    }

    private synchronized void updateButtons() {
        MapFrame map = MainApplication.getMap();
        if (this.enabledRule != null && map != null && this.enabledRule.getMinZoomLevel() <= Selector.GeneralSelector.scale2level(map.mapView.getDist100Pixel())) {
            NavigableSet<Integer> values = this.getNumericValues();
            if (this.currentAutoFilter != null) {
                values.add(this.currentAutoFilter.getFilter().value);
            }
            if (!values.equals(this.buttons.keySet())) {
                this.removeAllButtons();
                this.addNewButtons(values);
            }
        }
    }

    private synchronized void addNewButtons(NavigableSet<Integer> values) {
        if (values.isEmpty()) {
            return;
        }
        int i = 0;
        int maxWidth = 16;
        AutoFilterButton keyButton = AutoFilterButton.forOsmKey(this.enabledRule.getKey());
        this.addButton(keyButton, Integer.MIN_VALUE, i++);
        for (Integer value : values.descendingSet()) {
            CompiledFilter filter = new CompiledFilter(this.enabledRule, value);
            String label = this.enabledRule.formatValue(value);
            AutoFilter autoFilter = new AutoFilter(label, filter.text, filter);
            AutoFilterButton button = new AutoFilterButton(autoFilter);
            if (autoFilter.equals(this.currentAutoFilter)) {
                button.getModel().setPressed(true);
            }
            maxWidth = Math.max(maxWidth, button.getPreferredSize().width);
            this.addButton(button, value, i++);
        }
        Iterator<Serializable> iterator = this.buttons.values().iterator();
        while (iterator.hasNext()) {
            AutoFilterButton b;
            b.setSize((b = (AutoFilterButton)iterator.next()) == keyButton ? b.getPreferredSize().width : maxWidth, 20);
        }
        MainApplication.getMap().mapView.validate();
    }

    private void addButton(AutoFilterButton button, int value, int i) {
        MapView mapView = MainApplication.getMap().mapView;
        this.buttons.put(value, button);
        mapView.add(button).setLocation(3, 60 + 22 * i);
    }

    private void removeAllButtons() {
        this.buttons.values().forEach(MainApplication.getMap().mapView::remove);
        this.buttons.clear();
    }

    private synchronized NavigableSet<Integer> getNumericValues() {
        DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
        if (ds == null) {
            return Collections.emptyNavigableSet();
        }
        BBox bbox = MainApplication.getMap().mapView.getState().getViewArea().getLatLonBoundsBox().toBBox();
        TreeSet<Integer> values = new TreeSet<Integer>();
        Consumer<OsmPrimitive> consumer = o -> this.enabledRule.getTagValuesForPrimitive((OsmPrimitive)o).forEach(values::add);
        ds.searchNodes(bbox).forEach(consumer);
        ds.searchWays(bbox).forEach(consumer);
        ds.searchRelations(bbox).forEach(consumer);
        return values;
    }

    @Override
    public void zoomChanged() {
        this.updateButtons();
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
        this.updateFiltersFull();
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
        this.updateFiltersFull();
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
        this.updateFiltersFull();
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
        this.updateFiltersEvent(event, false);
        this.updateButtons();
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        this.updateFiltersFull();
        this.updateButtons();
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
        this.updateFiltersEvent(event, true);
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
        this.updateFiltersEvent(event, true);
        this.updateButtons();
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
        this.updateFiltersEvent(event, true);
    }

    @Override
    public void mapModeChange(MapMode oldMapMode, MapMode newMapMode) {
        this.updateFiltersFull();
    }

    private synchronized void updateFiltersFull() {
        if (this.currentAutoFilter != null) {
            this.model.executeFilters();
        }
    }

    private synchronized void updateFiltersEvent(AbstractDatasetChangedEvent event, boolean affectedOnly) {
        if (this.currentAutoFilter != null) {
            Collection<? extends OsmPrimitive> prims = event.getPrimitives();
            this.model.executeFilters(affectedOnly ? FilterModel.getAffectedPrimitives(prims) : prims);
        }
    }

    public synchronized boolean registerAutoFilterRules(AutoFilterRule ... filterRules) {
        return this.rules.addAll(Arrays.asList(filterRules));
    }

    public synchronized boolean unregisterAutoFilterRule(AutoFilterRule rule) {
        return this.rules.remove(Objects.requireNonNull(rule, "rule"));
    }

    public synchronized List<AutoFilterRule> getAutoFilterRules() {
        return new ArrayList<AutoFilterRule>(this.rules);
    }

    public synchronized AutoFilterRule getAutoFilterRule(String key) {
        for (AutoFilterRule r : this.rules) {
            if (!key.equals(r.getKey())) continue;
            return r;
        }
        return null;
    }

    public synchronized void enableAutoFilterRule(String key) {
        this.enableAutoFilterRule(key == null ? null : this.getAutoFilterRule(key));
    }

    public synchronized void enableAutoFilterRule(AutoFilterRule rule) {
        this.enabledRule = rule;
    }

    public synchronized AutoFilter getCurrentAutoFilter() {
        return this.currentAutoFilter;
    }

    public synchronized void setCurrentAutoFilter(AutoFilter autoFilter) {
        this.model.clearFilters();
        this.currentAutoFilter = autoFilter;
        if (autoFilter != null) {
            OsmDataLayer dataLayer;
            this.model.addFilter(autoFilter.getFilter());
            this.model.executeFilters();
            if (this.model.isChanged() && (dataLayer = MainApplication.getLayerManager().getActiveDataLayer()) != null) {
                dataLayer.invalidate();
            }
        }
    }

    public synchronized void drawOSDText(Graphics2D g) {
        this.model.drawOSDText(g, this.lblOSD, I18n.tr("<h2>Filter active: {0}</h2>", this.currentAutoFilter.getFilter().text), I18n.tr("</p><p>Click again on filter button to see all objects.</p></html>", new Object[0]));
    }

    private void resetCurrentAutoFilter() {
        this.setCurrentAutoFilter(null);
        this.removeAllButtons();
        MapFrame map = MainApplication.getMap();
        if (map != null) {
            map.filterDialog.getFilterModel().executeFilters(true);
        }
    }

    @Override
    public void preferenceChanged(PreferenceChangeEvent e) {
        if (e.getKey().equals(PROP_AUTO_FILTER_ENABLED.getKey())) {
            if (PROP_AUTO_FILTER_ENABLED.get().booleanValue()) {
                this.enableAutoFilterRule(PROP_AUTO_FILTER_RULE.get());
                this.updateButtons();
            } else {
                this.enableAutoFilterRule((AutoFilterRule)null);
                this.resetCurrentAutoFilter();
            }
        } else if (e.getKey().equals(PROP_AUTO_FILTER_RULE.getKey())) {
            this.enableAutoFilterRule(PROP_AUTO_FILTER_RULE.get());
            this.resetCurrentAutoFilter();
            this.updateButtons();
        }
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (MainApplication.getLayerManager().getActiveDataLayer() == null) {
            this.resetCurrentAutoFilter();
        }
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    static class Match
    extends SearchCompiler.Match {
        final AutoFilterRule rule;
        final int value;

        Match(AutoFilterRule rule, int value) {
            this.rule = rule;
            this.value = value;
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            return this.rule.getTagValuesForPrimitive(osm).anyMatch(v -> v == this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Match match = (Match)o;
            return this.value == match.value && Objects.equals(this.rule, match.rule);
        }

        public int hashCode() {
            return Objects.hash(this.rule, this.value);
        }
    }

    static class CompiledFilter
    extends Filter
    implements SearchCompiler.MatchSupplier {
        final AutoFilterRule rule;
        final int value;

        CompiledFilter(AutoFilterRule rule, int value) {
            this.rule = rule;
            this.value = value;
            this.enable = true;
            this.inverted = true;
            this.text = rule.getKey() + "=" + value;
        }

        @Override
        public SearchCompiler.Match get() {
            return new Match(this.rule, this.value);
        }
    }
}

