/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ir.IrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensions;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.FilteredAnnotations;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.sam.SamAdapterDescriptor;
import org.jetbrains.kotlin.load.java.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.load.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementKt;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorExtensions;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.synthetic.SamAdapterExtensionFunctionDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0019H\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions;", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions;", "generateFacades", "", "(Z)V", "classNameOverride", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "getClassNameOverride", "()Ljava/util/Map;", "enhancedNullability", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$EnhancedNullability;", "getEnhancedNullability", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$EnhancedNullability;", "samConversion", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$SamConversion;", "getSamConversion", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$SamConversion;", "computeExternalDeclarationOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "computeFieldVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "generateFacadeClass", "source", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "isPropertyWithPlatformField", "JvmEnhancedNullability", "JvmSamConversion", "backend.jvm"})
public final class JvmGeneratorExtensions
extends GeneratorExtensions {
    @NotNull
    private final Map<IrClass, JvmClassName> classNameOverride;
    private final boolean generateFacades;

    @NotNull
    public final Map<IrClass, JvmClassName> getClassNameOverride() {
        return this.classNameOverride;
    }

    @Override
    @NotNull
    public GeneratorExtensions.SamConversion getSamConversion() {
        return JvmSamConversion.Instance;
    }

    @Override
    @Nullable
    public Visibility computeFieldVisibility(@NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        return JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor2) || descriptor2 instanceof JavaCallableMemberDescriptor ? descriptor2.getVisibility() : null;
    }

    @Override
    @Nullable
    public IrDeclarationOrigin computeExternalDeclarationOrigin(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        return descriptor2 instanceof JavaCallableMemberDescriptor ? (IrDeclarationOriginImpl)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE : (IrDeclarationOriginImpl)IrDeclarationOrigin.IR_EXTERNAL_DECLARATION_STUB.INSTANCE;
    }

    @Override
    @Nullable
    public IrClass generateFacadeClass(@NotNull DeserializedContainerSource source) {
        Intrinsics.checkParameterIsNotNull(source, "source");
        if (!this.generateFacades) {
            return null;
        }
        DeserializedContainerSource deserializedContainerSource = source;
        if (!(deserializedContainerSource instanceof JvmPackagePartSource)) {
            deserializedContainerSource = null;
        }
        JvmPackagePartSource jvmPackagePartSource = (JvmPackagePartSource)deserializedContainerSource;
        if (jvmPackagePartSource == null) {
            return null;
        }
        JvmPackagePartSource jvmPackagePartSource2 = jvmPackagePartSource;
        JvmClassName jvmClassName = jvmPackagePartSource2.getFacadeClassName();
        if (jvmClassName == null) {
            jvmClassName = jvmPackagePartSource2.getClassName();
        }
        JvmClassName facadeName = jvmClassName;
        boolean $i$f$buildClass = false;
        IrClassBuilder irClassBuilder = new IrClassBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrClassBuilder $this$run$iv = irClassBuilder;
        boolean bl3 = false;
        IrClassBuilder $this$buildClass = $this$run$iv;
        boolean bl4 = false;
        $this$buildClass.setOrigin(IrDeclarationOrigin.FILE_CLASS.INSTANCE);
        Name name = facadeName.getFqNameForTopLevelClassMaybeWithDollars().shortName();
        Intrinsics.checkExpressionValueIsNotNull(name, "facadeName.fqNameForTopL\u2026beWithDollars.shortName()");
        $this$buildClass.setName(name);
        IrClass irClass = DeclarationBuildersKt.buildClass($this$run$iv);
        boolean bl5 = false;
        bl = false;
        IrClass it = irClass;
        boolean bl6 = false;
        IrUtilsKt.createParameterDeclarations(it);
        this.classNameOverride.put(it, facadeName);
        return irClass;
    }

    @Override
    public boolean isPropertyWithPlatformField(@NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        return JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor2);
    }

    @Override
    @NotNull
    public GeneratorExtensions.EnhancedNullability getEnhancedNullability() {
        return JvmEnhancedNullability.Instance;
    }

    public JvmGeneratorExtensions(boolean generateFacades) {
        Map map2;
        this.generateFacades = generateFacades;
        JvmGeneratorExtensions jvmGeneratorExtensions = this;
        boolean bl = false;
        jvmGeneratorExtensions.classNameOverride = map2 = (Map)new LinkedHashMap();
    }

    public /* synthetic */ JvmGeneratorExtensions(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public JvmGeneratorExtensions() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions$JvmSamConversion;", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$SamConversion;", "()V", "getOriginalForSamAdapter", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "descriptor", "getSubstitutedFunctionTypeForSamType", "Lorg/jetbrains/kotlin/types/KotlinType;", "samType", "isSamConstructor", "", "isSamType", "type", "Instance", "backend.jvm"})
    public static class JvmSamConversion
    extends GeneratorExtensions.SamConversion {
        public static final Instance Instance = new Instance(null);

        @Override
        @Nullable
        public CallableDescriptor getOriginalForSamAdapter(@NotNull CallableDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            CallableDescriptor callableDescriptor = descriptor2;
            return callableDescriptor instanceof SamAdapterDescriptor ? (FunctionDescriptor)((SamAdapterDescriptor)descriptor2).getBaseDescriptorForSynthetic() : (callableDescriptor instanceof SamAdapterExtensionFunctionDescriptor ? ((SamAdapterExtensionFunctionDescriptor)descriptor2).getBaseDescriptorForSynthetic() : null);
        }

        @Override
        public boolean isSamConstructor(@NotNull CallableDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            return descriptor2 instanceof SamConstructorDescriptor;
        }

        @Override
        public boolean isSamType(@NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull(type2, "type");
            return SingleAbstractMethodUtils.isSamType(type2);
        }

        @Override
        @NotNull
        public KotlinType getSubstitutedFunctionTypeForSamType(@NotNull KotlinType samType) {
            Intrinsics.checkParameterIsNotNull(samType, "samType");
            ClassifierDescriptor classifierDescriptor = samType.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof JavaClassDescriptor)) {
                classifierDescriptor = null;
            }
            JavaClassDescriptor javaClassDescriptor = (JavaClassDescriptor)classifierDescriptor;
            if (javaClassDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("SAM should be represented by a Java class: " + samType)));
            }
            JavaClassDescriptor descriptor2 = javaClassDescriptor;
            FunctionDescriptor functionDescriptor = SingleAbstractMethodUtils.getSingleAbstractMethodOrNull(descriptor2);
            if (functionDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)(descriptor2 + " should have a single abstract method")));
            }
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "SingleAbstractMethodUtil\u2026 single abstract method\")");
            FunctionDescriptor singleAbstractMethod = functionDescriptor;
            SimpleType simpleType2 = SingleAbstractMethodUtils.getFunctionTypeForAbstractMethod(singleAbstractMethod, false);
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "SingleAbstractMethodUtil\u2026gleAbstractMethod, false)");
            SimpleType unsubstitutedFunctionType = simpleType2;
            KotlinType kotlinType = TypeSubstitutor.create(samType).substitute(unsubstitutedFunctionType, Variance.INVARIANT);
            if (kotlinType == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Failed to substitute function type " + unsubstitutedFunctionType + " corresponding to " + samType)));
            }
            return kotlinType;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions$JvmSamConversion$Instance;", "Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions$JvmSamConversion;", "()V", "backend.jvm"})
        public static final class Instance
        extends JvmSamConversion {
            private Instance() {
            }

            public /* synthetic */ Instance(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions$JvmEnhancedNullability;", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$EnhancedNullability;", "()V", "hasEnhancedNullability", "", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "stripEnhancedNullability", "Instance", "backend.jvm"})
    public static class JvmEnhancedNullability
    extends GeneratorExtensions.EnhancedNullability {
        public static final Instance Instance = new Instance(null);

        @Override
        public boolean hasEnhancedNullability(@NotNull KotlinType kotlinType) {
            Intrinsics.checkParameterIsNotNull(kotlinType, "kotlinType");
            return TypeEnhancementKt.hasEnhancedNullability(kotlinType);
        }

        @Override
        @NotNull
        public KotlinType stripEnhancedNullability(@NotNull KotlinType kotlinType) {
            Intrinsics.checkParameterIsNotNull(kotlinType, "kotlinType");
            return TypeEnhancementKt.hasEnhancedNullability(kotlinType) ? TypeUtilsKt.replaceAnnotations(kotlinType, new FilteredAnnotations(kotlinType.getAnnotations(), true, stripEnhancedNullability.1.INSTANCE)) : kotlinType;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions$JvmEnhancedNullability$Instance;", "Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions$JvmEnhancedNullability;", "()V", "backend.jvm"})
        public static final class Instance
        extends JvmEnhancedNullability {
            private Instance() {
            }

            public /* synthetic */ Instance(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

