/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.hunspell;

import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Experimental;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Categories;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.hunspell.Hunspell;
import org.languagetool.rules.spelling.suggestions.SuggestionsChanges;
import org.languagetool.rules.spelling.suggestions.SuggestionsOrderer;
import org.languagetool.rules.spelling.suggestions.SuggestionsOrdererFeatureExtractor;
import org.languagetool.rules.spelling.suggestions.XGBoostSuggestionsOrderer;
import org.languagetool.tools.Tools;

public class HunspellRule
extends SpellingCheckRule {
    public static final String RULE_ID = "HUNSPELL_RULE";
    protected static final String FILE_EXTENSION = ".dic";
    protected final SuggestionsOrderer suggestionsOrderer;
    protected boolean needsInit = true;
    protected Hunspell hunspell = null;
    private static final ConcurrentLinkedQueue<String> activeChecks = new ConcurrentLinkedQueue();
    private static final String NON_ALPHABETIC = "[^\\p{L}]";
    private final boolean monitorRules;
    private final boolean runningExperiment;
    private static final String[] WHITESPACE_ARRAY = new String[20];
    protected Pattern nonWordPattern;
    private final UserConfig userConfig;

    public static Queue<String> getActiveChecks() {
        return activeChecks;
    }

    public HunspellRule(ResourceBundle messages, Language language, UserConfig userConfig) {
        this(messages, language, userConfig, Collections.emptyList());
    }

    public HunspellRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) {
        this(messages, language, userConfig, altLanguages, null);
    }

    public HunspellRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages, LanguageModel languageModel) {
        super(messages, language, userConfig, altLanguages, languageModel);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.userConfig = userConfig;
        boolean bl = this.monitorRules = System.getProperty("monitorActiveRules") != null;
        if (SuggestionsChanges.isRunningExperiment("NewSuggestionsOrderer")) {
            this.suggestionsOrderer = new SuggestionsOrdererFeatureExtractor(language, this.languageModel);
            this.runningExperiment = true;
        } else {
            this.suggestionsOrderer = new XGBoostSuggestionsOrderer(language, languageModel);
            this.runningExperiment = false;
        }
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_spelling");
    }

    protected boolean isQuotedCompound(AnalyzedSentence analyzedSentence, int idx, String token) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (this.needsInit) {
            this.init();
        }
        if (this.hunspell == null) {
            return this.toRuleMatchArray(ruleMatches);
        }
        String monitoringText = this.getClass().getName() + ":" + this.getId() + ":" + sentence.getText();
        try {
            if (this.monitorRules) {
                activeChecks.add(monitoringText);
            }
            String[] tokens = this.tokenizeText(this.getSentenceTextWithoutUrlsAndImmunizedTokens(sentence));
            int len = sentence.getTokens().length > 1 ? sentence.getTokens()[1].getStartPos() : sentence.getTokens()[0].getStartPos();
            int prevStartPos = -1;
            for (int i = 0; i < tokens.length; ++i) {
                String word = tokens[i];
                if ((this.ignoreWord(Arrays.asList(tokens), i) || this.ignoreWord(word)) && !this.isProhibited(this.cutOffDot(word))) {
                    prevStartPos = len;
                    len += word.length() + 1;
                    continue;
                }
                if (this.isMisspelled(word)) {
                    String prevWord;
                    String cleanWord = word;
                    if (word.endsWith(".")) {
                        cleanWord = word.substring(0, word.length() - 1);
                    }
                    if (i > 0 && prevStartPos != -1 && (prevWord = tokens[i - 1]).length() > 0) {
                        String sugg1a = prevWord.substring(0, prevWord.length() - 1);
                        String sugg1b = this.cutOffDot(prevWord.substring(prevWord.length() - 1) + word);
                        if (!this.isMisspelled(sugg1a) && !this.isMisspelled(sugg1b)) {
                            ruleMatches.add(this.createWrongSplitMatch(sentence, ruleMatches, len, cleanWord, sugg1a, sugg1b, prevStartPos));
                        }
                        String sugg2a = prevWord + word.substring(0, 1);
                        String string = this.cutOffDot(word.substring(1));
                        if (!this.isMisspelled(sugg2a) && !this.isMisspelled(string)) {
                            ruleMatches.add(this.createWrongSplitMatch(sentence, ruleMatches, len, cleanWord, sugg2a, string, prevStartPos));
                        }
                    }
                    RuleMatch ruleMatch = new RuleMatch(this, sentence, len, len + cleanWord.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
                    ruleMatch.setType(RuleMatch.Type.UnknownWord);
                    if (this.userConfig == null || this.userConfig.getMaxSpellingSuggestions() == 0 || ruleMatches.size() <= this.userConfig.getMaxSpellingSuggestions()) {
                        List<String> additionalTopSuggestions;
                        List<String> suggestions = this.getSuggestions(cleanWord);
                        if (word.endsWith(".")) {
                            int pos = 1;
                            for (String string : this.getSuggestions(word)) {
                                if (suggestions.contains(string)) continue;
                                suggestions.add(Math.min(pos, suggestions.size()), string.substring(0, string.length() - 1));
                                pos += 2;
                            }
                        }
                        if ((additionalTopSuggestions = this.getAdditionalTopSuggestions(suggestions, cleanWord)).isEmpty() && word.endsWith(".")) {
                            additionalTopSuggestions = this.getAdditionalTopSuggestions(suggestions, word).stream().map(k -> k.endsWith(".") ? k : k + ".").collect(Collectors.toList());
                        }
                        Collections.reverse(additionalTopSuggestions);
                        for (String string : additionalTopSuggestions) {
                            if (cleanWord.equals(string)) continue;
                            suggestions.add(0, string);
                        }
                        List<String> additionalSuggestions = this.getAdditionalSuggestions(suggestions, cleanWord);
                        for (String additionalSuggestion : additionalSuggestions) {
                            if (cleanWord.equals(additionalSuggestion)) continue;
                            suggestions.addAll(additionalSuggestions);
                        }
                        Language language = this.acceptedInAlternativeLanguage(cleanWord);
                        boolean isSpecialCase = cleanWord.matches(".+-[A-Z\u00d6\u00c4\u00dc].*");
                        if (language != null && !isSpecialCase) {
                            if (this.isAcceptedWordFromLanguage(language, cleanWord)) continue;
                            ruleMatch = new RuleMatch(this, sentence, len, len + cleanWord.length(), Tools.i18n(this.messages, "accepted_in_alt_language", cleanWord, this.messages.getString(language.getShortCode())));
                            ruleMatch.setType(RuleMatch.Type.Hint);
                        }
                        suggestions = this.filterSuggestions(suggestions, sentence, i);
                        this.filterDupes(suggestions);
                        if (this.runningExperiment) {
                            HunspellRule.addSuggestionsToRuleMatch(cleanWord, Collections.emptyList(), suggestions, this.suggestionsOrderer, ruleMatch);
                        } else if (this.userConfig != null && this.userConfig.getAbTest() != null && this.userConfig.getAbTest().equals("SuggestionsRanker") && this.suggestionsOrderer.isMlAvailable() && this.userConfig.getTextSessionId() != null) {
                            boolean testingA;
                            boolean bl = testingA = this.userConfig.getTextSessionId() % 2L == 0L;
                            if (testingA) {
                                HunspellRule.addSuggestionsToRuleMatch(cleanWord, Collections.emptyList(), suggestions, null, ruleMatch);
                            } else {
                                HunspellRule.addSuggestionsToRuleMatch(cleanWord, Collections.emptyList(), suggestions, this.suggestionsOrderer, ruleMatch);
                            }
                        } else {
                            HunspellRule.addSuggestionsToRuleMatch(cleanWord, Collections.emptyList(), suggestions, null, ruleMatch);
                        }
                    } else {
                        ruleMatch.setSuggestedReplacement(this.messages.getString("too_many_errors"));
                    }
                    ruleMatches.add(ruleMatch);
                }
                prevStartPos = len;
                len += word.length() + 1;
            }
        }
        finally {
            if (this.monitorRules) {
                activeChecks.remove(monitoringText);
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private String cutOffDot(String s) {
        return s.endsWith(".") ? s.substring(0, s.length() - 1) : s;
    }

    @Override
    @Experimental
    public boolean isMisspelled(String word) {
        try {
            if (this.needsInit) {
                this.init();
            }
            boolean isAlphabetic = true;
            if (word.length() == 1) {
                isAlphabetic = Character.isAlphabetic(word.charAt(0));
            }
            return isAlphabetic && !"--".equals(word) && this.hunspell != null && !this.hunspell.spell(word) && !this.ignoreWord(word) || this.isProhibited(this.cutOffDot(word));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getSuggestions(String word) throws IOException {
        if (this.needsInit) {
            this.init();
        }
        return this.hunspell.suggest(word);
    }

    protected List<String> sortSuggestionByQuality(String misspelling, List<String> suggestions) {
        return suggestions;
    }

    protected String[] tokenizeText(String sentence) {
        return this.nonWordPattern.split(sentence);
    }

    protected String getSentenceTextWithoutUrlsAndImmunizedTokens(AnalyzedSentence sentence) {
        StringBuilder sb = new StringBuilder();
        AnalyzedTokenReadings[] sentenceTokens = this.getSentenceWithImmunization(sentence).getTokens();
        for (int i = 1; i < sentenceTokens.length; ++i) {
            String token = sentenceTokens[i].getToken();
            if (sentenceTokens[i].isImmunized() || sentenceTokens[i].isIgnoredBySpeller() || this.isUrl(token) || this.isEMail(token) || this.isQuotedCompound(sentence, i, token)) {
                if (this.isQuotedCompound(sentence, i, token)) {
                    sb.append(" ").append(token.substring(1));
                    continue;
                }
                if (token.length() < 20) {
                    sb.append(WHITESPACE_ARRAY[token.length()]);
                    continue;
                }
                for (int j = 0; j < token.length(); ++j) {
                    sb.append(' ');
                }
                continue;
            }
            if (token.length() > 1 && token.codePointCount(0, token.length()) != token.length()) {
                int increment;
                for (int charIndex = 0; charIndex < token.length(); charIndex += increment) {
                    int unicodeCodePoint = token.codePointAt(charIndex);
                    increment = Character.charCount(unicodeCodePoint);
                    if (increment == 1) {
                        sb.append(token.charAt(charIndex));
                        continue;
                    }
                    sb.append("  ");
                }
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    @Override
    protected synchronized void init() throws IOException {
        super.init();
        String langCountry = this.language.getShortCode();
        if (this.language.getCountries().length > 0) {
            langCountry = langCountry + "_" + this.language.getCountries()[0];
        }
        String shortDicPath = this.getDictFilenameInResources(langCountry);
        String wordChars = "";
        Path affPath = null;
        if (JLanguageTool.getDataBroker().resourceExists(shortDicPath)) {
            String path = this.getDictionaryPath(langCountry, shortDicPath);
            if ("".equals(path)) {
                this.hunspell = null;
            } else {
                affPath = Paths.get(path + ".aff", new String[0]);
                this.hunspell = Hunspell.getInstance(Paths.get(path + FILE_EXTENSION, new String[0]), affPath);
                this.addIgnoreWords();
            }
        } else if (new File(shortDicPath + FILE_EXTENSION).exists()) {
            affPath = Paths.get(shortDicPath + ".aff", new String[0]);
            this.hunspell = Hunspell.getInstance(Paths.get(shortDicPath + FILE_EXTENSION, new String[0]), affPath);
        }
        if (affPath != null) {
            Scanner sc = new Scanner(affPath);
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                if (!line.startsWith("WORDCHARS ")) continue;
                String wordCharsFromAff = line.substring("WORDCHARS ".length());
                wordChars = "(?![" + wordCharsFromAff.replace("-", "\\-") + "])";
                break;
            }
        }
        this.nonWordPattern = Pattern.compile(wordChars + NON_ALPHABETIC);
        this.needsInit = false;
    }

    @NotNull
    protected String getDictFilenameInResources(String langCountry) {
        return "/" + this.language.getShortCode() + "/hunspell/" + langCountry + FILE_EXTENSION;
    }

    private void addIgnoreWords() throws IOException {
        this.wordsToBeIgnored.add("LanguageTool");
        this.wordsToBeIgnored.add("LanguageTooler");
        URL ignoreUrl = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(this.getIgnoreFileName());
        List ignoreLines = Resources.readLines((URL)ignoreUrl, (Charset)StandardCharsets.UTF_8);
        for (String ignoreLine : ignoreLines) {
            if (ignoreLine.startsWith("#")) continue;
            this.wordsToBeIgnored.add(ignoreLine);
        }
    }

    private String getDictionaryPath(String dicName, String originalPath) throws IOException {
        String dictionaryPath;
        URL dictURL = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(originalPath);
        if (StringUtils.equalsAny((CharSequence)dictURL.getProtocol(), (CharSequence[])new CharSequence[]{"jar", "vfs", "bundle", "bundleresource"})) {
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            File tempDicFile = new File(tempDir, dicName + FILE_EXTENSION);
            JLanguageTool.addTemporaryFile(tempDicFile);
            try (InputStream dicStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(originalPath);){
                this.fileCopy(dicStream, tempDicFile);
            }
            File tempAffFile = new File(tempDir, dicName + ".aff");
            JLanguageTool.addTemporaryFile(tempAffFile);
            if (originalPath.endsWith(FILE_EXTENSION)) {
                originalPath = originalPath.substring(0, originalPath.length() - FILE_EXTENSION.length()) + ".aff";
            }
            try (InputStream affStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(originalPath);){
                this.fileCopy(affStream, tempAffFile);
            }
            dictionaryPath = tempDir.getAbsolutePath() + "/" + dicName;
        } else {
            int suffixLength = FILE_EXTENSION.length();
            try {
                dictionaryPath = new File(dictURL.toURI()).getAbsolutePath();
                dictionaryPath = dictionaryPath.substring(0, dictionaryPath.length() - suffixLength);
            }
            catch (URISyntaxException e) {
                return "";
            }
        }
        return dictionaryPath;
    }

    private void fileCopy(InputStream in, File targetFile) throws IOException {
        try (FileOutputStream out = new FileOutputStream(targetFile);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
        }
    }

    protected boolean isAcceptedWordFromLanguage(Language language, String word) {
        return false;
    }

    static {
        for (int i = 0; i < 20; ++i) {
            HunspellRule.WHITESPACE_ARRAY[i] = StringUtils.repeat((char)' ', (int)i);
        }
    }
}

