/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import org.protege.editor.owl.ui.renderer.layout.ActionLink;
import org.protege.editor.owl.ui.renderer.layout.LinkSpan;
import org.protege.editor.owl.ui.renderer.layout.Paragraph;
import org.protege.editor.owl.ui.renderer.layout.Span;

public class ActionSpan {
    private List<Action> actions;
    private String paragraphText;
    private List<LinkSpan> linkSpans = new ArrayList<LinkSpan>();

    public ActionSpan(List<Action> actions) {
        this.actions = actions;
        StringBuilder sb = new StringBuilder();
        Iterator<Action> it = actions.iterator();
        while (it.hasNext()) {
            Action action = it.next();
            sb.append("[");
            int linkStart = sb.length();
            sb.append(action.getValue("Name"));
            int linkEnd = sb.length();
            LinkSpan linkSpan = new LinkSpan(new ActionLink(action), new Span(linkStart, linkEnd));
            this.linkSpans.add(linkSpan);
            sb.append("]");
            if (!it.hasNext()) continue;
            sb.append("  ");
        }
        this.paragraphText = sb.toString();
    }

    public String getParagraphText() {
        return this.paragraphText;
    }

    public List<LinkSpan> getLinkSpans() {
        return this.linkSpans;
    }

    public Paragraph createParagraph() {
        return new Paragraph(this.paragraphText, this.linkSpans);
    }
}

