/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.Lockable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

class LockableMap<K, V>
extends Lockable {
    private final Map<K, V> map;

    LockableMap(Map<K, V> map, ReentrantLock reentrantLock) {
        super(reentrantLock);
        this.map = map;
    }

    LockableMap(Map<K, V> map) {
        this(map, new ReentrantLock());
    }

    LockableMap() {
        this(new HashMap(), new ReentrantLock());
    }

    void clear() {
        if (this.lock()) {
            try {
                Iterator<V> iterator = new ArrayList<V>(this.map.values()).iterator();
                while (iterator.hasNext()) {
                    try {
                        V v = iterator.next();
                        if (!(v instanceof AutoCloseable)) continue;
                        ((AutoCloseable)v).close();
                    }
                    catch (Exception exception) {}
                }
                this.map.clear();
            }
            finally {
                this.unlock();
            }
        }
    }

    Iterator<Map.Entry<K, V>> iterator() {
        if (this.lock()) {
            try {
                Iterator<Map.Entry<K, V>> iterator = new ArrayList<Map.Entry<K, V>>(this.map.entrySet()).iterator();
                return iterator;
            }
            finally {
                this.unlock();
            }
        }
        return Collections.emptyListIterator();
    }

    List<K> keys() {
        if (this.lock()) {
            try {
                ArrayList<K> arrayList = new ArrayList<K>(this.map.keySet());
                return arrayList;
            }
            finally {
                this.unlock();
            }
        }
        return Collections.emptyList();
    }

    List<V> values() {
        if (this.lock()) {
            try {
                ArrayList<V> arrayList = new ArrayList<V>(this.map.values());
                return arrayList;
            }
            finally {
                this.unlock();
            }
        }
        return Collections.emptyList();
    }

    V get(K k) {
        if (this.lock()) {
            try {
                V v = this.map.get(k);
                return v;
            }
            finally {
                this.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V put(K k, V v) {
        if (this.lock()) {
            try {
                V v2 = this.map.put(k, v);
                return v2;
            }
            finally {
                this.unlock();
            }
        }
        return null;
    }

    V remove(K k) {
        if (this.lock()) {
            try {
                V v = this.map.remove(k);
                return v;
            }
            finally {
                this.unlock();
            }
        }
        return null;
    }

    public String toString() {
        return "LockableMap(" + this.map + ")";
    }
}

