/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ButtonPanel
extends JPanel {
    private static final long serialVersionUID = 2123185410505818217L;
    private int maxWidth;
    private int maxHeight;
    private JButton defaultButton;
    private Map<Action, AbstractButton> buttonMap = new HashMap<Action, AbstractButton>();
    private static final int BORDER_WIDTH = 5;
    private static final int GAP_WIDTH = 8;

    public ButtonPanel(ComponentOrientation orientation) {
        this.setLayout(new BoxLayout(this, 2));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setComponentOrientation(orientation);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                ButtonPanel.this.setDefaultButton();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
    }

    private void setDefaultButton() {
        if (this.defaultButton != null) {
            Container comp;
            for (comp = this; comp != null && !(comp instanceof JRootPane); comp = comp.getParent()) {
            }
            if (comp != null) {
                ((JRootPane)comp).setDefaultButton(this.defaultButton);
                this.defaultButton = null;
            }
        }
    }

    public ButtonPanel() {
        this(ComponentOrientation.RIGHT_TO_LEFT);
    }

    public AbstractButton addAction(Action action) {
        return this.addAction(action, 0, false);
    }

    public AbstractButton addAction(Action action, int space, boolean isDefault) {
        return this.addAction(action, null, space, isDefault, JButton.class);
    }

    public void enable(Action action) {
        AbstractButton button = this.buttonMap.get(action);
        if (button != null) {
            button.setEnabled(true);
        }
    }

    public void disable(Action action) {
        AbstractButton button = this.buttonMap.get(action);
        if (button != null) {
            button.setEnabled(false);
        }
    }

    public void setAllEnabled(boolean enabled) {
        for (AbstractButton button : this.buttonMap.values()) {
            button.setEnabled(enabled);
        }
    }

    private Action makeSelectAction(final Action select, final Action deselect) {
        return new AbstractAction(){
            {
                AbstractAction sel = (AbstractAction)select;
                for (Object key : sel.getKeys()) {
                    this.putValue(key.toString(), sel.getValue(key.toString()));
                }
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractButton button = (AbstractButton)evt.getSource();
                if (button.isSelected()) {
                    select.actionPerformed(evt);
                } else {
                    deselect.actionPerformed(evt);
                }
            }
        };
    }

    public AbstractButton addAction(Action selectAction, Action deselectAction, int space, boolean isDefault, Class<? extends AbstractButton> buttonClass) {
        AbstractButton button;
        Action action = deselectAction != null ? this.makeSelectAction(selectAction, deselectAction) : selectAction;
        if (isDefault && !JButton.class.isAssignableFrom(buttonClass)) {
            throw new IllegalArgumentException("Only JButton objects can be default buttons");
        }
        try {
            button = buttonClass.newInstance();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot instantiate class " + buttonClass.getName());
        }
        if (deselectAction != null) {
            this.buttonMap.put(selectAction, button);
            this.buttonMap.put(deselectAction, button);
        } else {
            this.buttonMap.put(selectAction, button);
        }
        button.setAction(action);
        if (action.getValue("SmallIcon") != null) {
            button.setMargin(new Insets(0, 0, 0, 0));
            button.setBorder(BorderFactory.createEmptyBorder());
        }
        this.maxWidth = Math.max(this.maxWidth, button.getPreferredSize().width);
        this.maxHeight = Math.max(this.maxHeight, button.getPreferredSize().height);
        this.add(button);
        this.add(Box.createRigidArea(new Dimension(8, 1)));
        if (space > 0) {
            this.add(Box.createRigidArea(new Dimension(space, 1)));
        }
        Dimension size = new Dimension(this.maxWidth, this.maxHeight);
        for (Component comp : this.getComponents()) {
            if (!(comp instanceof AbstractButton)) continue;
            AbstractButton but = (AbstractButton)comp;
            but.setMinimumSize(size);
            but.setPreferredSize(size);
            but.setMaximumSize(size);
        }
        if (isDefault) {
            this.defaultButton = (JButton)button;
            this.setDefaultButton();
        }
        return button;
    }
}

