﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/model/FinalAutoMLJobObjectiveMetric.h>
#include <aws/sagemaker/model/ObjectiveStatus.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/sagemaker/model/CandidateStatus.h>
#include <aws/core/utils/DateTime.h>
#include <aws/sagemaker/model/AutoMLCandidateStep.h>
#include <aws/sagemaker/model/AutoMLContainerDefinition.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SageMaker
{
namespace Model
{

  /**
   * <p>An AutoPilot job will return recommendations, or candidates. Each candidate
   * has futher details about the steps involed, and the status.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AutoMLCandidate">AWS
   * API Reference</a></p>
   */
  class AWS_SAGEMAKER_API AutoMLCandidate
  {
  public:
    AutoMLCandidate();
    AutoMLCandidate(Aws::Utils::Json::JsonView jsonValue);
    AutoMLCandidate& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The candidate name.</p>
     */
    inline const Aws::String& GetCandidateName() const{ return m_candidateName; }

    /**
     * <p>The candidate name.</p>
     */
    inline bool CandidateNameHasBeenSet() const { return m_candidateNameHasBeenSet; }

    /**
     * <p>The candidate name.</p>
     */
    inline void SetCandidateName(const Aws::String& value) { m_candidateNameHasBeenSet = true; m_candidateName = value; }

    /**
     * <p>The candidate name.</p>
     */
    inline void SetCandidateName(Aws::String&& value) { m_candidateNameHasBeenSet = true; m_candidateName = std::move(value); }

    /**
     * <p>The candidate name.</p>
     */
    inline void SetCandidateName(const char* value) { m_candidateNameHasBeenSet = true; m_candidateName.assign(value); }

    /**
     * <p>The candidate name.</p>
     */
    inline AutoMLCandidate& WithCandidateName(const Aws::String& value) { SetCandidateName(value); return *this;}

    /**
     * <p>The candidate name.</p>
     */
    inline AutoMLCandidate& WithCandidateName(Aws::String&& value) { SetCandidateName(std::move(value)); return *this;}

    /**
     * <p>The candidate name.</p>
     */
    inline AutoMLCandidate& WithCandidateName(const char* value) { SetCandidateName(value); return *this;}


    
    inline const FinalAutoMLJobObjectiveMetric& GetFinalAutoMLJobObjectiveMetric() const{ return m_finalAutoMLJobObjectiveMetric; }

    
    inline bool FinalAutoMLJobObjectiveMetricHasBeenSet() const { return m_finalAutoMLJobObjectiveMetricHasBeenSet; }

    
    inline void SetFinalAutoMLJobObjectiveMetric(const FinalAutoMLJobObjectiveMetric& value) { m_finalAutoMLJobObjectiveMetricHasBeenSet = true; m_finalAutoMLJobObjectiveMetric = value; }

    
    inline void SetFinalAutoMLJobObjectiveMetric(FinalAutoMLJobObjectiveMetric&& value) { m_finalAutoMLJobObjectiveMetricHasBeenSet = true; m_finalAutoMLJobObjectiveMetric = std::move(value); }

    
    inline AutoMLCandidate& WithFinalAutoMLJobObjectiveMetric(const FinalAutoMLJobObjectiveMetric& value) { SetFinalAutoMLJobObjectiveMetric(value); return *this;}

    
    inline AutoMLCandidate& WithFinalAutoMLJobObjectiveMetric(FinalAutoMLJobObjectiveMetric&& value) { SetFinalAutoMLJobObjectiveMetric(std::move(value)); return *this;}


    /**
     * <p>The objective status.</p>
     */
    inline const ObjectiveStatus& GetObjectiveStatus() const{ return m_objectiveStatus; }

    /**
     * <p>The objective status.</p>
     */
    inline bool ObjectiveStatusHasBeenSet() const { return m_objectiveStatusHasBeenSet; }

    /**
     * <p>The objective status.</p>
     */
    inline void SetObjectiveStatus(const ObjectiveStatus& value) { m_objectiveStatusHasBeenSet = true; m_objectiveStatus = value; }

    /**
     * <p>The objective status.</p>
     */
    inline void SetObjectiveStatus(ObjectiveStatus&& value) { m_objectiveStatusHasBeenSet = true; m_objectiveStatus = std::move(value); }

    /**
     * <p>The objective status.</p>
     */
    inline AutoMLCandidate& WithObjectiveStatus(const ObjectiveStatus& value) { SetObjectiveStatus(value); return *this;}

    /**
     * <p>The objective status.</p>
     */
    inline AutoMLCandidate& WithObjectiveStatus(ObjectiveStatus&& value) { SetObjectiveStatus(std::move(value)); return *this;}


    /**
     * <p>The candidate's steps.</p>
     */
    inline const Aws::Vector<AutoMLCandidateStep>& GetCandidateSteps() const{ return m_candidateSteps; }

    /**
     * <p>The candidate's steps.</p>
     */
    inline bool CandidateStepsHasBeenSet() const { return m_candidateStepsHasBeenSet; }

    /**
     * <p>The candidate's steps.</p>
     */
    inline void SetCandidateSteps(const Aws::Vector<AutoMLCandidateStep>& value) { m_candidateStepsHasBeenSet = true; m_candidateSteps = value; }

    /**
     * <p>The candidate's steps.</p>
     */
    inline void SetCandidateSteps(Aws::Vector<AutoMLCandidateStep>&& value) { m_candidateStepsHasBeenSet = true; m_candidateSteps = std::move(value); }

    /**
     * <p>The candidate's steps.</p>
     */
    inline AutoMLCandidate& WithCandidateSteps(const Aws::Vector<AutoMLCandidateStep>& value) { SetCandidateSteps(value); return *this;}

    /**
     * <p>The candidate's steps.</p>
     */
    inline AutoMLCandidate& WithCandidateSteps(Aws::Vector<AutoMLCandidateStep>&& value) { SetCandidateSteps(std::move(value)); return *this;}

    /**
     * <p>The candidate's steps.</p>
     */
    inline AutoMLCandidate& AddCandidateSteps(const AutoMLCandidateStep& value) { m_candidateStepsHasBeenSet = true; m_candidateSteps.push_back(value); return *this; }

    /**
     * <p>The candidate's steps.</p>
     */
    inline AutoMLCandidate& AddCandidateSteps(AutoMLCandidateStep&& value) { m_candidateStepsHasBeenSet = true; m_candidateSteps.push_back(std::move(value)); return *this; }


    /**
     * <p>The candidate's status.</p>
     */
    inline const CandidateStatus& GetCandidateStatus() const{ return m_candidateStatus; }

    /**
     * <p>The candidate's status.</p>
     */
    inline bool CandidateStatusHasBeenSet() const { return m_candidateStatusHasBeenSet; }

    /**
     * <p>The candidate's status.</p>
     */
    inline void SetCandidateStatus(const CandidateStatus& value) { m_candidateStatusHasBeenSet = true; m_candidateStatus = value; }

    /**
     * <p>The candidate's status.</p>
     */
    inline void SetCandidateStatus(CandidateStatus&& value) { m_candidateStatusHasBeenSet = true; m_candidateStatus = std::move(value); }

    /**
     * <p>The candidate's status.</p>
     */
    inline AutoMLCandidate& WithCandidateStatus(const CandidateStatus& value) { SetCandidateStatus(value); return *this;}

    /**
     * <p>The candidate's status.</p>
     */
    inline AutoMLCandidate& WithCandidateStatus(CandidateStatus&& value) { SetCandidateStatus(std::move(value)); return *this;}


    /**
     * <p>The inference containers.</p>
     */
    inline const Aws::Vector<AutoMLContainerDefinition>& GetInferenceContainers() const{ return m_inferenceContainers; }

    /**
     * <p>The inference containers.</p>
     */
    inline bool InferenceContainersHasBeenSet() const { return m_inferenceContainersHasBeenSet; }

    /**
     * <p>The inference containers.</p>
     */
    inline void SetInferenceContainers(const Aws::Vector<AutoMLContainerDefinition>& value) { m_inferenceContainersHasBeenSet = true; m_inferenceContainers = value; }

    /**
     * <p>The inference containers.</p>
     */
    inline void SetInferenceContainers(Aws::Vector<AutoMLContainerDefinition>&& value) { m_inferenceContainersHasBeenSet = true; m_inferenceContainers = std::move(value); }

    /**
     * <p>The inference containers.</p>
     */
    inline AutoMLCandidate& WithInferenceContainers(const Aws::Vector<AutoMLContainerDefinition>& value) { SetInferenceContainers(value); return *this;}

    /**
     * <p>The inference containers.</p>
     */
    inline AutoMLCandidate& WithInferenceContainers(Aws::Vector<AutoMLContainerDefinition>&& value) { SetInferenceContainers(std::move(value)); return *this;}

    /**
     * <p>The inference containers.</p>
     */
    inline AutoMLCandidate& AddInferenceContainers(const AutoMLContainerDefinition& value) { m_inferenceContainersHasBeenSet = true; m_inferenceContainers.push_back(value); return *this; }

    /**
     * <p>The inference containers.</p>
     */
    inline AutoMLCandidate& AddInferenceContainers(AutoMLContainerDefinition&& value) { m_inferenceContainersHasBeenSet = true; m_inferenceContainers.push_back(std::move(value)); return *this; }


    /**
     * <p>The creation time.</p>
     */
    inline const Aws::Utils::DateTime& GetCreationTime() const{ return m_creationTime; }

    /**
     * <p>The creation time.</p>
     */
    inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }

    /**
     * <p>The creation time.</p>
     */
    inline void SetCreationTime(const Aws::Utils::DateTime& value) { m_creationTimeHasBeenSet = true; m_creationTime = value; }

    /**
     * <p>The creation time.</p>
     */
    inline void SetCreationTime(Aws::Utils::DateTime&& value) { m_creationTimeHasBeenSet = true; m_creationTime = std::move(value); }

    /**
     * <p>The creation time.</p>
     */
    inline AutoMLCandidate& WithCreationTime(const Aws::Utils::DateTime& value) { SetCreationTime(value); return *this;}

    /**
     * <p>The creation time.</p>
     */
    inline AutoMLCandidate& WithCreationTime(Aws::Utils::DateTime&& value) { SetCreationTime(std::move(value)); return *this;}


    /**
     * <p>The end time.</p>
     */
    inline const Aws::Utils::DateTime& GetEndTime() const{ return m_endTime; }

    /**
     * <p>The end time.</p>
     */
    inline bool EndTimeHasBeenSet() const { return m_endTimeHasBeenSet; }

    /**
     * <p>The end time.</p>
     */
    inline void SetEndTime(const Aws::Utils::DateTime& value) { m_endTimeHasBeenSet = true; m_endTime = value; }

    /**
     * <p>The end time.</p>
     */
    inline void SetEndTime(Aws::Utils::DateTime&& value) { m_endTimeHasBeenSet = true; m_endTime = std::move(value); }

    /**
     * <p>The end time.</p>
     */
    inline AutoMLCandidate& WithEndTime(const Aws::Utils::DateTime& value) { SetEndTime(value); return *this;}

    /**
     * <p>The end time.</p>
     */
    inline AutoMLCandidate& WithEndTime(Aws::Utils::DateTime&& value) { SetEndTime(std::move(value)); return *this;}


    /**
     * <p>The last modified time.</p>
     */
    inline const Aws::Utils::DateTime& GetLastModifiedTime() const{ return m_lastModifiedTime; }

    /**
     * <p>The last modified time.</p>
     */
    inline bool LastModifiedTimeHasBeenSet() const { return m_lastModifiedTimeHasBeenSet; }

    /**
     * <p>The last modified time.</p>
     */
    inline void SetLastModifiedTime(const Aws::Utils::DateTime& value) { m_lastModifiedTimeHasBeenSet = true; m_lastModifiedTime = value; }

    /**
     * <p>The last modified time.</p>
     */
    inline void SetLastModifiedTime(Aws::Utils::DateTime&& value) { m_lastModifiedTimeHasBeenSet = true; m_lastModifiedTime = std::move(value); }

    /**
     * <p>The last modified time.</p>
     */
    inline AutoMLCandidate& WithLastModifiedTime(const Aws::Utils::DateTime& value) { SetLastModifiedTime(value); return *this;}

    /**
     * <p>The last modified time.</p>
     */
    inline AutoMLCandidate& WithLastModifiedTime(Aws::Utils::DateTime&& value) { SetLastModifiedTime(std::move(value)); return *this;}


    /**
     * <p>The failure reason.</p>
     */
    inline const Aws::String& GetFailureReason() const{ return m_failureReason; }

    /**
     * <p>The failure reason.</p>
     */
    inline bool FailureReasonHasBeenSet() const { return m_failureReasonHasBeenSet; }

    /**
     * <p>The failure reason.</p>
     */
    inline void SetFailureReason(const Aws::String& value) { m_failureReasonHasBeenSet = true; m_failureReason = value; }

    /**
     * <p>The failure reason.</p>
     */
    inline void SetFailureReason(Aws::String&& value) { m_failureReasonHasBeenSet = true; m_failureReason = std::move(value); }

    /**
     * <p>The failure reason.</p>
     */
    inline void SetFailureReason(const char* value) { m_failureReasonHasBeenSet = true; m_failureReason.assign(value); }

    /**
     * <p>The failure reason.</p>
     */
    inline AutoMLCandidate& WithFailureReason(const Aws::String& value) { SetFailureReason(value); return *this;}

    /**
     * <p>The failure reason.</p>
     */
    inline AutoMLCandidate& WithFailureReason(Aws::String&& value) { SetFailureReason(std::move(value)); return *this;}

    /**
     * <p>The failure reason.</p>
     */
    inline AutoMLCandidate& WithFailureReason(const char* value) { SetFailureReason(value); return *this;}

  private:

    Aws::String m_candidateName;
    bool m_candidateNameHasBeenSet;

    FinalAutoMLJobObjectiveMetric m_finalAutoMLJobObjectiveMetric;
    bool m_finalAutoMLJobObjectiveMetricHasBeenSet;

    ObjectiveStatus m_objectiveStatus;
    bool m_objectiveStatusHasBeenSet;

    Aws::Vector<AutoMLCandidateStep> m_candidateSteps;
    bool m_candidateStepsHasBeenSet;

    CandidateStatus m_candidateStatus;
    bool m_candidateStatusHasBeenSet;

    Aws::Vector<AutoMLContainerDefinition> m_inferenceContainers;
    bool m_inferenceContainersHasBeenSet;

    Aws::Utils::DateTime m_creationTime;
    bool m_creationTimeHasBeenSet;

    Aws::Utils::DateTime m_endTime;
    bool m_endTimeHasBeenSet;

    Aws::Utils::DateTime m_lastModifiedTime;
    bool m_lastModifiedTimeHasBeenSet;

    Aws::String m_failureReason;
    bool m_failureReasonHasBeenSet;
  };

} // namespace Model
} // namespace SageMaker
} // namespace Aws
