'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _stringify = require('babel-runtime/core-js/json/stringify');

var _stringify2 = _interopRequireDefault(_stringify);

var _keys = require('babel-runtime/core-js/object/keys');

var _keys2 = _interopRequireDefault(_keys);

var _values = require('babel-runtime/core-js/object/values');

var _values2 = _interopRequireDefault(_values);

var _slicedToArray2 = require('babel-runtime/helpers/slicedToArray');

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _entries = require('babel-runtime/core-js/object/entries');

var _entries2 = _interopRequireDefault(_entries);

var _getIterator2 = require('babel-runtime/core-js/get-iterator');

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

var _logger = require('../../logger');

var _logger2 = _interopRequireDefault(_logger);

var _memoryCryptoStore = require('./memory-crypto-store');

var _memoryCryptoStore2 = _interopRequireDefault(_memoryCryptoStore);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Internal module. Partial localStorage backed storage for e2e.
 * This is not a full crypto store, just the in-memory store with
 * some things backed by localStorage. It exists because indexedDB
 * is broken in Firefox private mode or set to, "will not remember
 * history".
 *
 * @module
 */

var E2E_PREFIX = "crypto."; /*
                            Copyright 2017, 2018 New Vector Ltd
                            
                            Licensed under the Apache License, Version 2.0 (the "License");
                            you may not use this file except in compliance with the License.
                            You may obtain a copy of the License at
                            
                                http://www.apache.org/licenses/LICENSE-2.0
                            
                            Unless required by applicable law or agreed to in writing, software
                            distributed under the License is distributed on an "AS IS" BASIS,
                            WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
                            See the License for the specific language governing permissions and
                            limitations under the License.
                            */

var KEY_END_TO_END_ACCOUNT = E2E_PREFIX + "account";
var KEY_CROSS_SIGNING_KEYS = E2E_PREFIX + "cross_signing_keys";
var KEY_DEVICE_DATA = E2E_PREFIX + "device_data";
var KEY_INBOUND_SESSION_PREFIX = E2E_PREFIX + "inboundgroupsessions/";
var KEY_ROOMS_PREFIX = E2E_PREFIX + "rooms/";
var KEY_SESSIONS_NEEDING_BACKUP = E2E_PREFIX + "sessionsneedingbackup";

function keyEndToEndSessions(deviceKey) {
    return E2E_PREFIX + "sessions/" + deviceKey;
}

function keyEndToEndInboundGroupSession(senderKey, sessionId) {
    return KEY_INBOUND_SESSION_PREFIX + senderKey + "/" + sessionId;
}

function keyEndToEndRoomsPrefix(roomId) {
    return KEY_ROOMS_PREFIX + roomId;
}

/**
 * @implements {module:crypto/store/base~CryptoStore}
 */

var LocalStorageCryptoStore = function (_MemoryCryptoStore) {
    (0, _inherits3.default)(LocalStorageCryptoStore, _MemoryCryptoStore);

    function LocalStorageCryptoStore(webStore) {
        (0, _classCallCheck3.default)(this, LocalStorageCryptoStore);

        var _this = (0, _possibleConstructorReturn3.default)(this, (LocalStorageCryptoStore.__proto__ || (0, _getPrototypeOf2.default)(LocalStorageCryptoStore)).call(this));

        _this.store = webStore;
        return _this;
    }

    (0, _createClass3.default)(LocalStorageCryptoStore, [{
        key: 'countEndToEndSessions',


        // Olm Sessions

        value: function countEndToEndSessions(txn, func) {
            var count = 0;
            for (var i = 0; i < this.store.length; ++i) {
                if (this.store.key(i).startsWith(keyEndToEndSessions(''))) ++count;
            }
            func(count);
        }
    }, {
        key: '_getEndToEndSessions',
        value: function _getEndToEndSessions(deviceKey, txn, func) {
            var sessions = getJsonItem(this.store, keyEndToEndSessions(deviceKey));
            var fixedSessions = {};

            // fix up any old sessions to be objects rather than just the base64 pickle
            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                for (var _iterator = (0, _getIterator3.default)((0, _entries2.default)(sessions || {})), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    var _step$value = (0, _slicedToArray3.default)(_step.value, 2),
                        sid = _step$value[0],
                        val = _step$value[1];

                    if (typeof val === 'string') {
                        fixedSessions[sid] = {
                            session: val
                        };
                    } else {
                        fixedSessions[sid] = val;
                    }
                }
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator.return) {
                        _iterator.return();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }

            return fixedSessions;
        }
    }, {
        key: 'getEndToEndSession',
        value: function getEndToEndSession(deviceKey, sessionId, txn, func) {
            var sessions = this._getEndToEndSessions(deviceKey);
            func(sessions[sessionId] || {});
        }
    }, {
        key: 'getEndToEndSessions',
        value: function getEndToEndSessions(deviceKey, txn, func) {
            func(this._getEndToEndSessions(deviceKey) || {});
        }
    }, {
        key: 'getAllEndToEndSessions',
        value: function getAllEndToEndSessions(txn, func) {
            for (var i = 0; i < this.store.length; ++i) {
                if (this.store.key(i).startsWith(keyEndToEndSessions(''))) {
                    var deviceKey = this.store.key(i).split('/')[1];
                    var _iteratorNormalCompletion2 = true;
                    var _didIteratorError2 = false;
                    var _iteratorError2 = undefined;

                    try {
                        for (var _iterator2 = (0, _getIterator3.default)((0, _values2.default)(this._getEndToEndSessions(deviceKey))), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                            var sess = _step2.value;

                            func(sess);
                        }
                    } catch (err) {
                        _didIteratorError2 = true;
                        _iteratorError2 = err;
                    } finally {
                        try {
                            if (!_iteratorNormalCompletion2 && _iterator2.return) {
                                _iterator2.return();
                            }
                        } finally {
                            if (_didIteratorError2) {
                                throw _iteratorError2;
                            }
                        }
                    }
                }
            }
        }
    }, {
        key: 'storeEndToEndSession',
        value: function storeEndToEndSession(deviceKey, sessionId, sessionInfo, txn) {
            var sessions = this._getEndToEndSessions(deviceKey) || {};
            sessions[sessionId] = sessionInfo;
            setJsonItem(this.store, keyEndToEndSessions(deviceKey), sessions);
        }

        // Inbound Group Sessions

    }, {
        key: 'getEndToEndInboundGroupSession',
        value: function getEndToEndInboundGroupSession(senderCurve25519Key, sessionId, txn, func) {
            func(getJsonItem(this.store, keyEndToEndInboundGroupSession(senderCurve25519Key, sessionId)));
        }
    }, {
        key: 'getAllEndToEndInboundGroupSessions',
        value: function getAllEndToEndInboundGroupSessions(txn, func) {
            for (var i = 0; i < this.store.length; ++i) {
                var key = this.store.key(i);
                if (key.startsWith(KEY_INBOUND_SESSION_PREFIX)) {
                    // we can't use split, as the components we are trying to split out
                    // might themselves contain '/' characters. We rely on the
                    // senderKey being a (32-byte) curve25519 key, base64-encoded
                    // (hence 43 characters long).

                    func({
                        senderKey: key.substr(KEY_INBOUND_SESSION_PREFIX.length, 43),
                        sessionId: key.substr(KEY_INBOUND_SESSION_PREFIX.length + 44),
                        sessionData: getJsonItem(this.store, key)
                    });
                }
            }
            func(null);
        }
    }, {
        key: 'addEndToEndInboundGroupSession',
        value: function addEndToEndInboundGroupSession(senderCurve25519Key, sessionId, sessionData, txn) {
            var existing = getJsonItem(this.store, keyEndToEndInboundGroupSession(senderCurve25519Key, sessionId));
            if (!existing) {
                this.storeEndToEndInboundGroupSession(senderCurve25519Key, sessionId, sessionData, txn);
            }
        }
    }, {
        key: 'storeEndToEndInboundGroupSession',
        value: function storeEndToEndInboundGroupSession(senderCurve25519Key, sessionId, sessionData, txn) {
            setJsonItem(this.store, keyEndToEndInboundGroupSession(senderCurve25519Key, sessionId), sessionData);
        }
    }, {
        key: 'getEndToEndDeviceData',
        value: function getEndToEndDeviceData(txn, func) {
            func(getJsonItem(this.store, KEY_DEVICE_DATA));
        }
    }, {
        key: 'storeEndToEndDeviceData',
        value: function storeEndToEndDeviceData(deviceData, txn) {
            setJsonItem(this.store, KEY_DEVICE_DATA, deviceData);
        }
    }, {
        key: 'storeEndToEndRoom',
        value: function storeEndToEndRoom(roomId, roomInfo, txn) {
            setJsonItem(this.store, keyEndToEndRoomsPrefix(roomId), roomInfo);
        }
    }, {
        key: 'getEndToEndRooms',
        value: function getEndToEndRooms(txn, func) {
            var result = {};
            var prefix = keyEndToEndRoomsPrefix('');

            for (var i = 0; i < this.store.length; ++i) {
                var key = this.store.key(i);
                if (key.startsWith(prefix)) {
                    var roomId = key.substr(prefix.length);
                    result[roomId] = getJsonItem(this.store, key);
                }
            }
            func(result);
        }
    }, {
        key: 'getSessionsNeedingBackup',
        value: function getSessionsNeedingBackup(limit) {
            var _this2 = this;

            var sessionsNeedingBackup = getJsonItem(this.store, KEY_SESSIONS_NEEDING_BACKUP) || {};
            var sessions = [];

            for (var session in sessionsNeedingBackup) {
                if (Object.prototype.hasOwnProperty.call(sessionsNeedingBackup, session)) {
                    var _ret = function () {
                        // see getAllEndToEndInboundGroupSessions for the magic number explanations
                        var senderKey = session.substr(0, 43);
                        var sessionId = session.substr(44);
                        _this2.getEndToEndInboundGroupSession(senderKey, sessionId, null, function (sessionData) {
                            sessions.push({
                                senderKey: senderKey,
                                sessionId: sessionId,
                                sessionData: sessionData
                            });
                        });
                        if (limit && session.length >= limit) {
                            return 'break';
                        }
                    }();

                    if (_ret === 'break') break;
                }
            }
            return _bluebird2.default.resolve(sessions);
        }
    }, {
        key: 'countSessionsNeedingBackup',
        value: function countSessionsNeedingBackup() {
            var sessionsNeedingBackup = getJsonItem(this.store, KEY_SESSIONS_NEEDING_BACKUP) || {};
            return _bluebird2.default.resolve((0, _keys2.default)(sessionsNeedingBackup).length);
        }
    }, {
        key: 'unmarkSessionsNeedingBackup',
        value: function unmarkSessionsNeedingBackup(sessions) {
            var sessionsNeedingBackup = getJsonItem(this.store, KEY_SESSIONS_NEEDING_BACKUP) || {};
            var _iteratorNormalCompletion3 = true;
            var _didIteratorError3 = false;
            var _iteratorError3 = undefined;

            try {
                for (var _iterator3 = (0, _getIterator3.default)(sessions), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
                    var session = _step3.value;

                    delete sessionsNeedingBackup[session.senderKey + '/' + session.sessionId];
                }
            } catch (err) {
                _didIteratorError3 = true;
                _iteratorError3 = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion3 && _iterator3.return) {
                        _iterator3.return();
                    }
                } finally {
                    if (_didIteratorError3) {
                        throw _iteratorError3;
                    }
                }
            }

            setJsonItem(this.store, KEY_SESSIONS_NEEDING_BACKUP, sessionsNeedingBackup);
            return _bluebird2.default.resolve();
        }
    }, {
        key: 'markSessionsNeedingBackup',
        value: function markSessionsNeedingBackup(sessions) {
            var sessionsNeedingBackup = getJsonItem(this.store, KEY_SESSIONS_NEEDING_BACKUP) || {};
            var _iteratorNormalCompletion4 = true;
            var _didIteratorError4 = false;
            var _iteratorError4 = undefined;

            try {
                for (var _iterator4 = (0, _getIterator3.default)(sessions), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
                    var session = _step4.value;

                    sessionsNeedingBackup[session.senderKey + '/' + session.sessionId] = true;
                }
            } catch (err) {
                _didIteratorError4 = true;
                _iteratorError4 = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion4 && _iterator4.return) {
                        _iterator4.return();
                    }
                } finally {
                    if (_didIteratorError4) {
                        throw _iteratorError4;
                    }
                }
            }

            setJsonItem(this.store, KEY_SESSIONS_NEEDING_BACKUP, sessionsNeedingBackup);
            return _bluebird2.default.resolve();
        }

        /**
         * Delete all data from this store.
         *
         * @returns {Promise} Promise which resolves when the store has been cleared.
         */

    }, {
        key: 'deleteAllData',
        value: function deleteAllData() {
            this.store.removeItem(KEY_END_TO_END_ACCOUNT);
            return _bluebird2.default.resolve();
        }

        // Olm account

    }, {
        key: 'getAccount',
        value: function getAccount(txn, func) {
            var account = getJsonItem(this.store, KEY_END_TO_END_ACCOUNT);
            func(account);
        }
    }, {
        key: 'storeAccount',
        value: function storeAccount(txn, newData) {
            setJsonItem(this.store, KEY_END_TO_END_ACCOUNT, newData);
        }
    }, {
        key: 'getCrossSigningKeys',
        value: function getCrossSigningKeys(txn, func) {
            var keys = getJsonItem(this.store, KEY_CROSS_SIGNING_KEYS);
            func(keys);
        }
    }, {
        key: 'storeCrossSigningKeys',
        value: function storeCrossSigningKeys(txn, keys) {
            setJsonItem(this.store, KEY_CROSS_SIGNING_KEYS, keys);
        }
    }, {
        key: 'doTxn',
        value: function doTxn(mode, stores, func) {
            return _bluebird2.default.resolve(func(null));
        }
    }], [{
        key: 'exists',
        value: function exists(webStore) {
            var length = webStore.length;
            for (var i = 0; i < length; i++) {
                if (webStore.key(i).startsWith(E2E_PREFIX)) {
                    return true;
                }
            }
            return false;
        }
    }]);
    return LocalStorageCryptoStore;
}(_memoryCryptoStore2.default);

exports.default = LocalStorageCryptoStore;


function getJsonItem(store, key) {
    try {
        // if the key is absent, store.getItem() returns null, and
        // JSON.parse(null) === null, so this returns null.
        return JSON.parse(store.getItem(key));
    } catch (e) {
        _logger2.default.log("Error: Failed to get key %s: %s", key, e.stack || e);
        _logger2.default.log(e.stack);
    }
    return null;
}

function setJsonItem(store, key, val) {
    store.setItem(key, (0, _stringify2.default)(val));
}
//# sourceMappingURL=localStorage-crypto-store.js.map