/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.util.EventObject;
import org.apache.subversion.javahl.ClientNotifyInformation;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.NodeKind;
import org.tigris.subversion.javahl.RevisionRange;

public class NotifyInformation
extends EventObject {
    private static final long serialVersionUID = 1L;
    private int action;
    private int kind;
    private String mimeType;
    private Lock lock;
    private String errMsg;
    private int contentState;
    private int propState;
    private int lockState;
    private long revision;
    private String changelistName;
    private RevisionRange mergeRange;
    private String pathPrefix;

    NotifyInformation(String string, int n, int n2, String string2, Lock lock, String string3, int n3, int n4, int n5, long l, String string4, RevisionRange revisionRange, String string5) {
        super(string == null ? "" : string);
        this.action = n;
        this.kind = n2;
        this.mimeType = string2;
        this.lock = lock;
        this.errMsg = string3;
        this.contentState = n3;
        this.propState = n4;
        this.lockState = n5;
        this.revision = l;
        this.changelistName = string4;
        this.mergeRange = revisionRange;
        this.pathPrefix = string5;
    }

    public NotifyInformation(ClientNotifyInformation clientNotifyInformation) {
        this(clientNotifyInformation.getPath(), NotifyInformation.fromAAction(clientNotifyInformation.getAction()), NodeKind.fromApache(clientNotifyInformation.getKind()), clientNotifyInformation.getMimeType(), clientNotifyInformation.getLock() == null ? null : new Lock(clientNotifyInformation.getLock()), clientNotifyInformation.getErrMsg(), NotifyInformation.fromAStatus(clientNotifyInformation.getContentState()), NotifyInformation.fromAStatus(clientNotifyInformation.getPropState()), clientNotifyInformation.getLockState().ordinal(), clientNotifyInformation.getRevision(), clientNotifyInformation.getChangelistName(), clientNotifyInformation.getMergeRange() == null ? null : new RevisionRange(clientNotifyInformation.getMergeRange()), clientNotifyInformation.getPathPrefix());
    }

    public String getPath() {
        return (String)this.source;
    }

    public int getAction() {
        return this.action;
    }

    public int getKind() {
        return this.kind;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Lock getLock() {
        return this.lock;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public int getContentState() {
        return this.contentState;
    }

    public int getPropState() {
        return this.propState;
    }

    public int getLockState() {
        return this.lockState;
    }

    public long getRevision() {
        return this.revision;
    }

    public String getChangelistName() {
        return this.changelistName;
    }

    public RevisionRange getMergeRange() {
        return this.mergeRange;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    private static int fromAStatus(ClientNotifyInformation.Status status) {
        switch (status) {
            default: {
                return 0;
            }
            case unknown: {
                return 1;
            }
            case unchanged: {
                return 2;
            }
            case missing: {
                return 3;
            }
            case obstructed: {
                return 4;
            }
            case changed: {
                return 5;
            }
            case merged: {
                return 6;
            }
            case conflicted: 
        }
        return 7;
    }

    private static int fromAAction(ClientNotifyInformation.Action action) {
        if (action == null) {
            return -1;
        }
        int n = action.ordinal();
        if (n < 27) {
            return n;
        }
        return n - 1;
    }
}

