/**
 * @file xmss.h
 * Includes headers required for Extended Hash-Based Signatures (XMSS)
 * as described in [1]. @see Botan::XMSS_PublicKey and @see
 * Botan::XMSS_PrivateKey for further
 * details.
 *
 * <pre>
 * [1] XMSS: Extended Hash-Based Signatures,
 *     Request for Comments: 8391
 *     Release: May 2018.
 *     https://datatracker.ietf.org/doc/rfc8391/
 * </pre>
 *
 * (C) 2016,2017,2018 Matthias Gierlings
 *
 * Botan is released under the Simplified BSD License (see license.txt)
 **/

#ifndef BOTAN_XMSS_H_
#define BOTAN_XMSS_H_

#include <botan/xmss_publickey.h>
#include <botan/xmss_privatekey.h>

#endif
