/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class ImportHandler
extends RequestHandler.RawURLParseRequestHandler {
    public static final String command = "import";
    private URL url;
    private Collection<DownloadTask> suitableDownloadTasks;

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        try {
            if (this.suitableDownloadTasks.isEmpty()) {
                Logging.debug("Remote control, /import: defaulting to DownloadOsmTask");
                new DownloadOsmTask().loadUrl(this.getDownloadParams(), this.url.toExternalForm(), null);
            } else if (Config.getPref().getBoolean("remotecontrol.import.interactive", true)) {
                MainApplication.getMenu().openLocation.openUrl(this.getDownloadParams(), this.url.toExternalForm());
            } else {
                for (DownloadTask task : this.suitableDownloadTasks) {
                    task.loadUrl(this.getDownloadParams(), this.url.toExternalForm(), null);
                }
            }
        }
        catch (RuntimeException ex) {
            Logging.warn("RemoteControl: Error parsing import remote control request:");
            Logging.error(ex);
            throw new RequestHandler.RequestHandlerErrorException(ex);
        }
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"url"};
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"new_layer", "layer_name", "layer_locked", "download_policy", "upload_policy"};
    }

    @Override
    public String getUsage() {
        return "downloads the specified OSM file and adds it to the current data set";
    }

    @Override
    public String[] getUsageExamples() {
        return new String[]{"/import?url=" + Utils.encodeUrl(Config.getUrls().getJOSMWebsite() + "/browser/josm/trunk/nodist/data/direction-arrows.osm?format=txt")};
    }

    @Override
    public String getPermissionMessage() {
        LinkedHashSet<String> taskMessages = new LinkedHashSet<String>();
        if (this.suitableDownloadTasks != null && !this.suitableDownloadTasks.isEmpty()) {
            for (DownloadTask task : this.suitableDownloadTasks) {
                taskMessages.add(Utils.firstNonNull(task.getConfirmationMessage(this.url), this.url.toString()));
            }
        }
        return I18n.tr("Remote Control has been asked to import data from the following URL:", new Object[0]) + Utils.joinAsHtmlUnorderedList(taskMessages);
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.IMPORT_DATA;
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        String urlString;
        this.validateDownloadParams();
        String string = urlString = this.args != null ? (String)this.args.get("url") : null;
        if (Config.getPref().getBoolean("remotecontrol.importhandler.fix_url_query", true)) {
            urlString = Utils.fixURLQuery(urlString);
        }
        try {
            this.url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RequestHandler.RequestHandlerBadRequestException("MalformedURLException: " + e.getMessage(), e);
        }
        this.suitableDownloadTasks = MainApplication.getMenu().openLocation.findDownloadTasks(urlString, true);
    }
}

