/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.EmbeddedDiagram;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.creole.CreoleContext;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleStripeSimpleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.Stripe;
import net.sourceforge.plantuml.creole.StripeTable;
import net.sourceforge.plantuml.creole.StripeTree;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class CreoleParser {
    private final FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;
    private final HorizontalAlignment horizontalAlignment;
    private final CreoleMode creoleMode;
    private final FontConfiguration stereotypeConfiguration;

    public CreoleParser(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple skinParam, CreoleMode creoleMode) {
        this(fontConfiguration, horizontalAlignment, skinParam, creoleMode, fontConfiguration.forceFont(null, null));
    }

    public CreoleParser(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple skinParam, CreoleMode creoleMode, FontConfiguration stereotypeConfiguration) {
        this.stereotypeConfiguration = stereotypeConfiguration;
        this.creoleMode = creoleMode;
        this.fontConfiguration = fontConfiguration;
        this.skinParam = skinParam;
        if (skinParam == null) {
            throw new IllegalArgumentException();
        }
        this.horizontalAlignment = horizontalAlignment;
    }

    private Stripe createStripe(String line, CreoleContext context, Stripe lastStripe, FontConfiguration fontConfiguration) {
        if (lastStripe instanceof StripeTable && CreoleParser.isTableLine(line)) {
            StripeTable table = (StripeTable)lastStripe;
            table.analyzeAndAddLine(line);
            return null;
        }
        if (lastStripe instanceof StripeTree && CreoleParser.isTreeStart(StringUtils.trinNoTrace(line))) {
            StripeTree tree = (StripeTree)lastStripe;
            tree.analyzeAndAdd(line);
            return null;
        }
        if (CreoleParser.isTableLine(line)) {
            return new StripeTable(fontConfiguration, this.skinParam, line);
        }
        if (CreoleParser.isTreeStart(line)) {
            return new StripeTree(fontConfiguration, this.skinParam, line);
        }
        return new CreoleStripeSimpleParser(line, context, fontConfiguration, this.skinParam, this.creoleMode).createStripe(context);
    }

    private static boolean isTableLine(String line) {
        return line.matches("^(\\<#\\w+(,#?\\w+)?\\>)?\\|(\\=)?.*\\|$");
    }

    public static boolean doesStartByColor(String line) {
        return line.matches("^\\=?\\s*(\\<#\\w+(,#?\\w+)?\\>).*");
    }

    public static boolean isTreeStart(String line) {
        return line.startsWith("|_");
    }

    public Sheet createSheet(Display display) {
        Sheet sheet = new Sheet(this.horizontalAlignment);
        if (!Display.isNull(display)) {
            CreoleContext context = new CreoleContext();
            for (CharSequence cs : display) {
                Stripe stripe;
                if (cs instanceof EmbeddedDiagram) {
                    final EmbeddedDiagram.Draw atom = ((EmbeddedDiagram)cs).asDraw(this.skinParam);
                    stripe = new Stripe(){

                        @Override
                        public Atom getHeader() {
                            return null;
                        }

                        @Override
                        public List<Atom> getAtoms() {
                            return Arrays.asList(atom);
                        }
                    };
                } else {
                    if (cs instanceof Stereotype) {
                        for (String st : ((Stereotype)cs).getLabels(this.skinParam.guillemet())) {
                            sheet.add(this.createStripe(st, context, sheet.getLastStripe(), this.stereotypeConfiguration));
                        }
                        continue;
                    }
                    stripe = this.createStripe(cs.toString(), context, sheet.getLastStripe(), this.fontConfiguration);
                }
                if (stripe == null) continue;
                sheet.add(stripe);
            }
        }
        return sheet;
    }
}

