/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.command;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.creole.command.Command;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class CommandCreoleColorAndSizeChange
implements Command {
    private final Pattern2 pattern;
    public static final String fontPattern = "\\<font(?:[%s]+size[%s]*=[%s]*[%g]?(\\d+)[%g]?|[%s]+color[%s]*=[%s]*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>";

    public static Command create() {
        return new CommandCreoleColorAndSizeChange("^(?i)(\\<font(?:[%s]+size[%s]*=[%s]*[%g]?(\\d+)[%g]?|[%s]+color[%s]*=[%s]*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>(.*?)\\</font\\>)");
    }

    public static Command createEol() {
        return new CommandCreoleColorAndSizeChange("^(?i)(\\<font(?:[%s]+size[%s]*=[%s]*[%g]?(\\d+)[%g]?|[%s]+color[%s]*=[%s]*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>(.*))$");
    }

    private CommandCreoleColorAndSizeChange(String p) {
        this.pattern = MyPattern.cmpile(p);
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        FontConfiguration fc1;
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc2 = fc1 = stripe.getActualFontConfiguration();
        if (m.group(2) != null) {
            fc2 = fc2.changeSize(Integer.parseInt(m.group(2)));
        }
        if (m.group(3) != null) {
            HColor color = HColorSet.instance().getColorIfValid(m.group(3));
            fc2 = fc2.changeColor(color);
        }
        stripe.setActualFontConfiguration(fc2);
        stripe.analyzeAndAdd(m.group(4));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m.group(1).length());
    }
}

