/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.cucadiagram.LinkStyle;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class HtmlColorAndStyle {
    private final HColor color;
    private final LinkStyle style;

    public String toString() {
        return this.color + " " + this.style;
    }

    public HtmlColorAndStyle(HColor color) {
        this(color, LinkStyle.NORMAL());
    }

    public HtmlColorAndStyle(HColor color, LinkStyle style) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this.color = color;
        this.style = style;
    }

    public HColor getColor() {
        return this.color;
    }

    public LinkStyle getStyle() {
        return this.style;
    }

    public static final StyleSignature getDefaultStyleDefinitionArrow() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    public static HtmlColorAndStyle build(ISkinParam skinParam, String definition) {
        HColor color;
        Object style;
        if (SkinParam.USE_STYLES()) {
            style = HtmlColorAndStyle.getDefaultStyleDefinitionArrow().getMergedStyle(skinParam.getCurrentStyleBuilder());
            color = ((Style)style).value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
        } else {
            color = Rainbow.build((ISkinParam)skinParam).getColors().get((int)0).color;
        }
        style = LinkStyle.NORMAL();
        HColorSet set = skinParam.getIHtmlColorSet();
        for (String s : definition.split(",")) {
            LinkStyle tmpStyle = LinkStyle.fromString1(s);
            if (!tmpStyle.isNormal()) {
                style = tmpStyle;
                continue;
            }
            HColor tmpColor = set.getColorIfValid(s);
            if (tmpColor == null) continue;
            color = tmpColor;
        }
        return new HtmlColorAndStyle(color, (LinkStyle)style);
    }
}

