/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.math.BigDecimal;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingFormat;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.graphic.PlayerFrame;
import net.sourceforge.plantuml.timingdiagram.graphic.PlayerFrameEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class PlayerClock
extends Player {
    private final int period;
    private final int pulse;
    private final double ymargin = 8.0;

    public PlayerClock(ISkinParam skinParam, TimingRuler ruler, int period, int pulse) {
        super("", skinParam, ruler);
        this.period = period;
        this.pulse = pulse;
    }

    @Override
    public double getFullHeight(StringBounder striWngBounder) {
        return 30.0;
    }

    private SymbolContext getContext() {
        return new SymbolContext(HColorUtils.COL_D7E0F2, HColorUtils.COL_038048).withStroke(new UStroke(1.5));
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addNote(TimeTick now, Display note, Position position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void defineState(String stateCode, String label) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setState(TimeTick now, String comment, Colors color, String ... states) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createConstraint(TimeTick tick1, TimeTick tick2, String message) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PlayerFrame getPlayerFrame() {
        return new PlayerFrameEmpty();
    }

    private double getPulseCoef() {
        if (this.pulse == 0) {
            return 0.5;
        }
        return 1.0 * (double)this.pulse / (double)this.period;
    }

    public final int getPeriod() {
        return this.period;
    }

    @Override
    public TextBlock getPart1() {
        return TextBlockUtils.empty(0.0, 0.0);
    }

    @Override
    public UDrawable getPart2() {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                ug = PlayerClock.this.getContext().apply(ug);
                ULine vline = ULine.vline(PlayerClock.this.getFullHeight(ug.getStringBounder()) - 16.0);
                int i = 0;
                double lastx = -1.7976931348623157E308;
                while (i < 1000) {
                    double x = PlayerClock.this.ruler.getPosInPixel(new TimeTick(new BigDecimal(i * PlayerClock.this.period), TimingFormat.DECIMAL));
                    if (x > PlayerClock.this.ruler.getWidth()) {
                        return;
                    }
                    ++i;
                    if (x > lastx) {
                        double dx = x - lastx;
                        ULine hline1 = ULine.hline(dx * PlayerClock.this.getPulseCoef());
                        ULine hline2 = ULine.hline(dx * (1.0 - PlayerClock.this.getPulseCoef()));
                        ug.apply(new UTranslate(lastx, 8.0)).draw(vline);
                        ug.apply(new UTranslate(lastx, 8.0)).draw(hline1);
                        double x2 = lastx + dx * PlayerClock.this.getPulseCoef();
                        ug.apply(new UTranslate(x2, 8.0)).draw(vline);
                        ug.apply(new UTranslate(x2, 8.0 + vline.getDY())).draw(hline2);
                    }
                    lastx = x;
                }
            }
        };
    }
}

