(function() {
  var error, keytar, tokenName;

  try {
    keytar = require('keytar');
  } catch (error1) {
    error = error1;
    if (process.platform === 'linux') {
      keytar = {
        findPassword: function() {
          return Promise.reject();
        },
        setPassword: function() {
          return Promise.reject();
        }
      };
    } else {
      throw error;
    }
  }

  tokenName = 'Atom.io API Token';

  module.exports = {
    getToken: function(callback) {
      return keytar.findPassword(tokenName).then(function(token) {
        if (token) {
          return callback(null, token);
        } else {
          return Promise.reject();
        }
      })["catch"](function() {
        var token;
        if (token = process.env.ATOM_ACCESS_TOKEN) {
          return callback(null, token);
        } else {
          return callback("No Atom.io API token in keychain\nRun `apm login` or set the `ATOM_ACCESS_TOKEN` environment variable.");
        }
      });
    },
    saveToken: function(token) {
      return keytar.setPassword(tokenName, 'atom.io', token);
    }
  };

}).call(this);
