﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/elasticache/ElastiCache_EXPORTS.h>
#include <aws/elasticache/ElastiCacheRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/elasticache/model/RegionalConfiguration.h>
#include <utility>

namespace Aws
{
namespace ElastiCache
{
namespace Model
{

  /**
   */
  class AWS_ELASTICACHE_API IncreaseNodeGroupsInGlobalReplicationGroupRequest : public ElastiCacheRequest
  {
  public:
    IncreaseNodeGroupsInGlobalReplicationGroupRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "IncreaseNodeGroupsInGlobalReplicationGroup"; }

    Aws::String SerializePayload() const override;

  protected:
    void DumpBodyToUrl(Aws::Http::URI& uri ) const override;

  public:

    /**
     * <p>The name of the Global Datastore</p>
     */
    inline const Aws::String& GetGlobalReplicationGroupId() const{ return m_globalReplicationGroupId; }

    /**
     * <p>The name of the Global Datastore</p>
     */
    inline bool GlobalReplicationGroupIdHasBeenSet() const { return m_globalReplicationGroupIdHasBeenSet; }

    /**
     * <p>The name of the Global Datastore</p>
     */
    inline void SetGlobalReplicationGroupId(const Aws::String& value) { m_globalReplicationGroupIdHasBeenSet = true; m_globalReplicationGroupId = value; }

    /**
     * <p>The name of the Global Datastore</p>
     */
    inline void SetGlobalReplicationGroupId(Aws::String&& value) { m_globalReplicationGroupIdHasBeenSet = true; m_globalReplicationGroupId = std::move(value); }

    /**
     * <p>The name of the Global Datastore</p>
     */
    inline void SetGlobalReplicationGroupId(const char* value) { m_globalReplicationGroupIdHasBeenSet = true; m_globalReplicationGroupId.assign(value); }

    /**
     * <p>The name of the Global Datastore</p>
     */
    inline IncreaseNodeGroupsInGlobalReplicationGroupRequest& WithGlobalReplicationGroupId(const Aws::String& value) { SetGlobalReplicationGroupId(value); return *this;}

    /**
     * <p>The name of the Global Datastore</p>
     */
    inline IncreaseNodeGroupsInGlobalReplicationGroupRequest& WithGlobalReplicationGroupId(Aws::String&& value) { SetGlobalReplicationGroupId(std::move(value)); return *this;}

    /**
     * <p>The name of the Global Datastore</p>
     */
    inline IncreaseNodeGroupsInGlobalReplicationGroupRequest& WithGlobalReplicationGroupId(const char* value) { SetGlobalReplicationGroupId(value); return *this;}


    /**
     * <p>The number of node groups you wish to add</p>
     */
    inline int GetNodeGroupCount() const{ return m_nodeGroupCount; }

    /**
     * <p>The number of node groups you wish to add</p>
     */
    inline bool NodeGroupCountHasBeenSet() const { return m_nodeGroupCountHasBeenSet; }

    /**
     * <p>The number of node groups you wish to add</p>
     */
    inline void SetNodeGroupCount(int value) { m_nodeGroupCountHasBeenSet = true; m_nodeGroupCount = value; }

    /**
     * <p>The number of node groups you wish to add</p>
     */
    inline IncreaseNodeGroupsInGlobalReplicationGroupRequest& WithNodeGroupCount(int value) { SetNodeGroupCount(value); return *this;}


    /**
     * <p>Describes the replication group IDs, the AWS regions where they are stored
     * and the shard configuration for each that comprise the Global Datastore</p>
     */
    inline const Aws::Vector<RegionalConfiguration>& GetRegionalConfigurations() const{ return m_regionalConfigurations; }

    /**
     * <p>Describes the replication group IDs, the AWS regions where they are stored
     * and the shard configuration for each that comprise the Global Datastore</p>
     */
    inline bool RegionalConfigurationsHasBeenSet() const { return m_regionalConfigurationsHasBeenSet; }

    /**
     * <p>Describes the replication group IDs, the AWS regions where they are stored
     * and the shard configuration for each that comprise the Global Datastore</p>
     */
    inline void SetRegionalConfigurations(const Aws::Vector<RegionalConfiguration>& value) { m_regionalConfigurationsHasBeenSet = true; m_regionalConfigurations = value; }

    /**
     * <p>Describes the replication group IDs, the AWS regions where they are stored
     * and the shard configuration for each that comprise the Global Datastore</p>
     */
    inline void SetRegionalConfigurations(Aws::Vector<RegionalConfiguration>&& value) { m_regionalConfigurationsHasBeenSet = true; m_regionalConfigurations = std::move(value); }

    /**
     * <p>Describes the replication group IDs, the AWS regions where they are stored
     * and the shard configuration for each that comprise the Global Datastore</p>
     */
    inline IncreaseNodeGroupsInGlobalReplicationGroupRequest& WithRegionalConfigurations(const Aws::Vector<RegionalConfiguration>& value) { SetRegionalConfigurations(value); return *this;}

    /**
     * <p>Describes the replication group IDs, the AWS regions where they are stored
     * and the shard configuration for each that comprise the Global Datastore</p>
     */
    inline IncreaseNodeGroupsInGlobalReplicationGroupRequest& WithRegionalConfigurations(Aws::Vector<RegionalConfiguration>&& value) { SetRegionalConfigurations(std::move(value)); return *this;}

    /**
     * <p>Describes the replication group IDs, the AWS regions where they are stored
     * and the shard configuration for each that comprise the Global Datastore</p>
     */
    inline IncreaseNodeGroupsInGlobalReplicationGroupRequest& AddRegionalConfigurations(const RegionalConfiguration& value) { m_regionalConfigurationsHasBeenSet = true; m_regionalConfigurations.push_back(value); return *this; }

    /**
     * <p>Describes the replication group IDs, the AWS regions where they are stored
     * and the shard configuration for each that comprise the Global Datastore</p>
     */
    inline IncreaseNodeGroupsInGlobalReplicationGroupRequest& AddRegionalConfigurations(RegionalConfiguration&& value) { m_regionalConfigurationsHasBeenSet = true; m_regionalConfigurations.push_back(std::move(value)); return *this; }


    /**
     * <p>Indicates that the process begins immediately. At present, the only permitted
     * value for this parameter is true.</p>
     */
    inline bool GetApplyImmediately() const{ return m_applyImmediately; }

    /**
     * <p>Indicates that the process begins immediately. At present, the only permitted
     * value for this parameter is true.</p>
     */
    inline bool ApplyImmediatelyHasBeenSet() const { return m_applyImmediatelyHasBeenSet; }

    /**
     * <p>Indicates that the process begins immediately. At present, the only permitted
     * value for this parameter is true.</p>
     */
    inline void SetApplyImmediately(bool value) { m_applyImmediatelyHasBeenSet = true; m_applyImmediately = value; }

    /**
     * <p>Indicates that the process begins immediately. At present, the only permitted
     * value for this parameter is true.</p>
     */
    inline IncreaseNodeGroupsInGlobalReplicationGroupRequest& WithApplyImmediately(bool value) { SetApplyImmediately(value); return *this;}

  private:

    Aws::String m_globalReplicationGroupId;
    bool m_globalReplicationGroupIdHasBeenSet;

    int m_nodeGroupCount;
    bool m_nodeGroupCountHasBeenSet;

    Aws::Vector<RegionalConfiguration> m_regionalConfigurations;
    bool m_regionalConfigurationsHasBeenSet;

    bool m_applyImmediately;
    bool m_applyImmediatelyHasBeenSet;
  };

} // namespace Model
} // namespace ElastiCache
} // namespace Aws
