/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.interfaces.BT747Path;
import gps.log.in.BT747LogConvert;
import gps.log.in.CSVLogConvert;
import gps.log.in.GPSLogConvertInterface;
import gps.log.in.HoluxTrl2LogConvert;
import gps.log.in.HoluxTrlLogConvert;
import gps.log.in.NMEALogConvert;
import gps.log.in.SkytraqLogConvert;
import gps.log.in.SonyResultConvert;
import gps.log.in.WPLogConvert;

public class GPSInputConversionFactory {
    protected GPSInputConversionFactory next = null;
    protected static GPSInputConversionFactory head = new DefaultGPSOutputFactory(0);

    public static final GPSInputConversionFactory getHandler() {
        return head;
    }

    public GPSLogConvertInterface getInputConversionInstance(BT747Path bT747Path, int n) {
        if (this.next != null) {
            return this.next.getInputConversionInstance(bT747Path, n);
        }
        return null;
    }

    public static final void addHandler(GPSInputConversionFactory gPSInputConversionFactory) {
        gPSInputConversionFactory.next = head;
        head = gPSInputConversionFactory;
    }

    static final class DefaultGPSOutputFactory
    extends GPSInputConversionFactory {
        private DefaultGPSOutputFactory() {
        }

        @Override
        public final GPSLogConvertInterface getInputConversionInstance(BT747Path object, int n) {
            if (((String)(object = ((BT747Path)object).getPath().toLowerCase())).endsWith(".trl")) {
                return new HoluxTrlLogConvert();
            }
            if (((String)object).endsWith(".trl2")) {
                return new HoluxTrl2LogConvert();
            }
            if (((String)object).endsWith(".csv")) {
                return new CSVLogConvert();
            }
            if (((String)object).endsWith(".nmea") || ((String)object).endsWith(".nme") || ((String)object).endsWith(".nma") || ((String)object).endsWith(".txt")) {
                return new NMEALogConvert();
            }
            if (((String)object).endsWith(".log")) {
                if (n == 6) {
                    return new SkytraqLogConvert();
                }
                return new NMEALogConvert();
            }
            if (((String)object).endsWith(".sr")) {
                return new WPLogConvert();
            }
            if (((String)object).endsWith(".result")) {
                return new SonyResultConvert();
            }
            if (n == 6) {
                return new SkytraqLogConvert();
            }
            return new BT747LogConvert();
        }

        /* synthetic */ DefaultGPSOutputFactory(byte by) {
            this();
        }
    }
}

