"use strict";
/// <reference path="../../../typings/main.d.ts" />
Object.defineProperty(exports, "__esModule", { value: true });
var HttpResponse = require('http-response-object');
var lru = require("lrucache");
var globalCache = lru(50);
function hasAsyncRequests() {
    return Object.keys(notifies).length > 0;
}
exports.hasAsyncRequests = hasAsyncRequests;
function addLoadCallback(listener) {
    nlisteners.push(listener);
}
exports.addLoadCallback = addLoadCallback;
var nlisteners = [];
var notifies = {};
function addNotify(url) {
    notifies[url] = true;
}
exports.addNotify = addNotify;
function removeNotity(url) {
    delete notifies[url];
    nlisteners.forEach(function (x) { return x(url); });
}
exports.removeNotity = removeNotity;
function isWaitingFor(url) {
    return notifies[url] ? true : false;
}
exports.isWaitingFor = isWaitingFor;
function set(url, content) {
    globalCache.set(url, content);
}
exports.set = set;
function get(url) {
    return globalCache.get(url);
}
exports.get = get;
//# sourceMappingURL=resourceRegistry.js.map