/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.TypeArguments;

final class DependencyVerifier
extends DefaultBindingTargetVisitor<Object, Boolean> {
    DependencyVerifier() {
    }

    @Override
    public Boolean visit(UntargettedBinding<?> binding2) {
        return DependencyVerifier.verifyImplementation(binding2.getKey().getTypeLiteral());
    }

    @Override
    public Boolean visit(LinkedKeyBinding<?> binding2) {
        Key<?> linkedKey = binding2.getLinkedKey();
        if (linkedKey.getAnnotationType() == null) {
            return DependencyVerifier.verifyImplementation(linkedKey.getTypeLiteral());
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitOther(Binding<?> binding2) {
        return Boolean.TRUE;
    }

    private static Boolean verifyImplementation(TypeLiteral<?> type2) {
        if (TypeArguments.isConcrete(type2) && !type2.toString().startsWith("java")) {
            try {
                InjectionPoint.forInstanceMethodsAndFields(type2);
                InjectionPoint.forConstructorOf(type2);
            }
            catch (RuntimeException e2) {
                Logs.trace("Potential problem: {}", type2, e2);
                return Boolean.FALSE;
            }
            catch (LinkageError e3) {
                Logs.trace("Potential problem: {}", type2, e3);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }
}

