/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.time.ZonedDateTime;
import java.util.Objects;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.Utility;
import org.elasticsearch.painless.lookup.PainlessCast;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.script.JodaCompatibleZonedDateTime;

public final class AnalyzerCaster {
    public static PainlessCast getLegalCast(Location location, Class<?> actual, Class<?> expected, boolean explicit, boolean internal) {
        Objects.requireNonNull(actual);
        Objects.requireNonNull(expected);
        if (actual == expected) {
            return null;
        }
        if (actual == def.class) {
            if (expected == Boolean.TYPE) {
                return PainlessCast.originalTypetoTargetType(def.class, Boolean.TYPE, explicit);
            }
            if (expected == Byte.TYPE) {
                return PainlessCast.originalTypetoTargetType(def.class, Byte.TYPE, explicit);
            }
            if (expected == Short.TYPE) {
                return PainlessCast.originalTypetoTargetType(def.class, Short.TYPE, explicit);
            }
            if (expected == Character.TYPE) {
                return PainlessCast.originalTypetoTargetType(def.class, Character.TYPE, explicit);
            }
            if (expected == Integer.TYPE) {
                return PainlessCast.originalTypetoTargetType(def.class, Integer.TYPE, explicit);
            }
            if (expected == Long.TYPE) {
                return PainlessCast.originalTypetoTargetType(def.class, Long.TYPE, explicit);
            }
            if (expected == Float.TYPE) {
                return PainlessCast.originalTypetoTargetType(def.class, Float.TYPE, explicit);
            }
            if (expected == Double.TYPE) {
                return PainlessCast.originalTypetoTargetType(def.class, Double.TYPE, explicit);
            }
            if (expected == Boolean.class) {
                return PainlessCast.originalTypetoTargetType(def.class, Boolean.class, explicit);
            }
            if (expected == Byte.class) {
                return PainlessCast.originalTypetoTargetType(def.class, Byte.class, explicit);
            }
            if (expected == Short.class) {
                return PainlessCast.originalTypetoTargetType(def.class, Short.class, explicit);
            }
            if (expected == Character.class) {
                return PainlessCast.originalTypetoTargetType(def.class, Character.class, explicit);
            }
            if (expected == Integer.class) {
                return PainlessCast.originalTypetoTargetType(def.class, Integer.class, explicit);
            }
            if (expected == Long.class) {
                return PainlessCast.originalTypetoTargetType(def.class, Long.class, explicit);
            }
            if (expected == Float.class) {
                return PainlessCast.originalTypetoTargetType(def.class, Float.class, explicit);
            }
            if (expected == Double.class) {
                return PainlessCast.originalTypetoTargetType(def.class, Double.class, explicit);
            }
            if (expected == ZonedDateTime.class) {
                return PainlessCast.originalTypetoTargetType(def.class, ZonedDateTime.class, explicit);
            }
        } else if (actual == String.class) {
            if (expected == Character.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(String.class, Character.TYPE, true);
            }
        } else if (actual == JodaCompatibleZonedDateTime.class) {
            if (expected == ZonedDateTime.class) {
                return PainlessCast.originalTypetoTargetType(JodaCompatibleZonedDateTime.class, ZonedDateTime.class, explicit);
            }
        } else if (actual == Boolean.TYPE) {
            if (expected == def.class) {
                return PainlessCast.boxOriginalType(Boolean.class, def.class, explicit, Boolean.TYPE);
            }
            if (expected == Object.class && internal) {
                return PainlessCast.boxOriginalType(Boolean.class, Object.class, explicit, Boolean.TYPE);
            }
            if (expected == Boolean.class && internal) {
                return PainlessCast.boxTargetType(Boolean.TYPE, Boolean.TYPE, explicit, Boolean.TYPE);
            }
        } else if (actual == Byte.TYPE) {
            if (expected == def.class) {
                return PainlessCast.boxOriginalType(Byte.class, def.class, explicit, Byte.TYPE);
            }
            if (expected == Object.class && internal) {
                return PainlessCast.boxOriginalType(Byte.class, Object.class, explicit, Byte.TYPE);
            }
            if (expected == Number.class && internal) {
                return PainlessCast.boxOriginalType(Byte.class, Number.class, explicit, Byte.TYPE);
            }
            if (expected == Short.TYPE) {
                return PainlessCast.originalTypetoTargetType(Byte.TYPE, Short.TYPE, explicit);
            }
            if (expected == Character.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Byte.TYPE, Character.TYPE, true);
            }
            if (expected == Integer.TYPE) {
                return PainlessCast.originalTypetoTargetType(Byte.TYPE, Integer.TYPE, explicit);
            }
            if (expected == Long.TYPE) {
                return PainlessCast.originalTypetoTargetType(Byte.TYPE, Long.TYPE, explicit);
            }
            if (expected == Float.TYPE) {
                return PainlessCast.originalTypetoTargetType(Byte.TYPE, Float.TYPE, explicit);
            }
            if (expected == Double.TYPE) {
                return PainlessCast.originalTypetoTargetType(Byte.TYPE, Double.TYPE, explicit);
            }
            if (expected == Byte.class && internal) {
                return PainlessCast.boxTargetType(Byte.TYPE, Byte.TYPE, explicit, Byte.TYPE);
            }
            if (expected == Short.class && internal) {
                return PainlessCast.boxTargetType(Byte.TYPE, Short.TYPE, explicit, Short.TYPE);
            }
            if (expected == Integer.class && internal) {
                return PainlessCast.boxTargetType(Byte.TYPE, Integer.TYPE, explicit, Integer.TYPE);
            }
            if (expected == Long.class && internal) {
                return PainlessCast.boxTargetType(Byte.TYPE, Long.TYPE, explicit, Long.TYPE);
            }
            if (expected == Float.class && internal) {
                return PainlessCast.boxTargetType(Byte.TYPE, Float.TYPE, explicit, Float.TYPE);
            }
            if (expected == Double.class && internal) {
                return PainlessCast.boxTargetType(Byte.TYPE, Double.TYPE, explicit, Double.TYPE);
            }
        } else if (actual == Short.TYPE) {
            if (expected == def.class) {
                return PainlessCast.boxOriginalType(Short.class, def.class, explicit, Short.TYPE);
            }
            if (expected == Object.class && internal) {
                return PainlessCast.boxOriginalType(Short.class, Object.class, explicit, Short.TYPE);
            }
            if (expected == Number.class && internal) {
                return PainlessCast.boxOriginalType(Short.class, Number.class, explicit, Short.TYPE);
            }
            if (expected == Byte.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Short.TYPE, Byte.TYPE, true);
            }
            if (expected == Character.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Short.TYPE, Character.TYPE, true);
            }
            if (expected == Integer.TYPE) {
                return PainlessCast.originalTypetoTargetType(Short.TYPE, Integer.TYPE, explicit);
            }
            if (expected == Long.TYPE) {
                return PainlessCast.originalTypetoTargetType(Short.TYPE, Long.TYPE, explicit);
            }
            if (expected == Float.TYPE) {
                return PainlessCast.originalTypetoTargetType(Short.TYPE, Float.TYPE, explicit);
            }
            if (expected == Double.TYPE) {
                return PainlessCast.originalTypetoTargetType(Short.TYPE, Double.TYPE, explicit);
            }
            if (expected == Short.class && internal) {
                return PainlessCast.boxTargetType(Short.TYPE, Short.TYPE, explicit, Short.TYPE);
            }
            if (expected == Integer.class && internal) {
                return PainlessCast.boxTargetType(Short.TYPE, Integer.TYPE, explicit, Integer.TYPE);
            }
            if (expected == Long.class && internal) {
                return PainlessCast.boxTargetType(Short.TYPE, Long.TYPE, explicit, Long.TYPE);
            }
            if (expected == Float.class && internal) {
                return PainlessCast.boxTargetType(Short.TYPE, Float.TYPE, explicit, Float.TYPE);
            }
            if (expected == Double.class && internal) {
                return PainlessCast.boxTargetType(Short.TYPE, Double.TYPE, explicit, Double.TYPE);
            }
        } else if (actual == Character.TYPE) {
            if (expected == def.class) {
                return PainlessCast.boxOriginalType(Character.class, def.class, explicit, Character.TYPE);
            }
            if (expected == Object.class && internal) {
                return PainlessCast.boxOriginalType(Character.class, Object.class, explicit, Character.TYPE);
            }
            if (expected == Number.class && internal) {
                return PainlessCast.boxOriginalType(Character.class, Number.class, explicit, Character.TYPE);
            }
            if (expected == String.class && explicit) {
                return PainlessCast.originalTypetoTargetType(Character.TYPE, String.class, true);
            }
            if (expected == Byte.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Character.TYPE, Byte.TYPE, true);
            }
            if (expected == Short.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Character.TYPE, Short.TYPE, true);
            }
            if (expected == Integer.TYPE) {
                return PainlessCast.originalTypetoTargetType(Character.TYPE, Integer.TYPE, explicit);
            }
            if (expected == Long.TYPE) {
                return PainlessCast.originalTypetoTargetType(Character.TYPE, Long.TYPE, explicit);
            }
            if (expected == Float.TYPE) {
                return PainlessCast.originalTypetoTargetType(Character.TYPE, Float.TYPE, explicit);
            }
            if (expected == Double.TYPE) {
                return PainlessCast.originalTypetoTargetType(Character.TYPE, Double.TYPE, explicit);
            }
            if (expected == Character.class && internal) {
                return PainlessCast.boxTargetType(Character.TYPE, Character.TYPE, true, Character.TYPE);
            }
            if (expected == Integer.class && internal) {
                return PainlessCast.boxTargetType(Character.TYPE, Integer.TYPE, explicit, Integer.TYPE);
            }
            if (expected == Long.class && internal) {
                return PainlessCast.boxTargetType(Character.TYPE, Long.TYPE, explicit, Long.TYPE);
            }
            if (expected == Float.class && internal) {
                return PainlessCast.boxTargetType(Character.TYPE, Float.TYPE, explicit, Float.TYPE);
            }
            if (expected == Double.class && internal) {
                return PainlessCast.boxTargetType(Character.TYPE, Double.TYPE, explicit, Double.TYPE);
            }
        } else if (actual == Integer.TYPE) {
            if (expected == def.class) {
                return PainlessCast.boxOriginalType(Integer.class, def.class, explicit, Integer.TYPE);
            }
            if (expected == Object.class && internal) {
                return PainlessCast.boxOriginalType(Integer.class, Object.class, explicit, Integer.TYPE);
            }
            if (expected == Number.class && internal) {
                return PainlessCast.boxOriginalType(Integer.class, Number.class, explicit, Integer.TYPE);
            }
            if (expected == Byte.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Integer.TYPE, Byte.TYPE, true);
            }
            if (expected == Character.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Integer.TYPE, Character.TYPE, true);
            }
            if (expected == Short.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Integer.TYPE, Short.TYPE, true);
            }
            if (expected == Long.TYPE) {
                return PainlessCast.originalTypetoTargetType(Integer.TYPE, Long.TYPE, explicit);
            }
            if (expected == Float.TYPE) {
                return PainlessCast.originalTypetoTargetType(Integer.TYPE, Float.TYPE, explicit);
            }
            if (expected == Double.TYPE) {
                return PainlessCast.originalTypetoTargetType(Integer.TYPE, Double.TYPE, explicit);
            }
            if (expected == Integer.class && internal) {
                return PainlessCast.boxTargetType(Integer.TYPE, Integer.TYPE, explicit, Integer.TYPE);
            }
            if (expected == Long.class && internal) {
                return PainlessCast.boxTargetType(Integer.TYPE, Long.TYPE, explicit, Long.TYPE);
            }
            if (expected == Float.class && internal) {
                return PainlessCast.boxTargetType(Integer.TYPE, Float.TYPE, explicit, Float.TYPE);
            }
            if (expected == Double.class && internal) {
                return PainlessCast.boxTargetType(Integer.TYPE, Double.TYPE, explicit, Double.TYPE);
            }
        } else if (actual == Long.TYPE) {
            if (expected == def.class) {
                return PainlessCast.boxOriginalType(Long.class, def.class, explicit, Long.TYPE);
            }
            if (expected == Object.class && internal) {
                return PainlessCast.boxOriginalType(Long.class, Object.class, explicit, Long.TYPE);
            }
            if (expected == Number.class && internal) {
                return PainlessCast.boxOriginalType(Long.class, Number.class, explicit, Long.TYPE);
            }
            if (expected == Byte.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Long.TYPE, Byte.TYPE, true);
            }
            if (expected == Character.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Long.TYPE, Character.TYPE, true);
            }
            if (expected == Short.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Long.TYPE, Short.TYPE, true);
            }
            if (expected == Integer.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Long.TYPE, Integer.TYPE, true);
            }
            if (expected == Float.TYPE) {
                return PainlessCast.originalTypetoTargetType(Long.TYPE, Float.TYPE, explicit);
            }
            if (expected == Double.TYPE) {
                return PainlessCast.originalTypetoTargetType(Long.TYPE, Double.TYPE, explicit);
            }
            if (expected == Long.class && internal) {
                return PainlessCast.boxTargetType(Long.TYPE, Long.TYPE, explicit, Long.TYPE);
            }
            if (expected == Float.class && internal) {
                return PainlessCast.boxTargetType(Long.TYPE, Float.TYPE, explicit, Float.TYPE);
            }
            if (expected == Double.class && internal) {
                return PainlessCast.boxTargetType(Long.TYPE, Double.TYPE, explicit, Double.TYPE);
            }
        } else if (actual == Float.TYPE) {
            if (expected == def.class) {
                return PainlessCast.boxOriginalType(Float.class, def.class, explicit, Float.TYPE);
            }
            if (expected == Object.class && internal) {
                return PainlessCast.boxOriginalType(Float.class, Object.class, explicit, Float.TYPE);
            }
            if (expected == Number.class && internal) {
                return PainlessCast.boxOriginalType(Float.class, Number.class, explicit, Float.TYPE);
            }
            if (expected == Byte.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Float.TYPE, Byte.TYPE, true);
            }
            if (expected == Character.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Float.TYPE, Character.TYPE, true);
            }
            if (expected == Short.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Float.TYPE, Short.TYPE, true);
            }
            if (expected == Integer.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Float.TYPE, Integer.TYPE, true);
            }
            if (expected == Long.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Float.TYPE, Long.TYPE, true);
            }
            if (expected == Double.TYPE) {
                return PainlessCast.originalTypetoTargetType(Float.TYPE, Double.TYPE, explicit);
            }
            if (expected == Float.class && internal) {
                return PainlessCast.boxTargetType(Float.TYPE, Float.TYPE, explicit, Float.TYPE);
            }
            if (expected == Double.class && internal) {
                return PainlessCast.boxTargetType(Float.TYPE, Double.TYPE, explicit, Double.TYPE);
            }
        } else if (actual == Double.TYPE) {
            if (expected == def.class) {
                return PainlessCast.boxOriginalType(Double.class, def.class, explicit, Double.TYPE);
            }
            if (expected == Object.class && internal) {
                return PainlessCast.boxOriginalType(Double.class, Object.class, explicit, Double.TYPE);
            }
            if (expected == Number.class && internal) {
                return PainlessCast.boxOriginalType(Double.class, Number.class, explicit, Double.TYPE);
            }
            if (expected == Byte.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Double.TYPE, Byte.TYPE, true);
            }
            if (expected == Character.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Double.TYPE, Character.TYPE, true);
            }
            if (expected == Short.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Double.TYPE, Short.TYPE, true);
            }
            if (expected == Integer.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Double.TYPE, Integer.TYPE, true);
            }
            if (expected == Long.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Double.TYPE, Long.TYPE, true);
            }
            if (expected == Float.TYPE && explicit) {
                return PainlessCast.originalTypetoTargetType(Double.TYPE, Float.TYPE, true);
            }
            if (expected == Double.class && internal) {
                return PainlessCast.boxTargetType(Double.TYPE, Double.TYPE, explicit, Double.TYPE);
            }
        } else if (actual == Boolean.class) {
            if (expected == Boolean.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Boolean.TYPE, Boolean.TYPE, explicit, Boolean.TYPE);
            }
        } else if (actual == Byte.class) {
            if (expected == Byte.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Byte.TYPE, Byte.TYPE, explicit, Byte.TYPE);
            }
            if (expected == Short.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Byte.TYPE, Short.TYPE, explicit, Byte.TYPE);
            }
            if (expected == Integer.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Byte.TYPE, Integer.TYPE, explicit, Byte.TYPE);
            }
            if (expected == Long.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Byte.TYPE, Long.TYPE, explicit, Byte.TYPE);
            }
            if (expected == Float.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Byte.TYPE, Float.TYPE, explicit, Byte.TYPE);
            }
            if (expected == Double.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Byte.TYPE, Double.TYPE, explicit, Byte.TYPE);
            }
            if (expected == Short.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Byte.TYPE, Short.TYPE);
            }
            if (expected == Integer.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Byte.TYPE, Integer.TYPE);
            }
            if (expected == Long.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Byte.TYPE, Long.TYPE);
            }
            if (expected == Float.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Byte.TYPE, Float.TYPE);
            }
            if (expected == Double.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Byte.TYPE, Double.TYPE);
            }
        } else if (actual == Short.class) {
            if (expected == Short.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Short.TYPE, Short.TYPE, explicit, Short.TYPE);
            }
            if (expected == Integer.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Short.TYPE, Integer.TYPE, explicit, Short.TYPE);
            }
            if (expected == Long.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Short.TYPE, Long.TYPE, explicit, Short.TYPE);
            }
            if (expected == Float.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Short.TYPE, Float.TYPE, explicit, Short.TYPE);
            }
            if (expected == Double.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Short.TYPE, Double.TYPE, explicit, Short.TYPE);
            }
            if (expected == Integer.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Short.TYPE, Integer.TYPE);
            }
            if (expected == Long.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Short.TYPE, Long.TYPE);
            }
            if (expected == Float.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Short.TYPE, Float.TYPE);
            }
            if (expected == Double.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Short.TYPE, Double.TYPE);
            }
        } else if (actual == Character.class) {
            if (expected == Character.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Character.TYPE, Character.TYPE, explicit, Character.TYPE);
            }
            if (expected == Integer.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Character.TYPE, Integer.TYPE, explicit, Character.TYPE);
            }
            if (expected == Long.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Character.TYPE, Long.TYPE, explicit, Character.TYPE);
            }
            if (expected == Float.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Character.TYPE, Float.TYPE, explicit, Character.TYPE);
            }
            if (expected == Double.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Character.TYPE, Double.TYPE, explicit, Character.TYPE);
            }
            if (expected == Integer.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Character.TYPE, Integer.TYPE);
            }
            if (expected == Long.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Character.TYPE, Long.TYPE);
            }
            if (expected == Float.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Character.TYPE, Float.TYPE);
            }
            if (expected == Double.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Character.TYPE, Double.TYPE);
            }
        } else if (actual == Integer.class) {
            if (expected == Integer.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Integer.TYPE, Integer.TYPE, explicit, Integer.TYPE);
            }
            if (expected == Long.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Integer.TYPE, Long.TYPE, explicit, Integer.TYPE);
            }
            if (expected == Float.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Integer.TYPE, Float.TYPE, explicit, Integer.TYPE);
            }
            if (expected == Double.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Integer.TYPE, Double.TYPE, explicit, Integer.TYPE);
            }
            if (expected == Long.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Integer.TYPE, Long.TYPE);
            }
            if (expected == Float.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Integer.TYPE, Float.TYPE);
            }
            if (expected == Double.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Integer.TYPE, Double.TYPE);
            }
        } else if (actual == Long.class) {
            if (expected == Long.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Long.TYPE, Long.TYPE, explicit, Long.TYPE);
            }
            if (expected == Float.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Long.TYPE, Float.TYPE, explicit, Long.TYPE);
            }
            if (expected == Double.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Long.TYPE, Double.TYPE, explicit, Long.TYPE);
            }
            if (expected == Float.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Long.TYPE, Float.TYPE);
            }
            if (expected == Double.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Long.TYPE, Double.TYPE);
            }
        } else if (actual == Float.class) {
            if (expected == Float.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Float.TYPE, Float.TYPE, explicit, Float.TYPE);
            }
            if (expected == Double.TYPE && internal) {
                return PainlessCast.unboxOriginalType(Float.TYPE, Double.TYPE, explicit, Float.TYPE);
            }
            if (expected == Double.class && internal) {
                return PainlessCast.unboxOriginalTypeToBoxTargetType(explicit, Float.TYPE, Double.TYPE);
            }
        } else if (actual == Double.class && expected == Double.TYPE && internal) {
            return PainlessCast.unboxOriginalType(Double.TYPE, Double.TYPE, explicit, Double.TYPE);
        }
        if (actual == def.class || actual != Void.TYPE && expected == def.class || expected.isAssignableFrom(actual) || actual.isAssignableFrom(expected) && explicit) {
            return PainlessCast.originalTypetoTargetType(actual, expected, explicit);
        }
        throw location.createError(new ClassCastException("Cannot cast from [" + PainlessLookupUtility.typeToCanonicalTypeName(actual) + "] to [" + PainlessLookupUtility.typeToCanonicalTypeName(expected) + "]."));
    }

    public static Object constCast(Location location, Object constant, PainlessCast cast) {
        Class<?> fsort = cast.originalType;
        Class<?> tsort = cast.targetType;
        if (fsort == tsort) {
            return constant;
        }
        if (fsort == String.class && tsort == Character.TYPE) {
            return Character.valueOf(Utility.StringTochar((String)constant));
        }
        if (fsort == Character.TYPE && tsort == String.class) {
            return Utility.charToString(((Character)constant).charValue());
        }
        if (fsort.isPrimitive() && fsort != Boolean.TYPE && tsort.isPrimitive() && tsort != Boolean.TYPE) {
            Number number = fsort == Character.TYPE ? (Number)Integer.valueOf(((Character)constant).charValue()) : (Number)((Number)constant);
            if (tsort == Byte.TYPE) {
                return number.byteValue();
            }
            if (tsort == Short.TYPE) {
                return number.shortValue();
            }
            if (tsort == Character.TYPE) {
                return Character.valueOf((char)number.intValue());
            }
            if (tsort == Integer.TYPE) {
                return number.intValue();
            }
            if (tsort == Long.TYPE) {
                return number.longValue();
            }
            if (tsort == Float.TYPE) {
                return Float.valueOf(number.floatValue());
            }
            if (tsort == Double.TYPE) {
                return number.doubleValue();
            }
            throw location.createError(new IllegalStateException("Cannot cast from [" + cast.originalType.getCanonicalName() + "] to [" + cast.targetType.getCanonicalName() + "]."));
        }
        throw location.createError(new IllegalStateException("Cannot cast from [" + cast.originalType.getCanonicalName() + "] to [" + cast.targetType.getCanonicalName() + "]."));
    }

    public static Class<?> promoteNumeric(Class<?> from, boolean decimal) {
        if (from == def.class || from == Double.TYPE && decimal || from == Float.TYPE && decimal || from == Long.TYPE) {
            return from;
        }
        if (from == Integer.TYPE || from == Character.TYPE || from == Short.TYPE || from == Byte.TYPE) {
            return Integer.TYPE;
        }
        return null;
    }

    public static Class<?> promoteNumeric(Class<?> from0, Class<?> from1, boolean decimal) {
        if (from0 == def.class || from1 == def.class) {
            return def.class;
        }
        if (decimal) {
            if (from0 == Double.TYPE || from1 == Double.TYPE) {
                return Double.TYPE;
            }
            if (from0 == Float.TYPE || from1 == Float.TYPE) {
                return Float.TYPE;
            }
        }
        if (from0 == Long.TYPE || from1 == Long.TYPE) {
            return Long.TYPE;
        }
        if (from0 == Integer.TYPE || from1 == Integer.TYPE || from0 == Character.TYPE || from1 == Character.TYPE || from0 == Short.TYPE || from1 == Short.TYPE || from0 == Byte.TYPE || from1 == Byte.TYPE) {
            return Integer.TYPE;
        }
        return null;
    }

    public static Class<?> promoteAdd(Class<?> from0, Class<?> from1) {
        if (from0 == String.class || from1 == String.class) {
            return String.class;
        }
        return AnalyzerCaster.promoteNumeric(from0, from1, true);
    }

    public static Class<?> promoteXor(Class<?> from0, Class<?> from1) {
        if (from0 == def.class || from1 == def.class) {
            return def.class;
        }
        if (from0 == Boolean.TYPE || from1 == Boolean.TYPE) {
            return Boolean.TYPE;
        }
        return AnalyzerCaster.promoteNumeric(from0, from1, false);
    }

    public static Class<?> promoteEquality(Class<?> from0, Class<?> from1) {
        if (from0 == def.class || from1 == def.class) {
            return def.class;
        }
        if (from0.isPrimitive() && from1.isPrimitive()) {
            if (from0 == Boolean.TYPE && from1 == Boolean.TYPE) {
                return Boolean.TYPE;
            }
            return AnalyzerCaster.promoteNumeric(from0, from1, true);
        }
        return Object.class;
    }

    public static Class<?> promoteConditional(Class<?> from0, Class<?> from1, Object const0, Object const1) {
        if (from0 == from1) {
            return from0;
        }
        if (from0 == def.class || from1 == def.class) {
            return def.class;
        }
        if (from0.isPrimitive() && from1.isPrimitive()) {
            if (from0 == Boolean.TYPE && from1 == Boolean.TYPE) {
                return Boolean.TYPE;
            }
            if (from0 == Double.TYPE || from1 == Double.TYPE) {
                return Double.TYPE;
            }
            if (from0 == Float.TYPE || from1 == Float.TYPE) {
                return Float.TYPE;
            }
            if (from0 == Long.TYPE || from1 == Long.TYPE) {
                return Long.TYPE;
            }
            if (from0 == Byte.TYPE) {
                if (from1 == Byte.TYPE) {
                    return Byte.TYPE;
                }
                if (from1 == Short.TYPE) {
                    short constant;
                    if (const1 != null && (constant = ((Short)const1).shortValue()) <= 127 && constant >= -128) {
                        return Byte.TYPE;
                    }
                    return Short.TYPE;
                }
                if (from1 == Character.TYPE) {
                    return Integer.TYPE;
                }
                if (from1 == Integer.TYPE) {
                    int constant;
                    if (const1 != null && (constant = ((Integer)const1).intValue()) <= 127 && constant >= -128) {
                        return Byte.TYPE;
                    }
                    return Integer.TYPE;
                }
            } else if (from0 == Short.TYPE) {
                if (from1 == Byte.TYPE) {
                    short constant;
                    if (const0 != null && (constant = ((Short)const0).shortValue()) <= 127 && constant >= -128) {
                        return Byte.TYPE;
                    }
                    return Short.TYPE;
                }
                if (from1 == Short.TYPE) {
                    return Short.TYPE;
                }
                if (from1 == Character.TYPE) {
                    return Integer.TYPE;
                }
                if (from1 == Integer.TYPE) {
                    int constant;
                    if (const1 != null && (constant = ((Integer)const1).intValue()) <= Short.MAX_VALUE && constant >= Short.MIN_VALUE) {
                        return Short.TYPE;
                    }
                    return Integer.TYPE;
                }
            } else if (from0 == Character.TYPE) {
                if (from1 == Byte.TYPE) {
                    return Integer.TYPE;
                }
                if (from1 == Short.TYPE) {
                    return Integer.TYPE;
                }
                if (from1 == Character.TYPE) {
                    return Character.TYPE;
                }
                if (from1 == Integer.TYPE) {
                    int constant;
                    if (const1 != null && (constant = ((Integer)const1).intValue()) <= 65535 && constant >= 0) {
                        return Byte.TYPE;
                    }
                    return Integer.TYPE;
                }
            } else if (from0 == Integer.TYPE) {
                if (from1 == Byte.TYPE) {
                    int constant;
                    if (const0 != null && (constant = ((Integer)const0).intValue()) <= 127 && constant >= -128) {
                        return Byte.TYPE;
                    }
                    return Integer.TYPE;
                }
                if (from1 == Short.TYPE) {
                    int constant;
                    if (const0 != null && (constant = ((Integer)const0).intValue()) <= Short.MAX_VALUE && constant >= Short.MIN_VALUE) {
                        return Byte.TYPE;
                    }
                    return Integer.TYPE;
                }
                if (from1 == Character.TYPE) {
                    int constant;
                    if (const0 != null && (constant = ((Integer)const0).intValue()) <= 65535 && constant >= 0) {
                        return Byte.TYPE;
                    }
                    return Integer.TYPE;
                }
                if (from1 == Integer.TYPE) {
                    return Integer.TYPE;
                }
            }
        }
        return Object.class;
    }

    private AnalyzerCaster() {
    }
}

