/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.painless.lookup.PainlessClass;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;

public class PainlessExplainError
extends Error {
    private final Object objectToExplain;

    public PainlessExplainError(Object objectToExplain) {
        this.objectToExplain = objectToExplain;
    }

    Object getObjectToExplain() {
        return this.objectToExplain;
    }

    public Map<String, List<String>> getHeaders(PainlessLookup painlessLookup) {
        TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>();
        String toString = "null";
        String javaClassName = null;
        String painlessClassName = null;
        if (this.objectToExplain != null) {
            toString = this.objectToExplain.toString();
            javaClassName = this.objectToExplain.getClass().getName();
            PainlessClass struct = painlessLookup.lookupPainlessClass(this.objectToExplain.getClass());
            if (struct != null) {
                painlessClassName = PainlessLookupUtility.typeToCanonicalTypeName(this.objectToExplain.getClass());
            }
        }
        headers.put("es.to_string", Collections.singletonList(toString));
        if (painlessClassName != null) {
            headers.put("es.painless_class", Collections.singletonList(painlessClassName));
        }
        if (javaClassName != null) {
            headers.put("es.java_class", Collections.singletonList(javaClassName));
        }
        return headers;
    }
}

