/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.RootObjectMapper;

public final class Mapping
implements ToXContentFragment {
    final Version indexCreated;
    final RootObjectMapper root;
    final MetadataFieldMapper[] metadataMappers;
    final Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappersMap;
    final Map<String, Object> meta;

    public Mapping(Version indexCreated, RootObjectMapper rootObjectMapper, MetadataFieldMapper[] metadataMappers, Map<String, Object> meta) {
        this.indexCreated = indexCreated;
        this.metadataMappers = metadataMappers;
        HashMap metadataMappersMap = new HashMap();
        for (MetadataFieldMapper metadataMapper : metadataMappers) {
            metadataMappersMap.put(metadataMapper.getClass(), metadataMapper);
        }
        this.root = rootObjectMapper;
        Arrays.sort(metadataMappers, new Comparator<Mapper>(){

            @Override
            public int compare(Mapper o1, Mapper o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        this.metadataMappersMap = Collections.unmodifiableMap(metadataMappersMap);
        this.meta = meta;
    }

    public RootObjectMapper root() {
        return this.root;
    }

    public Mapping mappingUpdate(Mapper rootObjectMapper) {
        return new Mapping(this.indexCreated, (RootObjectMapper)rootObjectMapper, this.metadataMappers, this.meta);
    }

    public <T extends MetadataFieldMapper> T metadataMapper(Class<T> clazz) {
        return (T)this.metadataMappersMap.get(clazz);
    }

    public Mapping merge(Mapping mergeWith) {
        RootObjectMapper mergedRoot = this.root.merge(mergeWith.root);
        HashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> mergedMetaDataMappers = new HashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>(this.metadataMappersMap);
        for (MetadataFieldMapper metaMergeWith : mergeWith.metadataMappers) {
            MetadataFieldMapper mergeInto = (MetadataFieldMapper)mergedMetaDataMappers.get(metaMergeWith.getClass());
            MetadataFieldMapper merged = mergeInto == null ? metaMergeWith : mergeInto.merge(metaMergeWith);
            mergedMetaDataMappers.put(merged.getClass(), merged);
        }
        Map<String, Object> mergedMeta = mergeWith.meta == null ? this.meta : mergeWith.meta;
        return new Mapping(this.indexCreated, mergedRoot, mergedMetaDataMappers.values().toArray(new MetadataFieldMapper[0]), mergedMeta);
    }

    public Mapping updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        MetadataFieldMapper[] updatedMeta = null;
        for (int i = 0; i < this.metadataMappers.length; ++i) {
            MetadataFieldMapper currentFieldMapper = this.metadataMappers[i];
            MetadataFieldMapper updatedFieldMapper = (MetadataFieldMapper)currentFieldMapper.updateFieldType((Map)fullNameToFieldType);
            if (updatedFieldMapper == currentFieldMapper) continue;
            if (updatedMeta == null) {
                updatedMeta = Arrays.copyOf(this.metadataMappers, this.metadataMappers.length);
            }
            updatedMeta[i] = updatedFieldMapper;
        }
        ObjectMapper updatedRoot = this.root.updateFieldType((Map)fullNameToFieldType);
        if (updatedMeta == null && updatedRoot == this.root) {
            return this;
        }
        return new Mapping(this.indexCreated, (RootObjectMapper)updatedRoot, updatedMeta == null ? this.metadataMappers : updatedMeta, this.meta);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.root.toXContent(builder, params, new ToXContent(){

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                if (Mapping.this.meta != null) {
                    builder.field("_meta", Mapping.this.meta);
                }
                for (MetadataFieldMapper mapper : Mapping.this.metadataMappers) {
                    mapper.toXContent(builder, params);
                }
                return builder;
            }
        });
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            this.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.emptyMap()));
            return Strings.toString(builder.endObject());
        }
        catch (IOException bogus) {
            throw new UncheckedIOException(bogus);
        }
    }
}

