/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.query.QueryShardContext;

public class RoutingFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_routing";
    public static final String CONTENT_TYPE = "_routing";
    private boolean required;

    private RoutingFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(existing.clone(), false, indexSettings);
    }

    private RoutingFieldMapper(MappedFieldType fieldType, boolean required, Settings indexSettings) {
        super("_routing", fieldType, Defaults.FIELD_TYPE, indexSettings);
        this.required = required;
    }

    public void markAsRequired() {
        this.required = true;
    }

    public boolean required() {
        return this.required;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        String routing = context.sourceToParse().routing();
        if (routing != null && (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored())) {
            fields.add((IndexableField)new Field(this.fieldType().name(), (CharSequence)routing, (IndexableFieldType)this.fieldType()));
            this.createFieldNamesField(context, fields);
        }
    }

    @Override
    protected String contentType() {
        return "_routing";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && !this.required) {
            return builder;
        }
        builder.startObject("_routing");
        if (includeDefaults || this.required) {
            builder.field("required", this.required);
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
    }

    public static class Defaults {
        public static final String NAME = "_routing";
        public static final MappedFieldType FIELD_TYPE = new RoutingFieldType();
        public static final boolean REQUIRED = false;

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setName("_routing");
            FIELD_TYPE.freeze();
        }
    }

    static final class RoutingFieldType
    extends StringFieldType {
        RoutingFieldType() {
        }

        protected RoutingFieldType(RoutingFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new RoutingFieldType(this);
        }

        @Override
        public String typeName() {
            return "_routing";
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new TermQuery(new Term("_field_names", this.name()));
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(parserContext.mapperService().fieldType("_routing"));
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("required")) continue;
                builder.required(XContentMapValues.nodeBooleanValue(fieldNode, name + ".required"));
                iterator.remove();
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            if (fieldType != null) {
                return new RoutingFieldMapper(indexSettings, fieldType);
            }
            return (MetadataFieldMapper)this.parse("_routing", Collections.emptyMap(), context).build(new Mapper.BuilderContext(indexSettings, new ContentPath(1)));
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, RoutingFieldMapper> {
        private boolean required = false;

        public Builder(MappedFieldType existing) {
            super("_routing", existing == null ? Defaults.FIELD_TYPE : existing, Defaults.FIELD_TYPE);
        }

        public Builder required(boolean required) {
            this.required = required;
            return (Builder)this.builder;
        }

        @Override
        public RoutingFieldMapper build(Mapper.BuilderContext context) {
            return new RoutingFieldMapper(this.fieldType, this.required, context.indexSettings());
        }
    }
}

