/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import com.tdunning.math.stats.TDigest;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

abstract class AbstractInternalTDigestPercentiles
extends InternalNumericMetricsAggregation.MultiValue {
    protected final double[] keys;
    protected final TDigestState state;
    final boolean keyed;

    AbstractInternalTDigestPercentiles(String name, double[] keys, TDigestState state, boolean keyed, DocValueFormat formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.keys = keys;
        this.state = state;
        this.keyed = keyed;
        this.format = formatter;
    }

    protected AbstractInternalTDigestPercentiles(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.keys = in.readDoubleArray();
        this.state = TDigestState.read(in);
        this.keyed = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDoubleArray(this.keys);
        TDigestState.write(this.state, out);
        out.writeBoolean(this.keyed);
    }

    @Override
    public double value(String name) {
        return this.value(Double.parseDouble(name));
    }

    public abstract double value(double var1);

    DocValueFormat formatter() {
        return this.format;
    }

    public long getEstimatedMemoryFootprint() {
        return this.state.byteSize();
    }

    TDigestState getState() {
        return this.state;
    }

    @Override
    public AbstractInternalTDigestPercentiles reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        TDigestState merged = null;
        for (InternalAggregation aggregation : aggregations) {
            AbstractInternalTDigestPercentiles percentiles = (AbstractInternalTDigestPercentiles)aggregation;
            if (merged == null) {
                merged = new TDigestState(percentiles.state.compression());
            }
            merged.add((TDigest)percentiles.state);
        }
        return this.createReduced(this.getName(), this.keys, merged, this.keyed, this.pipelineAggregators(), this.getMetaData());
    }

    protected abstract AbstractInternalTDigestPercentiles createReduced(String var1, double[] var2, TDigestState var3, boolean var4, List<PipelineAggregator> var5, Map<String, Object> var6);

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(Aggregation.CommonFields.VALUES.getPreferredName());
            for (int i = 0; i < this.keys.length; ++i) {
                String key = String.valueOf(this.keys[i]);
                double value = this.value(this.keys[i]);
                builder.field(key, this.state.size() == 0L ? null : Double.valueOf(value));
                if (this.format == DocValueFormat.RAW || this.state.size() <= 0L) continue;
                builder.field(key + "_as_string", this.format.format(value).toString());
            }
            builder.endObject();
        } else {
            builder.startArray(Aggregation.CommonFields.VALUES.getPreferredName());
            for (int i = 0; i < this.keys.length; ++i) {
                double value = this.value(this.keys[i]);
                builder.startObject();
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.keys[i]);
                builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.state.size() == 0L ? null : Double.valueOf(value));
                if (this.format != DocValueFormat.RAW && this.state.size() > 0L) {
                    builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(value).toString());
                }
                builder.endObject();
            }
            builder.endArray();
        }
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractInternalTDigestPercentiles that = (AbstractInternalTDigestPercentiles)obj;
        return this.keyed == that.keyed && Arrays.equals(this.keys, that.keys) && Objects.equals((Object)this.state, (Object)that.state);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.keyed, Arrays.hashCode(this.keys), this.state});
    }
}

