{
    Copyright (c) 2000-2002 by Marco van de Voort

    Some non POSIX BSD types used internally in the system unit.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
    MA 02110-1301, USA.

 ****************************************************************************
}
{***********************************************************************}
{                         POSIX STRUCTURES                              }
{***********************************************************************}

{$ifdef FPC_IS_SYSTEM}
  {$i ptypes.inc}
{$ENDIF}

Type
  timezone = packed record
    tz_minuteswest,tz_dsttime:cint;
  end;
  ptimezone =^timezone;
  TTimeZone = timezone;
  
  rusage = packed record
        ru_utime    : timeval;          { user time used }
        ru_stime    : timeval;          { system time used }
        ru_maxrss   : clong;            { max resident set size }
        ru_ixrss    : clong;            { integral shared memory size }
        ru_idrss    : clong;            { integral unshared data " }
        ru_isrss    : clong;            { integral unshared stack " }
        ru_minflt   : clong;            { page reclaims }
        ru_majflt   : clong;            { page faults }
        ru_nswap    : clong;            { swaps }
        ru_inblock  : clong;            { block input operations }
        ru_oublock  : clong;            { block output operations }
        ru_msgsnd   : clong;            { messages sent }
        ru_msgrcv   : clong;            { messages received }
        ru_nsignals : clong;            { signals received }
        ru_nvcsw    : clong;            { voluntary context switches }
        ru_nivcsw   : clong;            { involuntary " }
        end;
// #define      ru_last         ru_nivcsw
// #define      ru_first        ru_ixrss

{ auto generated by a c prog, statmacr.c}

Const
  S_IFMT  = &0000170000;
  S_IFLNK = &0000120000;
  S_IFREG = &0000100000;
  S_IFBLK = &0000060000;
  S_IFDIR = &0000040000;
  S_IFCHR = &0000020000;
  S_IFIFO = &0000010000;

  S_IFSOCK= &0000000000; // not defined under BeOS
  S_IFWHT = &0000000000; // not defined under BeOS
  S_ISVTX = &1000;

//      CONST SYS_NMLN=32;

// Can't find these two in Posix and in BeOS
//CONST
//    _UTSNAME_LENGTH = ;
//    _UTSNAME_NODENAME_LENGTH = ;

CONST                		// OS specific parameters for general<fd,sig>set behaviour
   BITSINWORD      = 8*sizeof(longint);
//   SIG_MAXSIG      = 32;    //128;	// highest signal version
   FD_MAXFDSET	   = 1024;
//   wordsinsigset   = 4;		// words in sigset_t
   ln2bitsinword   = 5;         { 32bit : ln(32)/ln(2)=5 } 
   ln2bitmask	   = 2 shl ln2bitsinword - 1;
   wordsinfdset    = FD_MAXFDSET DIV BITSINWORD;        // words in fdset_t   
   wordsinsigset   = SIG_MAXSIG  DIV BITSINWORD;      

TYPE
   { system information services }
   utsname = record
              sysname : Array[0..SYS_NMLN-1] OF Char;   // Name of this OS
              nodename: Array[0..SYS_NMLN-1] OF Char;   // Name of this network node.
              release : Array[0..SYS_NMLN-1] OF Char;   // Release level.
              version : Array[0..SYS_NMLN-1] OF Char;   // Version level.
              machine : Array[0..SYS_NMLN-1] OF Char;   // Hardware type.
             end;
  TUtsName= utsname;
  pUtsName= ^utsname;

  { file characteristics services }
   stat    = packed record { the types are real}
        st_dev        : dev_t;             // inode's device
        st_ino        : ino_t;             // inode's number
        st_mode       : mode_t;            // inode protection mode
        st_nlink      : nlink_t;           // number of hard links
        st_uid        : uid_t;             // user ID of the file's owner
        st_gid        : gid_t;             // group ID of the file's group
        st_size       : off_t;             // file size, in bytes
        st_rdev       : dev_t;             // device type
        st_blksize    : cint32;            // optimal blocksize for I/O
        st_atime      : time_t;            // time of last access
        st_atimensec  : clong;             // nsec of last access
        st_mtime      : time_t;            // time of last data modification
        st_mtimensec  : clong;             // nsec of last data modification
        st_ctime      : time_t;            // time of last file status change
        st_ctimensec  : clong;             // nsec of last file status change
        st_crtime     : time_t;            // time of creation file
        st_crtimensec : clong;             // nsec of creation file
		st_type       : cint;              // attribute/index type
        st_blocks     : fsblkcnt_t;        // blocks allocated for file
   end;
   
   TStat = stat;
   pStat = ^stat;

  { directory services }
   dirent = packed record
        d_dev:longint;
        d_pdev:longint;
        d_ino:int64;
        d_pino:int64;
        d_reclen:word;
        d_name:array[0..255] of char;
   end;
(*   dirent  = record
     d_dev : dev_t;
     d_pdev : dev_t;
     d_ino : ino_t;
     d_pino : ino_t;
     d_reclen : word;
     d_name : Char;
//        d_fileno      : cuint32;                        // file number of entry
//        d_reclen      : cuint16;                        // length of this record
//        d_type        : cuint8;                         // file type, see below
//        d_namlen      : cuint8;                         // length of string in d_name
//        d_name        : array[0..(255 + 1)-1] of char;  // name must be no longer than this
   end;*)
   TDirent = dirent;
   pDirent = ^dirent;

   dir     = packed record
        fd     : cint;         // file descriptor associated with directory
        ent : dirent;
//        dd_loc    : clong;        // offset in current buffer
//        dd_size   : clong;        // amount of data returned by getdirentries
//        dd_buf    : pchar;        // data buffer
//        dd_len    : cint;         // size of data buffer
{$ifdef netbsdpowerpc}
//	dd_pad1   : cint;
//        dd_seek   : cint64;        // magic cookie returned by getdirentries
{$else}
//        dd_seek   : clong;        // magic cookie returned by getdirentries
{$endif}
//        dd_rewind : clong;        // magic cookie for rewinding
//        dd_flags  : cint;         // flags for readdir
   end;
   TDir    = dir;
   pDir    = ^dir;

   utimbuf  = record
	        actime  : time_t;
	        modtime : time_t;
	        end;
   TUtimBuf = utimbuf;
   putimbuf = ^utimbuf;

   flock    = record
		l_start : off_t;	{ starting offset }
		l_len	: off_t;	{ len = 0 means until end of file }
		l_pid 	: pid_t;	{ lock owner }
		l_type	: cshort;	{ lock type: read/write, etc. }
		l_whence: cshort;	{ type of l_start }
                end;
   TFlock   = flock;
   pFlock   = ^flock;

 tms = packed record
	 tms_utime  : clock_t;	{ User CPU time }
	 tms_stime  : clock_t;	{ System CPU time }
	 tms_cutime : clock_t;	{ User CPU time of terminated child procs }
	 tms_cstime : clock_t;	{ System CPU time of terminated child procs }
	 end;
 TTms= tms;
 pTms= ^tms;

 TFDSet    = ARRAY[0..(FD_MAXFDSET div 32)-1] of Cardinal;
 pFDSet    = ^TFDSet;

{***********************************************************************}
{                  POSIX CONSTANT ROUTINE DEFINITIONS                   }
{***********************************************************************}
CONST
    { access routine - these maybe OR'ed together }
    F_OK        =     0;        { test for existence of file }
    R_OK        =     4;        { test for read permission on file }
    W_OK        =     2;        { test for write permission on file }
    X_OK        =     1;        { test for execute or search permission }
    { seek routine }
    SEEK_SET    =     0;        { seek from beginning of file }
    SEEK_CUR    =     1;        { seek from current position  }
    SEEK_END    =     2;        { seek from end of file       }
    { open routine                                 }
    { File access modes for `open' and `fcntl'.    }
    O_RDONLY    =     0;        { Open read-only.  }
    O_WRONLY    =     1;        { Open write-only. }
    O_RDWR      =     2;        { Open read/write. }
    { Bits OR'd into the second argument to open.  }
    O_CREAT     =  $200;        { Create file if it doesn't exist.  }
    O_EXCL      =  $100;        { Fail if file already exists.      }
    O_TRUNC     =  $400;        { Truncate file to zero length.     }
    O_NOCTTY    = $1000;        { Don't assign a controlling terminal. }
    { File status flags for `open' and `fcntl'.  }
    O_APPEND    =  $800;        { Writes append to the file.        }
    O_NONBLOCK  = $0080;        { Non-blocking I/O.                 }

    { mode_t possible values                                 }
    S_IRUSR =  %0100000000;     { Read permission for owner   }
    S_IWUSR =  %0010000000;     { Write permission for owner  }
    S_IXUSR =  %0001000000;     { Exec  permission for owner  }
    S_IRGRP =  %0000100000;     { Read permission for group   }
    S_IWGRP =  %0000010000;     { Write permission for group  }
    S_IXGRP =  %0000001000;     { Exec permission for group   }
    S_IROTH =  %0000000100;     { Read permission for world   }
    S_IWOTH =  %0000000010;     { Write permission for world  }
    S_IXOTH =  %0000000001;     { Exec permission for world   }

    { Used for waitpid }
    WNOHANG   =          1;     { don't block waiting               }
    WUNTRACED =          2;     { report status of stopped children }

Type 
        TRLimit  = record
                     rlim_cur,               { current (soft) limit }
          	     rlim_max : TRLim;     { maximum value for rlim_cur }
		    end;	
        PRLimit  = ^TRLimit;

 iovec = record
            iov_base : pointer;
	    iov_len  : size_t;
	   end;
  tiovec=iovec;
  piovec=^tiovec;		


    {*************************************************************************}
    {                               SIGNALS                                   }
    {*************************************************************************}

{$i signal.inc}

// BeOS types
{ ------------------------- Images --------------------------- }

type
  // Descriptive formats
  status_t = Longint;
  area_id   = Longint;
  port_id   = Longint;
  sem_id    = Longint;
  thread_id = Longint;
  team_id   = Longint;
  bigtime_t = int64;
  image_id = longint;


{/* commands that can be passed to fcntl */
#define	F_DUPFD			0x0001
#define	F_GETFD			0x0002
#define	F_SETFD			0x0004
#define	F_GETFL			0x0008
#define	F_SETFL			0x0010
#define F_GETLK         0x0020
#define F_RDLCK         0x0040
#define F_SETLK         0x0080
#define F_SETLKW        0x0100
#define F_UNLCK         0x0200
#define F_WRLCK         0x0400
}
const
  F_DUPFD	=		$0001;
  F_GETFD	=		$0002;
  F_SETFD	=		$0004;
  F_GETFL	=		$0008;
  F_SETFL	=		$0010;
  F_GETLK   =     	$0020;
  F_RDLCK   =     	$0040;
  F_SETLK   =      	$0080;
  F_SETLKW  =      	$0100;
  F_UNLCK   =      	$0200;
  F_WRLCK   =      	$0400;

    { image types }
const
   B_APP_IMAGE     = 1;
   B_LIBRARY_IMAGE = 2;
   B_ADD_ON_IMAGE  = 3;
   B_SYSTEM_IMAGE  = 4;
type
    image_info = packed record
     id      : image_id;   
     _type   : longint;
     sequence: longint;
     init_order: longint;
     init_routine: pointer;
     term_routine: pointer;
     device: dev_t;
     node: ino_t;
     name: array[0..1024{MAXPATHLEN}-1] of char;
{     name: string[255];
     name2: string[255];
     name3: string[255];
     name4: string[255];
     name5: string[5];
}
     text: pointer;
     data: pointer;
     text_size: longint;
     data_size: longint;
    end;
    
(*----- symbol types and functions ------------------------*)

const B_SYMBOL_TYPE_DATA = $1;
const B_SYMBOL_TYPE_TEXT = $2;
const B_SYMBOL_TYPE_ANY  = $5;

{ Constansts for MMAP }
const
{$ifdef FPC_IS_SYSTEM}
  MAP_PRIVATE   =2;
{$endif}
  MAP_ANONYMOUS =$08;

const
  POLLIN      = $0001;
  POLLOUT     = $0002;
  POLLERR     = $0004;
  POLLPRI     = $0020;
  POLLHUP     = $0080;
  POLLNVAL    = $1000;

  { XOpen, XPG 4.2 }
  POLLRDNORM  = POLLIN;
  POLLRDBAND  = $0008;
  POLLWRNORM  = POLLOUT;
  POLLWRBAND  = $0010;

type
  pollfd = record
    fd: cint;
    events: cshort;
    revents: cshort;
  end;
  tpollfd = pollfd;
  ppollfd = ^pollfd;

