/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.objects.Object2ShortMap;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortRBTreeSet;
import it.unimi.dsi.fastutil.shorts.ShortSortedSet;
import java.util.Arrays;
import org.gephi.graph.api.Configuration;
import org.gephi.graph.impl.utils.MapDeepEquals;

public class EdgeTypeStore {
    protected static final int NULL_TYPE = -1;
    protected static final int NULL_LABEL = 0;
    private static final short NULL_SHORT = Short.MIN_VALUE;
    public static final int MAX_SIZE = 65534;
    protected final Configuration configuration;
    protected final Object2ShortMap labelMap;
    protected final Short2ObjectMap idMap;
    protected final ShortSortedSet garbageQueue;
    protected int length;

    public EdgeTypeStore() {
        this(new Configuration());
    }

    public EdgeTypeStore(Configuration config) {
        this.configuration = config;
        this.garbageQueue = new ShortRBTreeSet();
        this.labelMap = new Object2ShortOpenHashMap(65534);
        this.idMap = new Short2ObjectOpenHashMap(65534);
        this.labelMap.defaultReturnValue((short)Short.MIN_VALUE);
        short id = this.intToShort(0);
        ++this.length;
        this.labelMap.put(null, id);
        this.idMap.put(id, null);
    }

    public int getId(Object label) {
        short id = this.labelMap.getShort(label);
        if (id == Short.MIN_VALUE) {
            return -1;
        }
        return this.shortToInt(id);
    }

    public Object getLabel(int id) {
        this.checkValidId(id);
        this.checkIdExists(id);
        return this.idMap.get(this.intToShort(id));
    }

    public int addType(Object label) {
        this.checkType(label);
        short id = this.labelMap.getShort(label);
        if (id == Short.MIN_VALUE) {
            if (!this.garbageQueue.isEmpty()) {
                id = this.garbageQueue.firstShort();
                this.garbageQueue.remove(id);
            } else {
                id = this.intToShort(this.length);
                if (this.length >= 65534) {
                    throw new RuntimeException("Maximum number of edge types reached at 65534");
                }
                ++this.length;
            }
            this.labelMap.put(label, id);
            this.idMap.put(id, label);
        }
        return this.shortToInt(id);
    }

    public boolean addType(Object label, int id) {
        short givenId = this.intToShort(id);
        short foundId = this.labelMap.getShort(label);
        if (foundId != Short.MIN_VALUE && foundId != givenId) {
            throw new RuntimeException("This label '" + label + "' is already assigned to a different id");
        }
        if (this.idMap.containsKey(givenId)) {
            if (label == null && this.idMap.get(givenId) == null || this.idMap.get(givenId).equals(label)) {
                return false;
            }
            throw new RuntimeException("This id '" + id + "' is already assigned to a different label");
        }
        if (this.garbageQueue.contains(givenId)) {
            this.garbageQueue.remove(givenId);
            this.labelMap.put(label, givenId);
            this.idMap.put(givenId, label);
        } else {
            short insertId = this.intToShort(this.length++);
            while (insertId < givenId) {
                this.garbageQueue.add(insertId);
                insertId = this.intToShort(this.length++);
                if (this.length < 65534) continue;
                throw new RuntimeException("Maximum number of edge types reached at 65534");
            }
            this.labelMap.put(label, givenId);
            this.idMap.put(givenId, label);
        }
        return true;
    }

    public int removeType(Object label) {
        short id = this.labelMap.removeShort(label);
        if (id == Short.MIN_VALUE) {
            return -1;
        }
        this.idMap.remove(id);
        this.garbageQueue.add(id);
        int intId = this.shortToInt(id);
        return intId;
    }

    public Object removeType(int type) {
        this.checkValidId(type);
        short id = this.intToShort(type);
        Object label = this.idMap.remove(id);
        if (label != null) {
            this.labelMap.remove(label);
            this.garbageQueue.add(id);
        }
        return label;
    }

    public Object[] getLabels() {
        return this.labelMap.keySet().toArray();
    }

    protected short[] getIds() {
        return this.labelMap.values().toShortArray();
    }

    public int[] getIdsAsInts() {
        short[] s = this.getIds();
        int[] res = new int[s.length];
        for (int i = 0; i < s.length; ++i) {
            res[i] = this.shortToInt(s[i]);
        }
        return res;
    }

    protected short[] getGarbage() {
        return this.garbageQueue.toShortArray();
    }

    public boolean contains(Object label) {
        return this.labelMap.containsKey(label);
    }

    public boolean contains(int id) {
        this.checkValidId(id);
        return this.idMap.containsKey(this.intToShort(id));
    }

    public void clear() {
        this.labelMap.clear();
        this.idMap.clear();
        this.garbageQueue.clear();
        this.length = 0;
        short id = this.intToShort(0);
        ++this.length;
        this.labelMap.put(null, id);
        this.idMap.put(id, null);
    }

    public int size() {
        return this.length - this.garbageQueue.size();
    }

    private short intToShort(int id) {
        return (short)(id + Short.MIN_VALUE + 1);
    }

    private int shortToInt(short id) {
        return id - Short.MIN_VALUE - 1;
    }

    private void checkValidId(int id) {
        if (id < 0 || id >= 65534) {
            throw new IllegalArgumentException("The type must be included between 0 and 65535");
        }
    }

    private void checkType(Object o) {
        if (o != null) {
            Class<?> cl = o.getClass();
            if (!(cl.equals(Integer.class) || cl.equals(String.class) || cl.equals(Float.class) || cl.equals(Double.class) || cl.equals(Short.class) || cl.equals(Byte.class) || cl.equals(Long.class) || cl.equals(Character.class) || cl.equals(Boolean.class))) {
                throw new IllegalArgumentException("The type id is " + cl.getCanonicalName() + " but must be a primitive type (int, string, long...)");
            }
            if (!this.configuration.getEdgeLabelType().equals(o.getClass())) {
                throw new IllegalArgumentException("The expected type was " + this.configuration.getEdgeLabelType().getCanonicalName() + " and " + o.getClass().getCanonicalName() + " was found");
            }
        }
    }

    private void checkIdExists(int id) {
        if (!this.idMap.containsKey(this.intToShort(id))) {
            throw new IllegalArgumentException("The id " + id + " doesn' exist");
        }
    }

    public int deepHashCode() {
        int hash = 3;
        short[] keys = this.idMap.keySet().toShortArray();
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            Short s = keys[i];
            Object o = this.idMap.get((Object)s);
            hash = 67 * hash + (o != null ? o.hashCode() : 0);
            hash = 67 * hash + s.hashCode();
        }
        return hash;
    }

    public boolean deepEquals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EdgeTypeStore other = (EdgeTypeStore)obj;
        if (!MapDeepEquals.mapDeepEquals(this.labelMap, other.labelMap)) {
            return false;
        }
        return MapDeepEquals.mapDeepEquals(this.idMap, other.idMap);
    }
}

