/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.preview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.gephi.desktop.preview.PresetUtils;
import org.gephi.desktop.preview.PreviewSettingsTopComponent;
import org.gephi.desktop.preview.PreviewUIModelImpl;
import org.gephi.desktop.preview.api.PreviewUIController;
import org.gephi.desktop.preview.api.PreviewUIModel;
import org.gephi.desktop.preview.propertyeditors.DependantColorPropertyEditor;
import org.gephi.desktop.preview.propertyeditors.DependantOriginalColorPropertyEditor;
import org.gephi.desktop.preview.propertyeditors.EdgeColorPropertyEditor;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewPreset;
import org.gephi.preview.api.PreviewProperty;
import org.gephi.preview.presets.BlackBackground;
import org.gephi.preview.presets.DefaultCurved;
import org.gephi.preview.presets.DefaultPreset;
import org.gephi.preview.presets.DefaultStraight;
import org.gephi.preview.presets.EdgesCustomColor;
import org.gephi.preview.presets.TagCloud;
import org.gephi.preview.presets.TextOutline;
import org.gephi.preview.types.DependantColor;
import org.gephi.preview.types.DependantOriginalColor;
import org.gephi.preview.types.EdgeColor;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.openide.util.Lookup;
import org.openide.windows.WindowManager;

public class PreviewUIControllerImpl
implements PreviewUIController {
    private final List<PropertyChangeListener> listeners;
    private final PreviewController previewController;
    private final GraphController graphController;
    private final PresetUtils presetUtils = new PresetUtils();
    private PreviewUIModelImpl model = null;
    private GraphModel graphModel = null;

    public PreviewUIControllerImpl() {
        this.previewController = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
        this.listeners = new ArrayList<PropertyChangeListener>();
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        this.graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
                PreviewModel previewModel = PreviewUIControllerImpl.this.previewController.getModel(workspace);
                if (workspace.getLookup().lookup(PreviewUIModelImpl.class) == null) {
                    workspace.add((Object)new PreviewUIModelImpl(previewModel));
                }
                PreviewUIControllerImpl.this.enableRefresh();
            }

            public void select(Workspace workspace) {
                PreviewUIControllerImpl.this.graphModel = PreviewUIControllerImpl.this.graphController.getGraphModel(workspace);
                PreviewModel previewModel = PreviewUIControllerImpl.this.previewController.getModel(workspace);
                PreviewUIControllerImpl.this.model = (PreviewUIModelImpl)workspace.getLookup().lookup(PreviewUIModelImpl.class);
                if (PreviewUIControllerImpl.this.model == null) {
                    PreviewUIControllerImpl.this.model = new PreviewUIModelImpl(previewModel);
                    workspace.add((Object)PreviewUIControllerImpl.this.model);
                }
                Float visibilityRatio = Float.valueOf(previewModel.getProperties().getFloatValue("visibility-ratio"));
                PreviewUIControllerImpl.this.model.setVisibilityRatio(visibilityRatio.floatValue());
                PreviewUIControllerImpl.this.fireEvent("select", PreviewUIControllerImpl.this.model);
            }

            public void unselect(Workspace workspace) {
                if (PreviewUIControllerImpl.this.graphModel != null) {
                    PreviewUIControllerImpl.this.graphModel = null;
                }
                PreviewUIControllerImpl.this.fireEvent("unselect", PreviewUIControllerImpl.this.model);
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                if (PreviewUIControllerImpl.this.graphModel != null) {
                    PreviewUIControllerImpl.this.graphModel = null;
                }
                PreviewUIControllerImpl.this.fireEvent("select", null);
                PreviewUIControllerImpl.this.model = null;
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            Float visibilityRatio;
            this.model = (PreviewUIModelImpl)pc.getCurrentWorkspace().getLookup().lookup(PreviewUIModelImpl.class);
            if (this.model == null) {
                PreviewModel previewModel = this.previewController.getModel(pc.getCurrentWorkspace());
                this.model = new PreviewUIModelImpl(previewModel);
                pc.getCurrentWorkspace().add((Object)this.model);
            }
            if ((visibilityRatio = Float.valueOf(this.previewController.getModel().getProperties().getFloatValue("visibility-ratio"))) != null) {
                this.model.setVisibilityRatio(visibilityRatio.floatValue());
            }
            this.graphModel = this.graphController.getGraphModel(pc.getCurrentWorkspace());
        }
        PropertyEditorManager.registerEditor(EdgeColor.class, EdgeColorPropertyEditor.class);
        PropertyEditorManager.registerEditor(DependantOriginalColor.class, DependantOriginalColorPropertyEditor.class);
        PropertyEditorManager.registerEditor(DependantColor.class, DependantColorPropertyEditor.class);
    }

    @Override
    public void refreshPreview() {
        if (this.model != null) {
            Thread refreshThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    PreviewUIControllerImpl.this.model.setRefreshing(true);
                    PreviewUIControllerImpl.this.fireEvent("refreshing", true);
                    PreviewUIControllerImpl.this.previewController.getModel().getProperties().putValue("visibility-ratio", (Object)Float.valueOf(PreviewUIControllerImpl.this.model.getVisibilityRatio()));
                    PreviewUIControllerImpl.this.previewController.refreshPreview();
                    PreviewUIControllerImpl.this.fireEvent("refreshed", PreviewUIControllerImpl.this.model);
                    PreviewUIControllerImpl.this.model.setRefreshing(false);
                    PreviewUIControllerImpl.this.fireEvent("refreshing", false);
                    PreviewUIControllerImpl.this.fireEvent("graph_changed", false);
                }
            }, "Refresh Preview");
            refreshThread.start();
        }
    }

    private void enableRefresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PreviewSettingsTopComponent pstc = (PreviewSettingsTopComponent)WindowManager.getDefault().findTopComponent("PreviewSettingsTopComponent");
                pstc.enableRefreshButton();
            }
        });
    }

    @Override
    public void setVisibilityRatio(float visibilityRatio) {
        if (this.model != null) {
            this.model.setVisibilityRatio(visibilityRatio);
        }
    }

    @Override
    public PreviewUIModel getModel() {
        return this.model;
    }

    @Override
    public PreviewPreset[] getDefaultPresets() {
        return new PreviewPreset[]{new DefaultPreset(), new DefaultCurved(), new DefaultStraight(), new TextOutline(), new BlackBackground(), new EdgesCustomColor(), new TagCloud()};
    }

    @Override
    public PreviewPreset[] getUserPresets() {
        Object[] presetsArray = this.presetUtils.getPresets();
        Arrays.sort(presetsArray);
        return presetsArray;
    }

    @Override
    public void setCurrentPreset(PreviewPreset preset) {
        if (this.model != null) {
            this.model.setCurrentPreset(preset);
            PreviewModel previewModel = this.previewController.getModel();
            previewModel.getProperties().applyPreset(preset);
        }
    }

    @Override
    public void addPreset(PreviewPreset preset) {
        this.presetUtils.savePreset(preset);
    }

    @Override
    public void savePreset(String name) {
        if (this.model != null) {
            PreviewModel previewModel = this.previewController.getModel();
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (PreviewProperty p : previewModel.getProperties().getProperties()) {
                map.put(p.getName(), p.getValue());
            }
            for (Map.Entry p : previewModel.getProperties().getSimpleValues()) {
                map.put((String)p.getKey(), p.getValue());
            }
            PreviewPreset preset = new PreviewPreset(name, map);
            this.presetUtils.savePreset(preset);
            this.model.setCurrentPreset(preset);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireEvent(String eventName, Object data) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, eventName, null, data);
        for (PropertyChangeListener l : this.listeners) {
            l.propertyChange(event);
        }
    }
}

