/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.timeline;

import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Interval;
import org.gephi.timeline.TimelineControllerImpl;
import org.gephi.timeline.TimelineModelImpl;

public class GraphObserverThread
extends Thread {
    private final TimelineControllerImpl timelineController;
    private final TimelineModelImpl timelineModel;
    private boolean stop;
    private Interval interval;

    public GraphObserverThread(TimelineControllerImpl controller, TimelineModelImpl model) {
        this.timelineModel = model;
        this.timelineController = controller;
        this.interval = model.getGraphModel().getTimeBounds();
    }

    @Override
    public void run() {
        while (!this.stop) {
            GraphModel graphModel = this.timelineModel.getGraphModel();
            Interval bounds = graphModel.getTimeBounds();
            if (!bounds.equals((Object)this.interval)) {
                this.interval = bounds;
                this.timelineController.setMinMax(this.interval.getLow(), this.interval.getHigh());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stopThread() {
        this.stop = true;
    }
}

