/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.utils;

import java.awt.Color;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class PaletteUtils {
    public static List<Color> getSequenceColors(int num) {
        LinkedList<Color> colors = new LinkedList<Color>();
        Random random = new Random();
        float B = random.nextFloat() * 2.0f / 5.0f + 0.6f;
        float S = random.nextFloat() * 2.0f / 5.0f + 0.6f;
        for (int i = 1; i <= num; ++i) {
            float H = (float)i / (float)num;
            Color c = Color.getHSBColor(H, S, B);
            colors.add(c);
        }
        Collections.shuffle(colors);
        return colors;
    }

    public static Palette[] getSequencialPalettes() {
        Palette p1 = new Palette(new Color(15595771), new Color(0xB2E2E2), new Color(6734500), new Color(2925151), new Color(27948));
        Palette p2 = new Palette(new Color(15595771), new Color(11783651), new Color(9213638), new Color(8935079), new Color(8458108));
        Palette p3 = new Palette(new Color(15792616), new Color(12248252), new Color(8113348), new Color(4432586), new Color(551084));
        Palette p4 = new Palette(new Color(16707801), new Color(16632970), new Color(16551257), new Color(14895667), new Color(0xB30000));
        Palette p5 = new Palette(new Color(16706530), new Color(16495801), new Color(16214177), new Color(12917642), new Color(7995767));
        Palette p6 = new Palette(new Color(15855350), new Color(12437985), new Color(7645647), new Color(2854078), new Color(285325));
        Palette p7 = new Palette(new Color(0xFFFFCC), new Color(10607284), new Color(4306628), new Color(2916280), new Color(2438292));
        Palette p8 = new Palette(new Color(0xFFFFD4), new Color(16701838), new Color(16685353), new Color(14245646), new Color(10040324));
        return new Palette[]{p1, p2, p3, p4, p5, p6, p7, p8};
    }

    public static Palette[] getDivergingPalettes() {
        Palette p1 = new Palette(new Color(0xA6611A), new Color(14664317), new Color(0xF5F5F5), new Color(8441281), new Color(99697));
        Palette p2 = new Palette(new Color(13638795), new Color(15840986), new Color(0xF7F7F7), new Color(12116358), new Color(5090342));
        Palette p3 = new Palette(new Color(15098113), new Color(16627811), new Color(0xF7F7F7), new Color(11709394), new Color(6175897));
        Palette p4 = new Palette(new Color(13238304), new Color(16033154), new Color(0xFFFFFF), new Color(0xBABABA), new Color(0x404040));
        Palette p5 = new Palette(new Color(14096668), new Color(16625249), new Color(0xFFFFBF), new Color(11262441), new Color(2915254));
        return new Palette[]{p1, p2, p3, p4, p5};
    }

    public static Palette[] getQualitativePalettes() {
        Palette p1 = new Palette(new Color(10931939), new Color(2062516), new Color(11722634), new Color(3383340), new Color(16489113), new Color(14883356), new Color(16629615), new Color(0xFF7F00), new Color(13284054));
        Palette p2 = new Palette(new Color(16495790), new Color(11783651), new Color(13429701), new Color(14601188), new Color(16701862), new Color(0xFFFFCC), new Color(15063229), new Color(16636652), new Color(0xF2F2F2));
        Palette p3 = new Palette(new Color(14948892), new Color(3636920), new Color(5091146), new Color(9981603), new Color(0xFF7F00), new Color(0xFFFF33), new Color(10901032), new Color(16220607), new Color(0x999999));
        Palette p4 = new Palette(new Color(9294791), new Color(0xFFFFB3), new Color(12499674), new Color(16482418), new Color(8434131), new Color(16626786), new Color(11787881), new Color(16567781), new Color(0xD9D9D9));
        return new Palette[]{p1, p2, p3, p4};
    }

    public static Palette get3ClassPalette(Palette palette) {
        if (palette.colors.length == 5) {
            return new Palette(palette.colors[0], palette.colors[2], palette.colors[4]);
        }
        return palette;
    }

    public static Palette reversePalette(Palette palette) {
        Color[] c = new Color[palette.colors.length];
        for (int i = 0; i < palette.getColors().length; ++i) {
            c[c.length - 1 - i] = palette.colors[i];
        }
        return new Palette(c);
    }

    public static class Palette {
        private Color[] colors;

        public Palette(Color ... colors) {
            this.colors = colors;
        }

        public Color[] getColors() {
            return this.colors;
        }

        public float[] getPositions() {
            float[] pos = new float[this.colors.length];
            for (int i = 0; i < pos.length; ++i) {
                pos[i] = (float)i / (float)(pos.length - 1);
            }
            return pos;
        }
    }
}

