/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.utils.sparklines;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.gephi.utils.sparklines.SparklineParameters;

public class SparklineGraph {
    private static final int HIGHLIGHT_RADIUS = 4;

    public static BufferedImage draw(Number[] values, SparklineParameters parameters) {
        return SparklineGraph.draw(null, values, null, null, parameters);
    }

    public static BufferedImage draw(Number[] xValues, Number[] yValues, SparklineParameters parameters) {
        return SparklineGraph.draw(xValues, yValues, null, null, parameters);
    }

    public static BufferedImage draw(Number[] yValues, Number yMinValue, Number yMaxValue, SparklineParameters parameters) {
        return SparklineGraph.draw(null, yValues, yMinValue, yMaxValue, parameters);
    }

    public static BufferedImage draw(Number[] xValues, Number[] yValues, Number yMinValue, Number yMaxValue, SparklineParameters parameters) {
        float xTickWidth;
        float xMin;
        if (parameters == null) {
            throw new IllegalArgumentException("parameters can't be null");
        }
        if (yValues == null || yValues.length < 2) {
            throw new IllegalArgumentException("Y values can't be null and have a length of at least 2");
        }
        if (xValues != null && xValues.length != yValues.length) {
            throw new IllegalArgumentException("X values should have the same length as Y values");
        }
        BufferedImage image = new BufferedImage(parameters.getWidth(), parameters.getHeight(), 2);
        Color backgroundColor = parameters.getBackgroundColor() != null ? parameters.getBackgroundColor() : SparklineParameters.DEFAULT_BACKGROUND_COLOR;
        Color lineColor = parameters.getLineColor() != null ? parameters.getLineColor() : SparklineParameters.DEFAULT_LINE_COLOR;
        Color areaColor = parameters.getAreaColor() != null ? parameters.getAreaColor() : SparklineParameters.DEFAULT_AREA_COLOR;
        Color highlightMinColor = parameters.getHighlightMinColor();
        Color highlightMaxColor = parameters.getHighlightMaxColor();
        int width = parameters.getWidth();
        int height = parameters.getHeight();
        ArrayList<HighlightParameters> highlightsList = new ArrayList<HighlightParameters>();
        Color highlightValueColor = parameters.getHighligtValueColor() != null ? parameters.getHighligtValueColor() : SparklineParameters.DEFAULT_HIGHLIGHT_VALUE_COLOR;
        Integer highlightedValueXPosition = parameters.getHighlightedValueXPosition();
        String highlightedValueText = null;
        float yMin = yMinValue != null ? yMinValue.floatValue() : SparklineGraph.calculateMin(yValues);
        float yMax = yMaxValue != null ? yMaxValue.floatValue() : SparklineGraph.calculateMax(yValues);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (backgroundColor != null && !parameters.isTransparentBackground()) {
            g.setBackground(backgroundColor);
            g.clearRect(0, 0, width, height);
        }
        g.setPaint(lineColor);
        if (yMin == yMax) {
            highlightMaxColor = null;
            highlightMinColor = null;
        }
        if (highlightMaxColor != null || highlightMinColor != null || highlightValueColor != null) {
            height -= 4;
            width -= 4;
            g.translate(2, 2);
        }
        Path2D.Float path = new Path2D.Float();
        path.moveTo(0.0f, height);
        if (xValues == null) {
            xMin = 0.0f;
            xTickWidth = (float)width / (float)(yValues.length - 1);
        } else {
            xMin = xValues[0].floatValue();
            xTickWidth = (float)width / (xValues[xValues.length - 1].floatValue() - xMin);
        }
        float yTickWidth = (float)height / (yMax - yMin);
        float bottom = height;
        for (int i = 0; i < yValues.length - 1; ++i) {
            float y0;
            float y1;
            float x1;
            float x0;
            if (xValues == null) {
                x0 = (float)i * xTickWidth;
                x1 = (float)(i + 1) * xTickWidth;
            } else {
                x0 = (xValues[i].floatValue() - xMin) * xTickWidth;
                x1 = (xValues[i + 1].floatValue() - xMin) * xTickWidth;
            }
            if (yMin == yMax) {
                y0 = y1 = bottom - (float)height / 2.0f;
            } else {
                y0 = bottom - (yValues[i].floatValue() - yMin) * yTickWidth;
                y1 = bottom - (yValues[i + 1].floatValue() - yMin) * yTickWidth;
            }
            g.draw(new Line2D.Double(x0, y0, x1, y1));
            if (parameters.isDrawArea()) {
                if (i == 0) {
                    path.lineTo(x0, y0);
                }
                path.lineTo(x1, y1);
            }
            if (yValues[i + 1].floatValue() == yMin && highlightMinColor != null) {
                highlightsList.add(new HighlightParameters(x1, y1, highlightMinColor));
                highlightMinColor = null;
            }
            if (yValues[i + 1].floatValue() == yMax && highlightMaxColor != null) {
                highlightsList.add(new HighlightParameters(x1, y1, highlightMaxColor));
                highlightMaxColor = null;
            }
            if (i == 0) {
                if (yValues[0].floatValue() == yMin && highlightMinColor != null) {
                    highlightsList.add(new HighlightParameters(x0, y0, highlightMinColor));
                    highlightMinColor = null;
                }
                if (yValues[0].floatValue() == yMax && highlightMaxColor != null) {
                    highlightsList.add(new HighlightParameters(x0, y0, highlightMaxColor));
                    highlightMaxColor = null;
                }
            }
            if (highlightedValueXPosition == null || !(x1 >= (float)highlightedValueXPosition.intValue())) continue;
            if ((float)highlightedValueXPosition.intValue() - x0 < (x1 - x0) / 2.0f) {
                highlightsList.add(new HighlightParameters(x0, y0, highlightValueColor));
                if (parameters.getHighlightTextColor() != null) {
                    highlightedValueText = SparklineGraph.buildHighlightText(parameters.getHighlightTextMode(), xValues != null ? (Number)xValues[i] : (Number)i, yValues[i]);
                }
            } else {
                highlightsList.add(new HighlightParameters(x1, y1, highlightValueColor));
                if (parameters.getHighlightTextColor() != null) {
                    highlightedValueText = SparklineGraph.buildHighlightText(parameters.getHighlightTextMode(), xValues != null ? (Number)xValues[i + 1] : (Number)(i + 1), yValues[i + 1]);
                }
            }
            highlightedValueXPosition = null;
        }
        if (parameters.isDrawArea()) {
            path.lineTo(width, height);
            path.lineTo(0.0f, height);
            g.setColor(areaColor);
            g.fill(path);
        }
        for (HighlightParameters p : highlightsList) {
            SparklineGraph.drawHighlight(g, p.x, p.y, p.color);
        }
        if (highlightedValueText != null) {
            g.setFont(g.getFont().deriveFont(1));
            int textWidth = g.getFontMetrics().stringWidth(highlightedValueText);
            int textHeight = g.getFontMetrics().getHeight();
            g.translate((float)(width - textWidth) / 2.0f, ((float)height + (float)textHeight / 2.0f) / 2.0f);
            if (parameters.getHighlightTextBoxColor() != null) {
                g.setPaint(parameters.getHighlightTextBoxColor());
                g.fill(g.getFontMetrics().getStringBounds(highlightedValueText, g));
            }
            g.setPaint(parameters.getHighlightTextColor());
            g.drawString(highlightedValueText, 0, 0);
        }
        return image;
    }

    private static void drawHighlight(Graphics2D g, float x, float y, Color highlightColor) {
        Paint oldPaint = g.getPaint();
        g.setPaint(highlightColor);
        g.fill(new Ellipse2D.Double(x - 2.0f, y - 2.0f, 4.0, 4.0));
        g.setPaint(oldPaint);
    }

    private static float calculateMin(Number[] yValues) {
        float min = yValues[0].floatValue();
        for (Number d : yValues) {
            min = Math.min(min, d.floatValue());
        }
        return min;
    }

    private static float calculateMax(Number[] yValues) {
        float max = yValues[0].floatValue();
        for (Number d : yValues) {
            max = Math.max(max, d.floatValue());
        }
        return max;
    }

    private static String buildHighlightText(SparklineParameters.HighlightTextMode highlightTextMode, Number x, Number y) {
        StringBuilder sb = new StringBuilder();
        if (highlightTextMode == null) {
            highlightTextMode = SparklineParameters.DEFAULT_HIGHLIGHT_TEXT_MODE;
        }
        sb.append('(');
        switch (highlightTextMode) {
            case X_VALUES: {
                sb.append(x);
                break;
            }
            case Y_VALUES: {
                sb.append(y);
                break;
            }
            default: {
                sb.append(x);
                sb.append(',');
                sb.append(y);
            }
        }
        sb.append(')');
        return sb.toString();
    }

    private static class HighlightParameters {
        float x;
        float y;
        Color color;

        public HighlightParameters(float x, float y, Color color) {
            this.x = x;
            this.y = y;
            this.color = color;
        }
    }
}

