/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.operator;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.plugin.operator.MASKEdgeUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.filters.spi.Operator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Subgraph;
import org.gephi.project.api.Workspace;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MASKBuilderEdge
implements FilterBuilder {
    public Category getCategory() {
        return new Category(NbBundle.getMessage(MASKBuilderEdge.class, (String)"Operator.category"));
    }

    public String getName() {
        return NbBundle.getMessage(MASKBuilderEdge.class, (String)"MASKBuilderEdge.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(MASKBuilderEdge.class, (String)"MASKBuilderEdge.description");
    }

    public Filter getFilter(Workspace workspace) {
        return new MaskEdgeOperator();
    }

    public JPanel getPanel(Filter filter) {
        MASKEdgeUI ui = (MASKEdgeUI)Lookup.getDefault().lookup(MASKEdgeUI.class);
        if (ui != null) {
            return ui.getPanel((MaskEdgeOperator)filter);
        }
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class MaskEdgeOperator
    implements Operator {
        private EdgesOptions option = EdgesOptions.ANY;
        private FilterProperty[] filterProperties;

        public int getInputCount() {
            return 1;
        }

        public String getName() {
            return NbBundle.getMessage(MASKBuilderEdge.class, (String)"MASKBuilderEdge.name");
        }

        public FilterProperty[] getProperties() {
            if (this.filterProperties == null) {
                this.filterProperties = new FilterProperty[0];
                try {
                    this.filterProperties = new FilterProperty[]{FilterProperty.createProperty((Filter)this, String.class, (String)"option")};
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.filterProperties;
        }

        public Graph filter(Subgraph[] graphs) {
            if (graphs.length > 1) {
                throw new IllegalArgumentException("Filter accepts a single graph in parameter");
            }
            Subgraph graph = graphs[0];
            Graph mainGraph = graph.getView().getGraphModel().getGraph();
            ArrayList<Edge> edgesToKeep = new ArrayList<Edge>();
            for (Edge e : mainGraph.getEdges()) {
                boolean source = graph.contains(e.getSource());
                boolean target = graph.contains(e.getTarget());
                boolean keep = false;
                switch (this.option) {
                    case SOURCE: {
                        keep = source;
                        break;
                    }
                    case TARGET: {
                        keep = target;
                        break;
                    }
                    case BOTH: {
                        keep = source && target;
                        break;
                    }
                    case ANY: {
                        boolean bl = keep = source || target;
                    }
                }
                if (!keep) continue;
                edgesToKeep.add(e);
            }
            graph.clearEdges();
            for (Node n : mainGraph.getNodes()) {
                if (graph.contains(n)) continue;
                graph.addNode(n);
            }
            for (Edge e : edgesToKeep) {
                graph.addEdge(e);
            }
            return graph;
        }

        public Graph filter(Graph graph, Filter[] filters) {
            if (filters.length > 1) {
                throw new IllegalArgumentException("Filter accepts a single filter in parameter");
            }
            if (filters[0] instanceof NodeFilter && ((NodeFilter)filters[0]).init(graph)) {
                NodeFilter filter = (NodeFilter)filters[0];
                for (Edge e : graph.getEdges()) {
                    Node source = e.getSource();
                    Node target = e.getTarget();
                    boolean remove = false;
                    switch (this.option) {
                        case SOURCE: {
                            remove = !filter.evaluate(graph, (Element)source);
                            break;
                        }
                        case TARGET: {
                            remove = !filter.evaluate(graph, (Element)target);
                            break;
                        }
                        case BOTH: {
                            remove = !filter.evaluate(graph, (Element)source) || !filter.evaluate(graph, (Element)target);
                            break;
                        }
                        case ANY: {
                            boolean bl = remove = !filter.evaluate(graph, (Element)source) && !filter.evaluate(graph, (Element)target);
                        }
                    }
                    if (!remove) continue;
                    graph.removeEdge(e);
                }
                filter.finish();
            }
            return graph;
        }

        public String getOption() {
            return this.option.toString();
        }

        public void setOption(String option) {
            this.option = EdgesOptions.valueOf(option);
        }

        public static enum EdgesOptions {
            SOURCE,
            TARGET,
            ANY,
            BOTH;

        }
    }
}

