/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class PaletteIcon
implements Icon {
    private static int COLOR_WIDTH = 13;
    private static int COLOR_HEIGHT = 13;
    private static Color BORDER_COLOR = new Color(0x444444);
    private final Color[] colors;
    private final int maxColors;

    public PaletteIcon(Color[] colors) {
        this(colors, colors.length);
    }

    public PaletteIcon(Color[] colors, int maxColors) {
        this.colors = colors;
        this.maxColors = Math.min(maxColors, colors.length);
    }

    @Override
    public int getIconWidth() {
        return COLOR_WIDTH * this.maxColors;
    }

    @Override
    public int getIconHeight() {
        return COLOR_HEIGHT + 2;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.0f));
        for (int i = 0; i < this.maxColors; ++i) {
            g2.setColor(this.colors[i]);
            g2.fillRect(x + 2 + i * COLOR_WIDTH, y, COLOR_WIDTH, COLOR_HEIGHT);
            g2.setColor(BORDER_COLOR);
            g2.drawRect(x + 2 + i * COLOR_WIDTH, y, COLOR_WIDTH, COLOR_HEIGHT);
        }
    }
}

