/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.WholeNumberField;
import tim.prune.gui.map.WpIconLibrary;

public class SetDisplaySettings
extends GenericFunction {
    private JDialog _dialog = null;
    private WholeNumberField _lineWidthField = null;
    private JCheckBox _antialiasCheckbox = null;
    private JComboBox<Integer> _wpIconCombobox = null;
    private JRadioButton[] _sizeRadioButtons = null;
    private JButton _okButton = null;

    public SetDisplaySettings(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.setdisplaysettings";
    }

    private Component makeContents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel3);
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.displaysettings.linewidth"));
        guiGridLayout.add(jLabel);
        this._lineWidthField = new WholeNumberField(1);
        guiGridLayout.add(this._lineWidthField);
        this._antialiasCheckbox = new JCheckBox(I18nManager.getText("dialog.displaysettings.antialias"), false);
        guiGridLayout.add(this._antialiasCheckbox);
        guiGridLayout.add(new JLabel(""));
        jPanel3.setAlignmentX(0.5f);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createVerticalStrut(10));
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        JPanel jPanel5 = new JPanel();
        GuiGridLayout guiGridLayout2 = new GuiGridLayout(jPanel5);
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.displaysettings.waypointicons"));
        jLabel2.setAlignmentX(0.0f);
        guiGridLayout2.add(jLabel2);
        this._wpIconCombobox = new JComboBox<Integer>(new Integer[]{0, 1, 2, 3, 4});
        this._wpIconCombobox.setRenderer(new IconComboRenderer());
        guiGridLayout2.add(this._wpIconCombobox);
        jPanel4.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(1));
        this._sizeRadioButtons = new JRadioButton[3];
        ButtonGroup buttonGroup = new ButtonGroup();
        String[] stringArray = new String[]{"small", "medium", "large"};
        int n = 0;
        while (n < 3) {
            this._sizeRadioButtons[n] = new JRadioButton(I18nManager.getText("dialog.displaysettings.size." + stringArray[n]));
            buttonGroup.add(this._sizeRadioButtons[n]);
            jPanel6.add(this._sizeRadioButtons[n]);
            ++n;
        }
        jPanel4.add(jPanel6);
        jPanel4.setAlignmentX(0.5f);
        jPanel2.add(jPanel4);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetDisplaySettings.this.finish();
            }
        });
        jPanel7.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetDisplaySettings.this._dialog.dispose();
            }
        });
        jPanel7.add(jButton);
        jPanel.add((Component)jPanel7, "South");
        return jPanel;
    }

    public void begin() {
        int n;
        if (this._dialog == null) {
            this._dialog = new JDialog((Frame)this._parentFrame, I18nManager.getText(this.getNameKey()));
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeContents());
            this._dialog.pack();
        }
        if ((n = Config.getConfigInt("prune.linewidth")) < 1 || n > 4) {
            n = 2;
        }
        this._lineWidthField.setValue(n);
        this._antialiasCheckbox.setSelected(Config.getConfigBoolean("prune.antialias"));
        this._wpIconCombobox.setSelectedIndex(Config.getConfigInt("prune.waypointicons"));
        this.selectIconSizeRadio(Config.getConfigInt("prune.waypointiconsize"));
        this._dialog.setVisible(true);
    }

    private void selectIconSizeRadio(int n) {
        if (n < 0 || n >= this._sizeRadioButtons.length) {
            n = 1;
        }
        if (this._sizeRadioButtons[n] != null) {
            this._sizeRadioButtons[n].setSelected(true);
        }
    }

    private int getSelectedIconSize() {
        int n = 0;
        while (n < this._sizeRadioButtons.length) {
            if (this._sizeRadioButtons[n] != null && this._sizeRadioButtons[n].isSelected()) {
                return n;
            }
            ++n;
        }
        return 1;
    }

    public void finish() {
        int n = this._lineWidthField.getValue();
        if (n < 1 || n > 4) {
            n = 2;
        }
        Config.setConfigInt("prune.linewidth", n);
        Config.setConfigBoolean("prune.antialias", this._antialiasCheckbox.isSelected());
        Config.setConfigInt("prune.waypointicons", this._wpIconCombobox.getSelectedIndex());
        Config.setConfigInt("prune.waypointiconsize", this.getSelectedIconSize());
        UpdateMessageBroker.informSubscribers((byte)64);
        this._dialog.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IconComboRenderer
    extends JLabel
    implements ListCellRenderer<Integer> {
        private ImageIcon[] _icons = new ImageIcon[5];

        IconComboRenderer() {
            this.setOpaque(true);
        }

        private String getLabel(int n) {
            return I18nManager.getText("dialog.displaysettings.wpicon." + WpIconLibrary.getIconName(n));
        }

        private ImageIcon getIcon(int n) {
            if (this._icons[n] == null) {
                this._icons[n] = WpIconLibrary.getIconDefinition(n, 1).getImageIcon();
            }
            return this._icons[n];
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Integer> jList, Integer n, int n2, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setIcon(this.getIcon(n));
            this.setText(this.getLabel(n));
            return this;
        }
    }
}

