/*
 * Decompiled with CFR 0.152.
 */
package org.grails.encoder;

import java.io.IOException;
import java.io.Writer;
import org.grails.encoder.EncodedAppender;
import org.grails.encoder.EncodedAppenderFactory;
import org.grails.encoder.EncodedAppenderWriterFactory;
import org.grails.encoder.Encoder;
import org.grails.encoder.EncoderAware;
import org.grails.encoder.EncodingStateRegistry;

public class EncodedAppenderWriter
extends Writer
implements EncodedAppenderWriterFactory,
EncodedAppenderFactory,
EncoderAware {
    protected EncodedAppender encodedAppender;
    protected Encoder encoder;
    protected EncodingStateRegistry encodingStateRegistry;
    private char[] singleCharBuffer = new char[1];

    public EncodedAppenderWriter(EncodedAppender encodedAppender, Encoder encoder, EncodingStateRegistry encodingStateRegistry) {
        this.encodedAppender = encodedAppender;
        this.encoder = encoder;
        this.encodingStateRegistry = encodingStateRegistry;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.encodedAppender.append(this.encoder, null, cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.encodedAppender.flush();
    }

    @Override
    public void close() throws IOException {
        this.encodedAppender.close();
    }

    @Override
    public void write(int c) throws IOException {
        this.append((char)c);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.encodedAppender.append(this.encoder, this.encodingStateRegistry != null && off == 0 && len == str.length() ? this.encodingStateRegistry.getEncodingStateFor(str) : null, str, off, len);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        this.encodedAppender.append(this.encoder, this.encodingStateRegistry != null ? this.encodingStateRegistry.getEncodingStateFor(csq) : null, csq, 0, csq.length());
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        this.encodedAppender.append(this.encoder, null, csq, 0, end - start);
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.singleCharBuffer[0] = c;
        this.encodedAppender.append(this.encoder, null, this.singleCharBuffer, 0, 1);
        return this;
    }

    @Override
    public EncodedAppender getEncodedAppender() {
        return this.encodedAppender;
    }

    @Override
    public Encoder getEncoder() {
        return this.encoder;
    }

    @Override
    public Writer getWriterForEncoder(Encoder encoder, EncodingStateRegistry encodingStateRegistry) {
        return new EncodedAppenderWriter(this.encodedAppender, encoder, encodingStateRegistry);
    }
}

