/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.DefaultBeanWrapper;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface BeanWrapper<T>
extends AnnotationMetadataProvider {
    @Nonnull
    public BeanIntrospection<T> getIntrospection();

    @Nonnull
    public T getBean();

    @Nonnull
    default public String[] getPropertyNames() {
        return this.getIntrospection().getPropertyNames();
    }

    @Nonnull
    default public Collection<BeanProperty<T, Object>> getBeanProperties() {
        return this.getIntrospection().getBeanProperties();
    }

    @Nonnull
    default public <P> P getRequiredProperty(@Nonnull String name, @Nonnull Class<P> type) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("type", type);
        Argument<P> argument = Argument.of(type);
        return this.getRequiredProperty(name, argument);
    }

    default public <P> P getRequiredProperty(@Nonnull String name, @Nonnull Argument<P> argument) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("argument", argument);
        ArgumentConversionContext<P> context = ConversionContext.of(argument);
        return this.getRequiredProperty(name, context);
    }

    @Nonnull
    default public <P> P getRequiredProperty(@Nonnull String name, @Nonnull ArgumentConversionContext<P> context) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("type", context);
        return (P)this.getIntrospection().getProperty(name).map(prop -> {
            Optional converted = prop.get(this.getBean(), context);
            return converted.orElseThrow(() -> {
                ConversionError conversionError = context.getLastError().orElseGet(() -> new ConversionError((BeanProperty)prop, context){
                    final /* synthetic */ BeanProperty val$prop;
                    final /* synthetic */ ArgumentConversionContext val$context;
                    {
                        this.val$prop = beanProperty;
                        this.val$context = argumentConversionContext;
                    }

                    @Override
                    public Exception getCause() {
                        return new IntrospectionException("Property of type [" + this.val$prop.getType() + "] cannot be converted to type: " + this.val$context.getArgument().getType());
                    }

                    @Override
                    public Optional<Object> getOriginalValue() {
                        return Optional.ofNullable(this.val$prop.get(BeanWrapper.this.getBean()));
                    }
                });
                return new ConversionErrorException(context.getArgument(), conversionError);
            });
        }).orElseThrow(() -> new IntrospectionException("No property found for name: " + name));
    }

    @Nonnull
    default public <P> Optional<P> getProperty(@Nonnull String name, @Nonnull Class<P> type) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("type", type);
        Argument<P> argument = Argument.of(type);
        return this.getProperty(name, argument);
    }

    default public <P> Optional<P> getProperty(@Nonnull String name, Argument<P> type) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("type", type);
        ArgumentConversionContext<P> context = ConversionContext.of(type);
        return this.getProperty(name, context);
    }

    default public <P> Optional<P> getProperty(@Nonnull String name, ArgumentConversionContext<P> context) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("context", context);
        return this.getIntrospection().getProperty(name).flatMap(prop -> prop.get(this.getBean(), context));
    }

    default public BeanWrapper<T> setProperty(@Nonnull String name, @Nullable Object value) {
        ArgumentUtils.requireNonNull("name", name);
        this.getIntrospection().getProperty(name).ifPresent(prop -> prop.convertAndSet(this.getBean(), value));
        return this;
    }

    @Nonnull
    public static <T2> BeanWrapper<T2> getWrapper(@Nonnull T2 bean) {
        ArgumentUtils.requireNonNull("bean", bean);
        Class<?> aClass = bean.getClass();
        BeanIntrospection<?> introspection = BeanIntrospection.getIntrospection(aClass);
        return new DefaultBeanWrapper<T2>(bean, introspection);
    }

    @Nonnull
    public static <T2> BeanWrapper<T2> getWrapper(Class<T2> type, @Nonnull T2 bean) {
        ArgumentUtils.requireNonNull("type", type);
        ArgumentUtils.requireNonNull("bean", bean);
        BeanIntrospection<T2> introspection = BeanIntrospection.getIntrospection(type);
        return new DefaultBeanWrapper<T2>(bean, introspection);
    }
}

