/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.value;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.type.Argument;
import io.micronaut.core.value.PropertyNotFoundException;
import io.micronaut.core.value.ValueResolver;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface PropertyResolver
extends ValueResolver<String> {
    public boolean containsProperty(@Nonnull String var1);

    public boolean containsProperties(@Nonnull String var1);

    @Nonnull
    public <T> Optional<T> getProperty(@Nonnull String var1, @Nonnull ArgumentConversionContext<T> var2);

    @Nonnull
    default public <T> Optional<T> getProperty(@Nonnull String name, @Nonnull Argument<T> argument) {
        return this.getProperty(name, ConversionContext.of(argument));
    }

    @Nonnull
    default public Map<String, Object> getProperties(@Nonnull String name) {
        return this.getProperties(name, null);
    }

    @Nonnull
    default public Map<String, Object> getProperties(@Nullable String name, @Nullable StringConvention keyFormat) {
        return Collections.emptyMap();
    }

    @Nonnull
    default public <T> Optional<T> getProperty(@Nonnull String name, @Nonnull Class<T> requiredType, @Nonnull ConversionContext context) {
        return this.getProperty(name, context.with(Argument.of(requiredType)));
    }

    @Override
    @Nonnull
    default public <T> Optional<T> get(@Nonnull String name, @Nonnull ArgumentConversionContext<T> conversionContext) {
        return this.getProperty(name, conversionContext);
    }

    @Nonnull
    default public <T> Optional<T> getProperty(@Nonnull String name, @Nonnull Class<T> requiredType) {
        return this.getProperty(name, requiredType, (T)ConversionContext.DEFAULT);
    }

    @Nullable
    default public <T> T getProperty(@Nonnull String name, @Nonnull Class<T> requiredType, @Nullable T defaultValue) {
        return this.getProperty(name, requiredType).orElse(defaultValue);
    }

    @Nonnull
    default public <T> T getRequiredProperty(@Nonnull String name, @Nonnull Class<T> requiredType) throws PropertyNotFoundException {
        return this.getProperty(name, requiredType).orElseThrow(() -> new PropertyNotFoundException(name, requiredType));
    }

    public static String nameOf(String ... path) {
        return String.join((CharSequence)".", path);
    }
}

