/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.proxy;

import groovy.lang.GroovyObject;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import org.codehaus.groovy.transform.trait.Traits;
import org.grails.datastore.mapping.collection.PersistentCollection;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.AssociationQueryExecutor;
import org.grails.datastore.mapping.proxy.AssociationQueryProxyHandler;
import org.grails.datastore.mapping.proxy.EntityProxy;
import org.grails.datastore.mapping.proxy.ProxyFactory;
import org.grails.datastore.mapping.proxy.SessionEntityProxyMethodHandler;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.datastore.mapping.reflect.ReflectionUtils;

public class JavassistProxyFactory
implements ProxyFactory {
    private static final Map<Class, Class> PROXY_FACTORIES = new ConcurrentHashMap<Class, Class>();
    private static final Map<Class, Class> ID_TYPES = new ConcurrentHashMap<Class, Class>();
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Set<String> EXCLUDES = new HashSet<String>(Arrays.asList("$getStaticMetaClass"));
    private static final String DATASTORE_PACKAGE_PREFIX = "org.grails.datastore.";
    private static final String DATASTORE_PACKAGE_UNDER_SCORE_PREFIX = "org.grails.datastore.".replace('.', '_');

    @Override
    public boolean isProxy(Object object) {
        return object instanceof EntityProxy || object instanceof PersistentCollection;
    }

    @Override
    public Serializable getIdentifier(Object obj) {
        if (obj instanceof EntityProxy) {
            return ((EntityProxy)obj).getProxyKey();
        }
        return null;
    }

    @Override
    public Class<?> getProxiedClass(Object o) {
        if (this.isProxy(o)) {
            return o.getClass().getSuperclass();
        }
        return o.getClass();
    }

    @Override
    public void initialize(Object o) {
        if (o instanceof EntityProxy) {
            ((EntityProxy)o).initialize();
        } else if (o instanceof PersistentCollection) {
            ((PersistentCollection)o).initialize();
        }
    }

    @Override
    public boolean isInitialized(Object object) {
        if (!this.isProxy(object)) {
            return true;
        }
        if (object instanceof EntityProxy) {
            return ((EntityProxy)object).isInitialized();
        }
        if (object instanceof PersistentCollection) {
            return ((PersistentCollection)object).isInitialized();
        }
        return true;
    }

    @Override
    public boolean isInitialized(Object object, String associationName) {
        Object value = ClassPropertyFetcher.getInstancePropertyValue(object, associationName);
        return value == null || this.isInitialized(value);
    }

    @Override
    public Object unwrap(Object object) {
        if (this.isProxy(object) && object instanceof EntityProxy) {
            return ((EntityProxy)object).getTarget();
        }
        return object;
    }

    @Override
    public <T> T createProxy(Session session, Class<T> type, Serializable key) {
        return (T)this.getProxyInstance(session, type, key);
    }

    @Override
    public <T, K extends Serializable> T createProxy(Session session, AssociationQueryExecutor<K, T> executor, K associationKey) {
        MethodHandler mi = this.createMethodHandler(session, executor, associationKey);
        Class proxyClass = this.getProxyClass(executor.getIndexedEntity().getJavaClass());
        Object proxy = ReflectionUtils.instantiate(proxyClass);
        ((ProxyObject)proxy).setHandler(mi);
        return proxy;
    }

    protected Object createProxiedInstance(Session session, Class cls, Class proxyClass, Serializable id) {
        MethodHandler mi = this.createMethodHandler(session, cls, proxyClass, id);
        Object proxy = ReflectionUtils.instantiate(proxyClass);
        ((ProxyObject)proxy).setHandler(mi);
        return proxy;
    }

    protected <K extends Serializable, T> MethodHandler createMethodHandler(Session session, AssociationQueryExecutor<K, T> executor, K associationKey) {
        return new AssociationQueryProxyHandler(session, executor, associationKey);
    }

    protected MethodHandler createMethodHandler(Session session, Class cls, Class proxyClass, Serializable id) {
        return new SessionEntityProxyMethodHandler(proxyClass, session, cls, id);
    }

    protected Object getProxyInstance(Session session, Class type, Serializable id) {
        Class proxyClass = this.getProxyClass(type);
        return this.createProxiedInstance(session, type, proxyClass, id);
    }

    protected Class getProxyClass(Class type) {
        Class proxyClass = PROXY_FACTORIES.get(type);
        if (proxyClass == null) {
            javassist.util.proxy.ProxyFactory pf = new javassist.util.proxy.ProxyFactory();
            pf.setSuperclass(type);
            pf.setInterfaces(this.getProxyInterfaces());
            pf.setFilter(new MethodFilter(){

                public boolean isHandled(Method method) {
                    Class traitClass;
                    Traits.TraitBridge traitBridge = method.getAnnotation(Traits.TraitBridge.class);
                    if (traitBridge != null && (traitClass = traitBridge.traitClass()).getPackage().getName().startsWith(JavassistProxyFactory.DATASTORE_PACKAGE_PREFIX)) {
                        return false;
                    }
                    String methodName = method.getName();
                    if (methodName.contains("super$") || methodName.startsWith(DATASTORE_PACKAGE_UNDER_SCORE_PREFIX)) {
                        return false;
                    }
                    if (method.getParameterTypes().length == 0 && methodName.equals("finalize")) {
                        return false;
                    }
                    return !EXCLUDES.contains(methodName) && !method.isSynthetic() && !method.isBridge();
                }
            });
            proxyClass = pf.createClass();
            PROXY_FACTORIES.put(type, proxyClass);
            Method getIdMethod = org.springframework.util.ReflectionUtils.findMethod((Class)type, (String)"getId", (Class[])EMPTY_CLASS_ARRAY);
            Class<?> idType = getIdMethod.getReturnType();
            if (idType != null) {
                ID_TYPES.put(type, idType);
            }
        }
        return proxyClass;
    }

    protected Class[] getProxyInterfaces() {
        return new Class[]{EntityProxy.class, GroovyObject.class};
    }
}

