/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.api.parallel.ResourceAccessMode;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.DisplayNameUtils;
import org.junit.jupiter.engine.execution.ConditionEvaluator;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.Node;

@API(status=API.Status.INTERNAL, since="5.0")
public abstract class JupiterTestDescriptor
extends AbstractTestDescriptor
implements Node<JupiterEngineExecutionContext> {
    private static final Logger logger = LoggerFactory.getLogger(JupiterTestDescriptor.class);
    private static final ConditionEvaluator conditionEvaluator = new ConditionEvaluator();
    protected final JupiterConfiguration configuration;

    JupiterTestDescriptor(UniqueId uniqueId, AnnotatedElement element, Supplier<String> displayNameSupplier, TestSource source, JupiterConfiguration configuration) {
        this(uniqueId, DisplayNameUtils.determineDisplayName(element, displayNameSupplier), source, configuration);
    }

    JupiterTestDescriptor(UniqueId uniqueId, String displayName, TestSource source, JupiterConfiguration configuration) {
        super(uniqueId, displayName, source);
        this.configuration = configuration;
    }

    protected static Set<TestTag> getTags(AnnotatedElement element) {
        return AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)element, Tag.class).stream().map(Tag::value).filter(tag -> {
            boolean isValid = TestTag.isValid((String)tag);
            if (!isValid) {
                logger.warn(() -> String.format("Configuration error: invalid tag syntax in @Tag(\"%s\") declaration on [%s]. Tag will be ignored.", tag, element));
            }
            return isValid;
        }).map(TestTag::create).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
    }

    public final Node.ExecutionMode getExecutionMode() {
        Optional<Node.ExecutionMode> executionMode = this.getExplicitExecutionMode();
        if (executionMode.isPresent()) {
            return executionMode.get();
        }
        Optional parent = this.getParent();
        while (parent.isPresent() && parent.get() instanceof JupiterTestDescriptor) {
            JupiterTestDescriptor jupiterParent = (JupiterTestDescriptor)((Object)parent.get());
            executionMode = jupiterParent.getExplicitExecutionMode();
            if (executionMode.isPresent()) {
                return executionMode.get();
            }
            executionMode = jupiterParent.getDefaultChildExecutionMode();
            if (executionMode.isPresent()) {
                return executionMode.get();
            }
            parent = jupiterParent.getParent();
        }
        return JupiterTestDescriptor.toExecutionMode(this.configuration.getDefaultExecutionMode());
    }

    protected Optional<Node.ExecutionMode> getExplicitExecutionMode() {
        return Optional.empty();
    }

    protected Optional<Node.ExecutionMode> getDefaultChildExecutionMode() {
        return Optional.empty();
    }

    protected Optional<Node.ExecutionMode> getExecutionModeFromAnnotation(AnnotatedElement element) {
        return AnnotationUtils.findAnnotation((AnnotatedElement)element, Execution.class).map(Execution::value).map(JupiterTestDescriptor::toExecutionMode);
    }

    public static Node.ExecutionMode toExecutionMode(ExecutionMode mode) {
        switch (mode) {
            case CONCURRENT: {
                return Node.ExecutionMode.CONCURRENT;
            }
            case SAME_THREAD: {
                return Node.ExecutionMode.SAME_THREAD;
            }
        }
        throw new JUnitException("Unknown ExecutionMode: " + mode);
    }

    protected Set<ExclusiveResource> getExclusiveResourcesFromAnnotation(AnnotatedElement element) {
        return AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)element, ResourceLock.class).stream().map(resource -> new ExclusiveResource(resource.value(), JupiterTestDescriptor.toLockMode(resource.mode()))).collect(Collectors.toSet());
    }

    private static ExclusiveResource.LockMode toLockMode(ResourceAccessMode mode) {
        switch (mode) {
            case READ: {
                return ExclusiveResource.LockMode.READ;
            }
            case READ_WRITE: {
                return ExclusiveResource.LockMode.READ_WRITE;
            }
        }
        throw new JUnitException("Unknown ResourceAccessMode: " + mode);
    }

    public Node.SkipResult shouldBeSkipped(JupiterEngineExecutionContext context) throws Exception {
        context.getThrowableCollector().assertEmpty();
        ConditionEvaluationResult evaluationResult = conditionEvaluator.evaluate(context.getExtensionRegistry(), context.getConfiguration(), context.getExtensionContext());
        return this.toSkipResult(evaluationResult);
    }

    private Node.SkipResult toSkipResult(ConditionEvaluationResult evaluationResult) {
        if (evaluationResult.isDisabled()) {
            return Node.SkipResult.skip((String)evaluationResult.getReason().orElse("<unknown>"));
        }
        return Node.SkipResult.doNotSkip();
    }

    public abstract JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext var1) throws Exception;

    public void cleanUp(JupiterEngineExecutionContext context) throws Exception {
        context.close();
    }

    protected void executeAndMaskThrowable(Executable executable) {
        try {
            executable.execute();
        }
        catch (Throwable throwable) {
            ExceptionUtils.throwAsUncheckedException((Throwable)throwable);
        }
    }
}

