/*
 * Decompiled with CFR 0.152.
 */
package org.testng.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.collections.Maps;

public abstract class MultiMap<K, V, C extends Collection<V>> {
    protected final Map<K, C> m_objects;

    protected MultiMap(boolean bl) {
        this.m_objects = bl ? Maps.newLinkedHashMap() : Maps.newHashMap();
    }

    protected abstract C createValue();

    public boolean put(K k, V v) {
        boolean bl = true;
        Collection<Object> collection = (Collection)this.m_objects.get(k);
        if (collection == null) {
            bl = false;
            collection = this.createValue();
            this.m_objects.put(k, collection);
        }
        return collection.add(v) && bl;
    }

    public C get(K k) {
        Collection<Object> collection = (Collection)this.m_objects.get(k);
        if (collection == null) {
            collection = this.createValue();
            this.m_objects.put(k, collection);
        }
        return (C)collection;
    }

    @Deprecated
    public List<K> getKeys() {
        return new ArrayList<K>(this.keySet());
    }

    public Set<K> keySet() {
        return new HashSet<K>(this.m_objects.keySet());
    }

    public boolean containsKey(K k) {
        return this.m_objects.containsKey(k);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Set<K> set = this.keySet();
        for (K k : set) {
            stringBuilder.append("\n    ").append(k).append(" <-- ");
            for (Object e : (Collection)this.m_objects.get(k)) {
                stringBuilder.append(e).append(" ");
            }
        }
        return stringBuilder.toString();
    }

    public boolean isEmpty() {
        return this.m_objects.size() == 0;
    }

    @Deprecated
    public int getSize() {
        return this.size();
    }

    public int size() {
        return this.m_objects.size();
    }

    @Deprecated
    public C remove(K k) {
        return this.removeAll(k);
    }

    public boolean remove(K k, V v) {
        return this.get(k).remove(v);
    }

    public C removeAll(K k) {
        return (C)((Collection)this.m_objects.remove(k));
    }

    @Deprecated
    public Set<Map.Entry<K, C>> getEntrySet() {
        return this.entrySet();
    }

    public Set<Map.Entry<K, C>> entrySet() {
        return this.m_objects.entrySet();
    }

    @Deprecated
    public Collection<C> getValues() {
        return this.values();
    }

    public Collection<C> values() {
        return this.m_objects.values();
    }

    public boolean putAll(K k, Collection<? extends V> collection) {
        boolean bl = false;
        for (V v : collection) {
            bl = this.put(k, v) || bl;
        }
        return bl;
    }
}

